/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.internal;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.util.Log;
import android.util.Range;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.OptIn;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CameraIdentifier;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CompositionSettings;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalSessionConfig;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.Logger;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.UseCase;
import androidx.camera.core.ViewPort;
import androidx.camera.core.concurrent.CameraCoordinator;
import androidx.camera.core.featuregroup.GroupableFeature;
import androidx.camera.core.featuregroup.impl.ResolvedFeatureGroup;
import androidx.camera.core.impl.AdapterCameraInfo;
import androidx.camera.core.impl.AdapterCameraInternal;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.CalculatedUseCaseInfo;
import androidx.camera.core.internal.StreamSpecQueryResult;
import androidx.camera.core.internal.StreamSpecsCalculator;
import androidx.camera.core.internal.TargetConfig;
import androidx.camera.core.internal.ViewPorts;
import androidx.camera.core.internal.compat.workaround.StreamSharingForceEnabler;
import androidx.camera.core.processing.TargetUtils;
import androidx.camera.core.streamsharing.StreamSharing;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CameraUseCaseAdapter
implements Camera {
    private final @NonNull AdapterCameraInternal mCameraInternal;
    private final @Nullable AdapterCameraInternal mSecondaryCameraInternal;
    private final UseCaseConfigFactory mUseCaseConfigFactory;
    private static final String TAG = "CameraUseCaseAdapter";
    private final CameraIdentifier mCameraIdentifier;
    @GuardedBy(value="mLock")
    private final List<UseCase> mAppUseCases = new ArrayList<UseCase>();
    @GuardedBy(value="mLock")
    private final List<UseCase> mCameraUseCases = new ArrayList<UseCase>();
    @GuardedBy(value="mLock")
    private final CameraCoordinator mCameraCoordinator;
    @GuardedBy(value="mLock")
    private @Nullable ViewPort mViewPort;
    @GuardedBy(value="mLock")
    private @NonNull List<CameraEffect> mEffects = Collections.emptyList();
    @GuardedBy(value="mLock")
    private int mSessionType = 0;
    @GuardedBy(value="mLock")
    private @NonNull Range<Integer> mFrameRate = StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED;
    @GuardedBy(value="mLock")
    private final @NonNull CameraConfig mCameraConfig;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mAttached = true;
    @GuardedBy(value="mLock")
    private Config mInteropConfig = null;
    @GuardedBy(value="mLock")
    private @Nullable UseCase mPlaceholderForExtensions;
    @GuardedBy(value="mLock")
    private @Nullable StreamSharing mStreamSharing;
    private final @NonNull CompositionSettings mCompositionSettings;
    private final @NonNull CompositionSettings mSecondaryCompositionSettings;
    private final StreamSharingForceEnabler mStreamSharingForceEnabler = new StreamSharingForceEnabler();
    private final StreamSpecsCalculator mStreamSpecsCalculator;

    @VisibleForTesting
    public CameraUseCaseAdapter(@NonNull CameraInternal camera, @NonNull CameraCoordinator cameraCoordinator, @NonNull StreamSpecsCalculator streamSpecsCalculator, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        this(camera, null, new AdapterCameraInfo(camera.getCameraInfoInternal(), CameraConfigs.defaultConfig()), null, CompositionSettings.DEFAULT, CompositionSettings.DEFAULT, cameraCoordinator, streamSpecsCalculator, useCaseConfigFactory);
    }

    public CameraUseCaseAdapter(@NonNull CameraInternal camera, @Nullable CameraInternal secondaryCamera, @NonNull AdapterCameraInfo adapterCameraInfo, @Nullable AdapterCameraInfo secondaryAdapterCameraInfo, @NonNull CompositionSettings compositionSettings, @NonNull CompositionSettings secondaryCompositionSettings, @NonNull CameraCoordinator cameraCoordinator, @NonNull StreamSpecsCalculator streamSpecsCalculator, @NonNull UseCaseConfigFactory useCaseConfigFactory) {
        this.mCameraConfig = adapterCameraInfo.getCameraConfig();
        this.mCameraInternal = new AdapterCameraInternal(camera, adapterCameraInfo);
        this.mSecondaryCameraInternal = secondaryCamera != null && secondaryAdapterCameraInfo != null ? new AdapterCameraInternal(secondaryCamera, secondaryAdapterCameraInfo) : null;
        this.mCompositionSettings = compositionSettings;
        this.mSecondaryCompositionSettings = secondaryCompositionSettings;
        this.mCameraCoordinator = cameraCoordinator;
        this.mUseCaseConfigFactory = useCaseConfigFactory;
        this.mCameraIdentifier = CameraIdentifier.fromAdapterInfos(adapterCameraInfo, secondaryAdapterCameraInfo);
        this.mStreamSpecsCalculator = streamSpecsCalculator;
    }

    public @NonNull CameraIdentifier getAdapterIdentifier() {
        return this.mCameraIdentifier;
    }

    public boolean isEquivalent(@NonNull CameraUseCaseAdapter cameraUseCaseAdapter) {
        return this.getAdapterIdentifier().equals(cameraUseCaseAdapter.getAdapterIdentifier());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewPort(@Nullable ViewPort viewPort) {
        Object object = this.mLock;
        synchronized (object) {
            this.mViewPort = viewPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEffects(@NonNull List<CameraEffect> effects) {
        Object object = this.mLock;
        synchronized (object) {
            this.mEffects = effects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable ViewPort getViewPort() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mViewPort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull List<CameraEffect> getEffects() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mEffects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSessionType(int sessionType) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSessionType = sessionType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSessionType() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSessionType;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFrameRate(@NonNull Range<Integer> frameRate) {
        Object object = this.mLock;
        synchronized (object) {
            this.mFrameRate = frameRate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Range<Integer> getFrameRate() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mFrameRate;
        }
    }

    public void addUseCases(@NonNull Collection<UseCase> appUseCasesToAdd) throws CameraException {
        this.addUseCases(appUseCasesToAdd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OptIn(markerClass={ExperimentalSessionConfig.class})
    public void addUseCases(@NonNull Collection<UseCase> appUseCasesToAdd, @Nullable ResolvedFeatureGroup featureGroup) throws CameraException {
        Logger.d(TAG, "addUseCases: appUseCasesToAdd = " + appUseCasesToAdd + ", featureGroup = " + featureGroup);
        Object object = this.mLock;
        synchronized (object) {
            this.applyCameraConfig();
            LinkedHashSet<UseCase> appUseCases = new LinkedHashSet<UseCase>(this.mAppUseCases);
            appUseCases.addAll(appUseCasesToAdd);
            Map<UseCase, Set<GroupableFeature>> previousFeatureGroupMap = CameraUseCaseAdapter.applyFeatureGroup(appUseCases, featureGroup);
            try {
                this.applyCalculatedUseCaseChanges(this.calculateAndValidateUseCases(appUseCases, this.mSecondaryCameraInternal != null, false));
            }
            catch (IllegalArgumentException e) {
                CameraUseCaseAdapter.restoreFeatureGroup(previousFeatureGroupMap);
                throw new CameraException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @OptIn(markerClass={ExperimentalSessionConfig.class})
    public @NonNull CalculatedUseCaseInfo simulateAddUseCases(@NonNull Collection<UseCase> appUseCasesToAdd, @Nullable ResolvedFeatureGroup featureGroup, boolean findMaxSupportedFrameRate) throws CameraException {
        Logger.d(TAG, "simulateAddUseCases: appUseCasesToAdd = " + appUseCasesToAdd + ", featureGroup = " + featureGroup);
        Object object = this.mLock;
        synchronized (object) {
            this.applyCameraConfig();
            LinkedHashSet<UseCase> appUseCases = new LinkedHashSet<UseCase>(this.mAppUseCases);
            appUseCases.addAll(appUseCasesToAdd);
            Map<UseCase, Set<GroupableFeature>> previousFeatureGRoupMap = CameraUseCaseAdapter.applyFeatureGroup(appUseCases, featureGroup);
            try {
                CalculatedUseCaseInfo calculatedUseCaseInfo = this.calculateAndValidateUseCases(appUseCases, this.mSecondaryCameraInternal != null, findMaxSupportedFrameRate);
                return calculatedUseCaseInfo;
            }
            catch (IllegalArgumentException e) {
                throw new CameraException(e);
            }
            finally {
                CameraUseCaseAdapter.restoreFeatureGroup(previousFeatureGRoupMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUseCases(@NonNull Collection<UseCase> useCasesToRemove) {
        Object object = this.mLock;
        synchronized (object) {
            CameraUseCaseAdapter.clearFeatureGroup(useCasesToRemove);
            LinkedHashSet<UseCase> appUseCases = new LinkedHashSet<UseCase>(this.mAppUseCases);
            appUseCases.removeAll(useCasesToRemove);
            this.applyCalculatedUseCaseChanges(this.calculateAndValidateUseCases(appUseCases, this.mSecondaryCameraInternal != null, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            this.removeUseCases(this.mAppUseCases);
        }
    }

    @GuardedBy(value="mLock")
    private CalculatedUseCaseInfo calculateAndValidateUseCases(@NonNull Collection<UseCase> appUseCases, boolean applyStreamSharing, boolean findMaxSupportedFrameRate) throws IllegalArgumentException {
        StreamSpecQueryResult primaryStreamSpecResult;
        this.checkUnsupportedFeatureCombinationAndThrow(appUseCases);
        if (!applyStreamSharing && this.shouldForceEnableStreamSharing(appUseCases)) {
            return this.calculateAndValidateUseCases(appUseCases, true, findMaxSupportedFrameRate);
        }
        StreamSharing streamSharing = this.createOrReuseStreamSharing(appUseCases, applyStreamSharing);
        UseCase placeholderForExtensions = this.calculatePlaceholderForExtensions(appUseCases, streamSharing);
        Collection<UseCase> cameraUseCases = CameraUseCaseAdapter.calculateCameraUseCases(appUseCases, placeholderForExtensions, streamSharing);
        ArrayList<UseCase> cameraUseCasesToAttach = new ArrayList<UseCase>(cameraUseCases);
        cameraUseCasesToAttach.removeAll(this.mCameraUseCases);
        ArrayList<UseCase> cameraUseCasesToKeep = new ArrayList<UseCase>(cameraUseCases);
        cameraUseCasesToKeep.retainAll(this.mCameraUseCases);
        ArrayList<UseCase> cameraUseCasesToDetach = new ArrayList<UseCase>(this.mCameraUseCases);
        cameraUseCasesToDetach.removeAll(cameraUseCases);
        Map<UseCase, ConfigPair> configs = CameraUseCaseAdapter.getConfigs(cameraUseCasesToAttach, this.mCameraConfig.getUseCaseConfigFactory(), this.mUseCaseConfigFactory, this.mSessionType, this.mFrameRate);
        StreamSpecQueryResult secondaryStreamSpecResult = null;
        boolean isFeatureComboInvocation = CameraUseCaseAdapter.isFeatureComboInvocation(cameraUseCasesToAttach, cameraUseCasesToKeep);
        try {
            primaryStreamSpecResult = this.mStreamSpecsCalculator.calculateSuggestedStreamSpecs(this.getCameraMode(), this.mCameraInternal.getCameraInfoInternal(), cameraUseCasesToAttach, cameraUseCasesToKeep, this.mCameraConfig, this.mSessionType, this.mFrameRate, isFeatureComboInvocation, findMaxSupportedFrameRate);
            if (this.mSecondaryCameraInternal != null) {
                secondaryStreamSpecResult = this.mStreamSpecsCalculator.calculateSuggestedStreamSpecs(this.getCameraMode(), Objects.requireNonNull(this.mSecondaryCameraInternal).getCameraInfoInternal(), cameraUseCasesToAttach, cameraUseCasesToKeep, this.mCameraConfig, this.mSessionType, this.mFrameRate, isFeatureComboInvocation, findMaxSupportedFrameRate);
            }
        }
        catch (IllegalArgumentException exception) {
            if (!applyStreamSharing && this.isStreamSharingAllowed()) {
                return this.calculateAndValidateUseCases(appUseCases, true, findMaxSupportedFrameRate);
            }
            throw exception;
        }
        return new CalculatedUseCaseInfo(appUseCases, cameraUseCases, cameraUseCasesToAttach, cameraUseCasesToKeep, cameraUseCasesToDetach, streamSharing, placeholderForExtensions, configs, primaryStreamSpecResult, secondaryStreamSpecResult);
    }

    @GuardedBy(value="mLock")
    private void applyCalculatedUseCaseChanges(@NonNull CalculatedUseCaseInfo info) {
        this.updateViewPortAndSensorToBufferMatrix(info.getPrimaryStreamSpecResult().getStreamSpecs(), info.getCameraUseCases());
        CameraUseCaseAdapter.updateEffects(this.mEffects, info.getCameraUseCases(), info.getAppUseCases());
        for (UseCase useCase : info.getCameraUseCasesToDetach()) {
            useCase.unbindFromCamera(this.mCameraInternal);
        }
        this.mCameraInternal.detachUseCases(info.getCameraUseCasesToDetach());
        if (this.mSecondaryCameraInternal != null) {
            for (UseCase useCase : info.getCameraUseCasesToDetach()) {
                useCase.unbindFromCamera(Objects.requireNonNull(this.mSecondaryCameraInternal));
            }
            Objects.requireNonNull(this.mSecondaryCameraInternal).detachUseCases(info.getCameraUseCasesToDetach());
        }
        if (info.getCameraUseCasesToDetach().isEmpty()) {
            for (UseCase useCase : info.getCameraUseCasesToKeep()) {
                StreamSpec newStreamSpec;
                Config config;
                Map<UseCase, StreamSpec> primaryStreamSpecMap = info.getPrimaryStreamSpecResult().getStreamSpecs();
                if (!primaryStreamSpecMap.containsKey(useCase) || (config = Objects.requireNonNull(newStreamSpec = primaryStreamSpecMap.get(useCase)).getImplementationOptions()) == null || !CameraUseCaseAdapter.hasImplementationOptionChanged(newStreamSpec, useCase.getSessionConfig())) continue;
                useCase.updateSuggestedStreamSpecImplementationOptions(config);
                if (!this.mAttached) continue;
                this.mCameraInternal.onUseCaseUpdated(useCase);
                if (this.mSecondaryCameraInternal == null) continue;
                Objects.requireNonNull(this.mSecondaryCameraInternal).onUseCaseUpdated(useCase);
            }
        }
        for (UseCase useCase : info.getCameraUseCasesToAttach()) {
            ConfigPair configPair = Objects.requireNonNull(info.getUseCaseConfigs().get(useCase));
            if (this.mSecondaryCameraInternal != null) {
                useCase.bindToCamera(this.mCameraInternal, Objects.requireNonNull(this.mSecondaryCameraInternal), configPair.mExtendedConfig, configPair.mCameraConfig);
                useCase.updateSuggestedStreamSpec((StreamSpec)Preconditions.checkNotNull((Object)info.getPrimaryStreamSpecResult().getStreamSpecs().get(useCase)), ((StreamSpecQueryResult)Preconditions.checkNotNull((Object)info.getSecondaryStreamSpecResult())).getStreamSpecs().get(useCase));
                continue;
            }
            useCase.bindToCamera(this.mCameraInternal, null, configPair.mExtendedConfig, configPair.mCameraConfig);
            useCase.updateSuggestedStreamSpec((StreamSpec)Preconditions.checkNotNull((Object)info.getPrimaryStreamSpecResult().getStreamSpecs().get(useCase)), null);
        }
        if (this.mAttached) {
            this.mCameraInternal.attachUseCases(info.getCameraUseCasesToAttach());
            if (this.mSecondaryCameraInternal != null) {
                Objects.requireNonNull(this.mSecondaryCameraInternal).attachUseCases(info.getCameraUseCasesToAttach());
            }
        }
        for (UseCase useCase : info.getCameraUseCasesToAttach()) {
            useCase.notifyState();
        }
        this.mAppUseCases.clear();
        this.mAppUseCases.addAll(info.getAppUseCases());
        this.mCameraUseCases.clear();
        this.mCameraUseCases.addAll(info.getCameraUseCases());
        this.mPlaceholderForExtensions = info.getPlaceholderForExtensions();
        this.mStreamSharing = info.getStreamSharing();
    }

    private void applyCameraConfig() {
        this.mCameraInternal.setExtendedConfig(this.mCameraConfig);
        if (this.mSecondaryCameraInternal != null) {
            this.mSecondaryCameraInternal.setExtendedConfig(this.mCameraConfig);
        }
    }

    @OptIn(markerClass={ExperimentalSessionConfig.class})
    private static @NonNull Map<UseCase, Set<GroupableFeature>> applyFeatureGroup(@NonNull Collection<UseCase> useCases, @Nullable ResolvedFeatureGroup featureGroup) {
        HashMap<UseCase, Set<GroupableFeature>> previousFeatureComboMap = new HashMap<UseCase, Set<GroupableFeature>>();
        for (UseCase useCase : useCases) {
            previousFeatureComboMap.put(useCase, useCase.getFeatureGroup());
            useCase.setFeatureGroup(featureGroup != null ? featureGroup.getFeatures() : null);
        }
        return previousFeatureComboMap;
    }

    @OptIn(markerClass={ExperimentalSessionConfig.class})
    private static void restoreFeatureGroup(Map<UseCase, @Nullable Set<@NonNull GroupableFeature>> previousFeatureComboMap) {
        for (Map.Entry<UseCase, Set<GroupableFeature>> entry : previousFeatureComboMap.entrySet()) {
            entry.getKey().setFeatureGroup(entry.getValue());
        }
    }

    private static void clearFeatureGroup(@NonNull Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            useCase.setFeatureGroup(null);
        }
    }

    @SafeVarargs
    private static boolean isFeatureComboInvocation(List<UseCase> ... useCaseLists) {
        boolean isFeatureComboInvocation = false;
        for (List<UseCase> useCases : useCaseLists) {
            for (UseCase useCase : useCases) {
                if (useCase.getFeatureGroup() == null) continue;
                isFeatureComboInvocation = true;
                break;
            }
            if (isFeatureComboInvocation) break;
        }
        return isFeatureComboInvocation;
    }

    private boolean isStreamSharingAllowed() {
        return !this.hasExtension() && this.mCameraCoordinator.getCameraOperatingMode() != 2 && this.mSessionType != 1;
    }

    private boolean shouldForceEnableStreamSharing(@NonNull Collection<UseCase> appUseCases) {
        if (this.hasExtension() && CameraUseCaseAdapter.hasVideoCapture(appUseCases)) {
            return true;
        }
        return this.mStreamSharingForceEnabler.shouldForceEnableStreamSharing(this.mCameraInternal.getCameraInfoInternal().getCameraId(), appUseCases);
    }

    private static boolean hasImplementationOptionChanged(StreamSpec streamSpec, SessionConfig sessionConfig) {
        Config newStreamSpecOptions = streamSpec.getImplementationOptions();
        Config sessionConfigOptions = sessionConfig.getImplementationOptions();
        if (Objects.requireNonNull(newStreamSpecOptions).listOptions().size() != sessionConfig.getImplementationOptions().listOptions().size()) {
            return true;
        }
        for (Config.Option<?> newOption : newStreamSpecOptions.listOptions()) {
            if (sessionConfigOptions.containsOption(newOption) && Objects.equals(sessionConfigOptions.retrieveOption(newOption), newStreamSpecOptions.retrieveOption(newOption))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getCameraMode() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCameraCoordinator.getCameraOperatingMode() == 2) {
                return 1;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasExtension() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig.getSessionProcessor(null) != null;
        }
    }

    private @NonNull Set<UseCase> getStreamSharingChildren(@NonNull Collection<UseCase> appUseCases, boolean forceSharingToPreviewAndVideo) {
        HashSet<UseCase> children = new HashSet<UseCase>();
        int sharingTargets = this.getSharingTargets(forceSharingToPreviewAndVideo);
        for (UseCase useCase : appUseCases) {
            Preconditions.checkArgument((!StreamSharing.isStreamSharing(useCase) ? 1 : 0) != 0, (Object)"Only support one level of sharing for now.");
            if (!useCase.isEffectTargetsSupported(sharingTargets)) continue;
            children.add(useCase);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getSharingTargets(boolean forceSharingToPreviewAndVideo) {
        Object object = this.mLock;
        synchronized (object) {
            int sharingTargets;
            CameraEffect sharingEffect = null;
            for (CameraEffect effect : this.mEffects) {
                if (TargetUtils.getNumberOfTargets(effect.getTargets()) <= 1) continue;
                Preconditions.checkState((sharingEffect == null ? 1 : 0) != 0, (String)"Can only have one sharing effect.");
                sharingEffect = effect;
            }
            int n = sharingTargets = sharingEffect == null ? 0 : sharingEffect.getTargets();
            if (forceSharingToPreviewAndVideo) {
                sharingTargets |= 3;
            }
            return sharingTargets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable StreamSharing createOrReuseStreamSharing(@NonNull Collection<UseCase> appUseCases, boolean forceSharingToPreviewAndVideo) {
        Object object = this.mLock;
        synchronized (object) {
            Set<UseCase> newChildren = this.getStreamSharingChildren(appUseCases, forceSharingToPreviewAndVideo);
            if (!(newChildren.size() >= 2 || this.hasExtension() && CameraUseCaseAdapter.hasVideoCapture(newChildren))) {
                return null;
            }
            if (this.mStreamSharing != null && this.mStreamSharing.getChildren().equals(newChildren)) {
                this.mStreamSharing.updateFeatureGroup(newChildren);
                return Objects.requireNonNull(this.mStreamSharing);
            }
            if (!CameraUseCaseAdapter.isStreamSharingChildrenCombinationValid(newChildren)) {
                return null;
            }
            return new StreamSharing(this.mCameraInternal, this.mSecondaryCameraInternal, this.mCompositionSettings, this.mSecondaryCompositionSettings, newChildren, this.mUseCaseConfigFactory);
        }
    }

    static boolean isStreamSharingChildrenCombinationValid(@NonNull Collection<UseCase> children) {
        int[] validChildrenTypes = new int[]{1, 2, 4};
        HashSet<Integer> childrenTypes = new HashSet<Integer>();
        for (UseCase child : children) {
            for (int type : validChildrenTypes) {
                if (!child.isEffectTargetsSupported(type)) continue;
                if (childrenTypes.contains(type)) {
                    return false;
                }
                childrenTypes.add(type);
            }
        }
        return true;
    }

    static Collection<UseCase> calculateCameraUseCases(@NonNull Collection<UseCase> appUseCases, @Nullable UseCase placeholderForExtensions, @Nullable StreamSharing streamSharing) {
        ArrayList<UseCase> useCases = new ArrayList<UseCase>(appUseCases);
        if (placeholderForExtensions != null) {
            useCases.add(placeholderForExtensions);
        }
        if (streamSharing != null) {
            useCases.add(streamSharing);
            useCases.removeAll(streamSharing.getChildren());
        }
        return useCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull List<UseCase> getUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<UseCase>(this.mAppUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public @NonNull Collection<UseCase> getCameraUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            return new ArrayList<UseCase>(this.mCameraUseCases);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAttached) {
                if (!this.mCameraUseCases.isEmpty()) {
                    this.mCameraInternal.setExtendedConfig(this.mCameraConfig);
                    if (this.mSecondaryCameraInternal != null) {
                        this.mSecondaryCameraInternal.setExtendedConfig(this.mCameraConfig);
                    }
                }
                this.mCameraInternal.attachUseCases(this.mCameraUseCases);
                if (this.mSecondaryCameraInternal != null) {
                    this.mSecondaryCameraInternal.attachUseCases(this.mCameraUseCases);
                }
                this.restoreInteropConfig();
                for (UseCase useCase : this.mCameraUseCases) {
                    useCase.notifyState();
                }
                this.mAttached = true;
            }
        }
    }

    public void setActiveResumingMode(boolean enabled) {
        this.mCameraInternal.setActiveResumingMode(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachUseCases() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAttached) {
                this.mCameraInternal.detachUseCases(new ArrayList<UseCase>(this.mCameraUseCases));
                if (this.mSecondaryCameraInternal != null) {
                    this.mSecondaryCameraInternal.detachUseCases(new ArrayList<UseCase>(this.mCameraUseCases));
                }
                this.cacheInteropConfig();
                this.mAttached = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreInteropConfig() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mInteropConfig != null) {
                this.mCameraInternal.getCameraControlInternal().addInteropConfig(this.mInteropConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheInteropConfig() {
        Object object = this.mLock;
        synchronized (object) {
            CameraControlInternal cameraControlInternal = this.mCameraInternal.getCameraControlInternal();
            this.mInteropConfig = cameraControlInternal.getInteropConfig();
            cameraControlInternal.clearInteropConfig();
        }
    }

    @VisibleForTesting
    static void updateEffects(@NonNull List<CameraEffect> effects, @NonNull Collection<UseCase> cameraUseCases, @NonNull Collection<UseCase> appUseCases) {
        List<CameraEffect> unusedEffects = CameraUseCaseAdapter.setEffectsOnUseCases(effects, cameraUseCases);
        ArrayList<UseCase> appOnlyUseCases = new ArrayList<UseCase>(appUseCases);
        appOnlyUseCases.removeAll(cameraUseCases);
        unusedEffects = CameraUseCaseAdapter.setEffectsOnUseCases(unusedEffects, appOnlyUseCases);
        if (!unusedEffects.isEmpty()) {
            Logger.w(TAG, "Unused effects: " + unusedEffects);
        }
    }

    private static @NonNull List<CameraEffect> setEffectsOnUseCases(@NonNull List<CameraEffect> effects, @NonNull Collection<UseCase> useCases) {
        ArrayList<CameraEffect> unusedEffects = new ArrayList<CameraEffect>(effects);
        for (UseCase useCase : useCases) {
            useCase.setEffect(null);
            for (CameraEffect effect : effects) {
                if (!useCase.isEffectTargetsSupported(effect.getTargets())) continue;
                Preconditions.checkState((useCase.getEffect() == null ? 1 : 0) != 0, (String)(useCase + " already has effect" + useCase.getEffect()));
                useCase.setEffect(effect);
                unusedEffects.remove(effect);
            }
        }
        return unusedEffects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewPortAndSensorToBufferMatrix(@NonNull Map<UseCase, StreamSpec> suggestedStreamSpecMap, @NonNull Collection<UseCase> useCases) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mViewPort != null && !useCases.isEmpty()) {
                int lensFacing = this.mCameraInternal.getCameraInfoInternal().getLensFacing();
                boolean isFrontCamera = lensFacing == 0;
                Map<UseCase, Rect> cropRectMap = ViewPorts.calculateViewPortRects(this.mCameraInternal.getCameraInfoInternal().getSensorRect(), isFrontCamera, this.mViewPort.getAspectRatio(), this.mCameraInternal.getCameraInfoInternal().getSensorRotationDegrees(this.mViewPort.getRotation()), this.mViewPort.getScaleType(), this.mViewPort.getLayoutDirection(), suggestedStreamSpecMap);
                for (UseCase useCase : useCases) {
                    useCase.setViewPortCropRect((Rect)Preconditions.checkNotNull((Object)cropRectMap.get(useCase)));
                }
            }
            for (UseCase useCase : useCases) {
                useCase.setSensorToBufferTransformMatrix(CameraUseCaseAdapter.calculateSensorToBufferTransformMatrix(this.mCameraInternal.getCameraInfoInternal().getSensorRect(), ((StreamSpec)Preconditions.checkNotNull((Object)suggestedStreamSpecMap.get(useCase))).getResolution()));
            }
        }
    }

    private static @NonNull Matrix calculateSensorToBufferTransformMatrix(@NonNull Rect fullSensorRect, @NonNull Size useCaseSize) {
        Preconditions.checkArgument((fullSensorRect.width() > 0 && fullSensorRect.height() > 0 ? 1 : 0) != 0, (Object)"Cannot compute viewport crop rects zero sized sensor rect.");
        RectF fullSensorRectF = new RectF(fullSensorRect);
        Matrix sensorToUseCaseTransformation = new Matrix();
        RectF srcRect = new RectF(0.0f, 0.0f, (float)useCaseSize.getWidth(), (float)useCaseSize.getHeight());
        sensorToUseCaseTransformation.setRectToRect(srcRect, fullSensorRectF, Matrix.ScaleToFit.CENTER);
        sensorToUseCaseTransformation.invert(sensorToUseCaseTransformation);
        return sensorToUseCaseTransformation;
    }

    static Map<UseCase, ConfigPair> getConfigs(@NonNull Collection<UseCase> useCases, @NonNull UseCaseConfigFactory extendedFactory, @NonNull UseCaseConfigFactory cameraFactory, int sessionType, @NonNull Range<Integer> targetFrameRate) {
        HashMap<UseCase, ConfigPair> configs = new HashMap<UseCase, ConfigPair>();
        for (UseCase useCase : useCases) {
            UseCaseConfig<?> extendedConfig = StreamSharing.isStreamSharing(useCase) ? CameraUseCaseAdapter.generateExtendedStreamSharingConfigFromPreview(extendedFactory, (StreamSharing)useCase) : useCase.getDefaultConfig(false, extendedFactory);
            UseCaseConfig<?> cameraConfig = useCase.getDefaultConfig(true, cameraFactory);
            cameraConfig = CameraUseCaseAdapter.attachUseCaseSharedConfigs(useCase, cameraConfig, sessionType, targetFrameRate);
            configs.put(useCase, new ConfigPair(extendedConfig, cameraConfig));
        }
        return configs;
    }

    private static @NonNull UseCaseConfig<?> attachUseCaseSharedConfigs(@NonNull UseCase useCase, @Nullable UseCaseConfig<?> useCaseConfig, int sessionType, @NonNull Range<Integer> targetFrameRate) {
        MutableOptionsBundle mutableConfig = useCaseConfig != null ? MutableOptionsBundle.from(useCaseConfig) : MutableOptionsBundle.create();
        mutableConfig.insertOption(UseCaseConfig.OPTION_SESSION_TYPE, sessionType);
        if (!StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED.equals(targetFrameRate)) {
            mutableConfig.insertOption(UseCaseConfig.OPTION_TARGET_FRAME_RATE, Config.OptionPriority.HIGH_PRIORITY_REQUIRED, targetFrameRate);
            mutableConfig.insertOption(UseCaseConfig.OPTION_IS_STRICT_FRAME_RATE_REQUIRED, true);
        }
        return useCase.getUseCaseConfigBuilder(mutableConfig).getUseCaseConfig();
    }

    private static UseCaseConfig<?> generateExtendedStreamSharingConfigFromPreview(@NonNull UseCaseConfigFactory extendedFactory, @NonNull StreamSharing streamSharing) {
        Preview preview = new Preview.Builder().build();
        UseCaseConfig<?> previewConfig = preview.getDefaultConfig(false, extendedFactory);
        if (previewConfig == null) {
            return null;
        }
        MutableOptionsBundle mutableConfig = MutableOptionsBundle.from(previewConfig);
        mutableConfig.removeOption(TargetConfig.OPTION_TARGET_CLASS);
        return streamSharing.getUseCaseConfigBuilder(mutableConfig).getUseCaseConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkUnsupportedFeatureCombinationAndThrow(@NonNull Collection<UseCase> useCases) throws IllegalArgumentException {
        if (this.hasExtension()) {
            if (CameraUseCaseAdapter.hasNonSdrConfig(useCases)) {
                throw new IllegalArgumentException("Extensions are only supported for use with standard dynamic range.");
            }
            if (CameraUseCaseAdapter.hasRawImageCapture(useCases)) {
                throw new IllegalArgumentException("Extensions are not supported for use with Raw image capture.");
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mEffects.isEmpty() && (CameraUseCaseAdapter.hasUltraHdrImageCapture(useCases) || CameraUseCaseAdapter.hasRawImageCapture(useCases))) {
                throw new IllegalArgumentException("Ultra HDR image and Raw capture does not support for use with CameraEffect.");
            }
        }
    }

    private static boolean hasNonSdrConfig(@NonNull Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            DynamicRange dynamicRange = useCase.getCurrentConfig().getDynamicRange();
            if (!CameraUseCaseAdapter.isNotSdr(dynamicRange)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNotSdr(@NonNull DynamicRange dynamicRange) {
        boolean is10Bit = dynamicRange.getBitDepth() == 10;
        boolean isHdr = dynamicRange.getEncoding() != 1 && dynamicRange.getEncoding() != 0;
        return is10Bit || isHdr;
    }

    private static boolean hasUltraHdrImageCapture(@NonNull Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            UseCaseConfig<?> config;
            if (!CameraUseCaseAdapter.isImageCapture(useCase) || !(config = useCase.getCurrentConfig()).containsOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT) || (Integer)Preconditions.checkNotNull((Object)config.retrieveOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT)) != 1) continue;
            return true;
        }
        return false;
    }

    private static boolean hasRawImageCapture(@NonNull Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            UseCaseConfig<?> config;
            if (!CameraUseCaseAdapter.isImageCapture(useCase) || !(config = useCase.getCurrentConfig()).containsOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT) || (Integer)Preconditions.checkNotNull((Object)config.retrieveOption(ImageCaptureConfig.OPTION_OUTPUT_FORMAT)) != 2) continue;
            return true;
        }
        return false;
    }

    @Override
    public @NonNull CameraControl getCameraControl() {
        return this.mCameraInternal.getCameraControl();
    }

    @Override
    public @NonNull CameraInfo getCameraInfo() {
        return this.mCameraInternal.getCameraInfo();
    }

    public @Nullable CameraInfo getSecondaryCameraInfo() {
        return this.mSecondaryCameraInternal != null ? this.mSecondaryCameraInternal.getCameraInfo() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull CameraConfig getExtendedConfig() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig;
        }
    }

    @Override
    public boolean isUseCasesCombinationSupported(boolean withStreamSharing, UseCase ... useCases) {
        Collection<UseCase> useCasesToVerify = Arrays.asList(useCases);
        if (withStreamSharing) {
            try {
                StreamSharing streamSharing = this.createOrReuseStreamSharing(useCasesToVerify, true);
                useCasesToVerify = CameraUseCaseAdapter.calculateCameraUseCases(useCasesToVerify, null, streamSharing);
            }
            catch (IllegalArgumentException e) {
                Logger.d(TAG, "Unable to apply StreamSharing", e);
                return false;
            }
        }
        return this.mCameraInternal.getCameraInfoInternal().isUseCaseCombinationSupported(new ArrayList<UseCase>(useCasesToVerify), this.getCameraMode(), false, this.mCameraConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable UseCase calculatePlaceholderForExtensions(@NonNull Collection<UseCase> appUseCases, @Nullable StreamSharing streamSharing) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<UseCase> useCasesToCheck = new ArrayList<UseCase>(appUseCases);
            if (streamSharing != null) {
                useCasesToCheck.add(streamSharing);
                useCasesToCheck.removeAll(streamSharing.getChildren());
            }
            UseCase placeholder = null;
            if (this.isCoexistingPreviewImageCaptureRequired()) {
                if (CameraUseCaseAdapter.isExtraPreviewRequired(useCasesToCheck)) {
                    placeholder = CameraUseCaseAdapter.isPreview(this.mPlaceholderForExtensions) ? this.mPlaceholderForExtensions : this.createExtraPreview();
                } else if (CameraUseCaseAdapter.isExtraImageCaptureRequired(useCasesToCheck)) {
                    placeholder = CameraUseCaseAdapter.isImageCapture(this.mPlaceholderForExtensions) ? this.mPlaceholderForExtensions : this.createExtraImageCapture();
                }
            }
            return placeholder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCoexistingPreviewImageCaptureRequired() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCameraConfig.getUseCaseCombinationRequiredRule() == 1;
        }
    }

    private static boolean isExtraPreviewRequired(@NonNull Collection<UseCase> useCases) {
        boolean hasPreviewOrStreamSharing = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : useCases) {
            if (CameraUseCaseAdapter.isPreview(useCase) || StreamSharing.isStreamSharing(useCase)) {
                hasPreviewOrStreamSharing = true;
                continue;
            }
            if (!CameraUseCaseAdapter.isImageCapture(useCase)) continue;
            hasImageCapture = true;
        }
        return hasImageCapture && !hasPreviewOrStreamSharing;
    }

    private static boolean isExtraImageCaptureRequired(@NonNull Collection<UseCase> useCases) {
        boolean hasPreviewOrStreamSharing = false;
        boolean hasImageCapture = false;
        for (UseCase useCase : useCases) {
            if (CameraUseCaseAdapter.isPreview(useCase) || StreamSharing.isStreamSharing(useCase)) {
                hasPreviewOrStreamSharing = true;
                continue;
            }
            if (!CameraUseCaseAdapter.isImageCapture(useCase)) continue;
            hasImageCapture = true;
        }
        return hasPreviewOrStreamSharing && !hasImageCapture;
    }

    static boolean hasVideoCapture(@NonNull Collection<UseCase> useCases) {
        for (UseCase useCase : useCases) {
            if (!CameraUseCaseAdapter.isVideoCapture(useCase)) continue;
            return true;
        }
        return false;
    }

    public static boolean isVideoCapture(@Nullable UseCase useCase) {
        if (useCase != null) {
            if (useCase.getCurrentConfig().containsOption(UseCaseConfig.OPTION_CAPTURE_TYPE)) {
                return useCase.getCurrentConfig().getCaptureType() == UseCaseConfigFactory.CaptureType.VIDEO_CAPTURE;
            }
            Log.e((String)TAG, (String)(useCase + " UseCase does not have capture type."));
        }
        return false;
    }

    private static boolean isPreview(@Nullable UseCase useCase) {
        return useCase instanceof Preview;
    }

    private static boolean isImageCapture(@Nullable UseCase useCase) {
        return useCase instanceof ImageCapture;
    }

    private Preview createExtraPreview() {
        Preview preview = new Preview.Builder().setTargetName("Preview-Extra").build();
        preview.setSurfaceProvider(surfaceRequest -> {
            SurfaceTexture surfaceTexture = new SurfaceTexture(0);
            surfaceTexture.setDefaultBufferSize(surfaceRequest.getResolution().getWidth(), surfaceRequest.getResolution().getHeight());
            surfaceTexture.detachFromGLContext();
            Surface surface = new Surface(surfaceTexture);
            surfaceRequest.provideSurface(surface, CameraXExecutors.directExecutor(), (Consumer<SurfaceRequest.Result>)((Consumer)surfaceResponse -> {
                surface.release();
                surfaceTexture.release();
            }));
        });
        return preview;
    }

    private ImageCapture createExtraImageCapture() {
        return new ImageCapture.Builder().setTargetName("ImageCapture-Extra").build();
    }

    public static final class CameraException
    extends Exception {
        public CameraException() {
        }

        public CameraException(@NonNull String message) {
            super(message);
        }

        public CameraException(@NonNull Throwable cause) {
            super(cause);
        }
    }

    public static class ConfigPair {
        UseCaseConfig<?> mExtendedConfig;
        UseCaseConfig<?> mCameraConfig;

        ConfigPair(UseCaseConfig<?> extendedConfig, UseCaseConfig<?> cameraConfig) {
            this.mExtendedConfig = extendedConfig;
            this.mCameraConfig = cameraConfig;
        }
    }
}

