/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.futures;

import androidx.arch.core.util.Function;
import androidx.camera.core.impl.utils.futures.AsyncFunction;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class FutureChain<V>
implements ListenableFuture<V> {
    private final @NonNull ListenableFuture<V> mDelegate;
    // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CallbackToFutureAdapter.Completer<V> mCompleter;

    public static <V> @NonNull FutureChain<V> from(@NonNull ListenableFuture<V> future) {
        return future instanceof FutureChain ? (FutureChain<V>)future : new FutureChain<V>(future);
    }

    public final <T> @NonNull FutureChain<T> transformAsync(@NonNull AsyncFunction<? super V, T> function, @NonNull Executor executor) {
        return (FutureChain)Futures.transformAsync(this, function, executor);
    }

    public final <T> @NonNull FutureChain<T> transform(@NonNull Function<? super V, T> function, @NonNull Executor executor) {
        return (FutureChain)Futures.transform(this, function, executor);
    }

    public final void addCallback(@NonNull FutureCallback<? super V> callback, @NonNull Executor executor) {
        Futures.addCallback(this, callback, executor);
    }

    FutureChain(@NonNull ListenableFuture<V> delegate) {
        this.mDelegate = (ListenableFuture)Preconditions.checkNotNull(delegate);
    }

    FutureChain() {
        this.mDelegate = CallbackToFutureAdapter.getFuture((CallbackToFutureAdapter.Resolver)new CallbackToFutureAdapter.Resolver<V>(){

            public Object attachCompleter(// Could not load outer class - annotation placement on inner may be incorrect
            @NonNull CallbackToFutureAdapter.Completer<V> completer) {
                Preconditions.checkState((FutureChain.this.mCompleter == null ? 1 : 0) != 0, (String)"The result can only set once!");
                FutureChain.this.mCompleter = completer;
                return "FutureChain[" + FutureChain.this + "]";
            }
        });
    }

    public void addListener(@NonNull Runnable listener, @NonNull Executor executor) {
        this.mDelegate.addListener(listener, executor);
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.mDelegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.mDelegate.isCancelled();
    }

    public boolean isDone() {
        return this.mDelegate.isDone();
    }

    public @Nullable V get() throws InterruptedException, ExecutionException {
        return (V)this.mDelegate.get();
    }

    public @Nullable V get(long timeout, @NonNull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (V)this.mDelegate.get(timeout, unit);
    }

    boolean set(@Nullable V value) {
        if (this.mCompleter != null) {
            return this.mCompleter.set(value);
        }
        return false;
    }

    boolean setException(@NonNull Throwable throwable) {
        if (this.mCompleter != null) {
            return this.mCompleter.setException(throwable);
        }
        return false;
    }
}

