/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.futures;

import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.AsyncFunction;
import androidx.camera.core.impl.utils.futures.FutureChain;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

class ChainingListenableFuture<I, O>
extends FutureChain<O>
implements Runnable {
    private @Nullable AsyncFunction<? super I, ? extends O> mFunction;
    private final BlockingQueue<Boolean> mMayInterruptIfRunningChannel = new LinkedBlockingQueue<Boolean>(1);
    private final CountDownLatch mOutputCreated = new CountDownLatch(1);
    private @Nullable ListenableFuture<? extends I> mInputFuture;
    volatile @Nullable ListenableFuture<? extends O> mOutputFuture;

    ChainingListenableFuture(@NonNull AsyncFunction<? super I, ? extends O> function, @NonNull ListenableFuture<? extends I> inputFuture) {
        this.mFunction = (AsyncFunction)Preconditions.checkNotNull(function);
        this.mInputFuture = (ListenableFuture)Preconditions.checkNotNull(inputFuture);
    }

    @Override
    public @Nullable O get() throws InterruptedException, ExecutionException {
        if (!this.isDone()) {
            ListenableFuture<? extends I> inputFuture = this.mInputFuture;
            if (inputFuture != null) {
                inputFuture.get();
            }
            this.mOutputCreated.await();
            ListenableFuture<? extends O> outputFuture = this.mOutputFuture;
            if (outputFuture != null) {
                outputFuture.get();
            }
        }
        return (O)super.get();
    }

    @Override
    public @Nullable O get(long timeout, @NonNull TimeUnit unit) throws TimeoutException, ExecutionException, InterruptedException {
        if (!this.isDone()) {
            long start;
            ListenableFuture<? extends I> inputFuture;
            if (unit != TimeUnit.NANOSECONDS) {
                timeout = TimeUnit.NANOSECONDS.convert(timeout, unit);
                unit = TimeUnit.NANOSECONDS;
            }
            if ((inputFuture = this.mInputFuture) != null) {
                start = System.nanoTime();
                inputFuture.get(timeout, unit);
                timeout -= Math.max(0L, System.nanoTime() - start);
            }
            start = System.nanoTime();
            if (!this.mOutputCreated.await(timeout, unit)) {
                throw new TimeoutException();
            }
            timeout -= Math.max(0L, System.nanoTime() - start);
            ListenableFuture<? extends O> outputFuture = this.mOutputFuture;
            if (outputFuture != null) {
                outputFuture.get(timeout, unit);
            }
        }
        return (O)super.get(timeout, unit);
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (super.cancel(mayInterruptIfRunning)) {
            this.putUninterruptibly(this.mMayInterruptIfRunningChannel, mayInterruptIfRunning);
            this.cancel((Future<?>)this.mInputFuture, mayInterruptIfRunning);
            this.cancel((Future<?>)this.mOutputFuture, mayInterruptIfRunning);
            return true;
        }
        return false;
    }

    private void cancel(@Nullable Future<?> future, boolean mayInterruptIfRunning) {
        if (future != null) {
            future.cancel(mayInterruptIfRunning);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public void run() {
        block16: {
            try {
                I sourceResult;
                try {
                    sourceResult = Futures.getUninterruptibly(this.mInputFuture);
                }
                catch (CancellationException e) {
                    this.cancel(false);
                    this.mFunction = null;
                    this.mInputFuture = null;
                    this.mOutputCreated.countDown();
                    return;
                }
                catch (ExecutionException e) {
                    this.setException(e.getCause());
                    this.mFunction = null;
                    this.mInputFuture = null;
                    this.mOutputCreated.countDown();
                    return;
                }
                this.mOutputFuture = this.mFunction.apply(sourceResult);
                final ListenableFuture<? extends O> outputFuture = this.mOutputFuture;
                if (this.isCancelled()) {
                    outputFuture.cancel(this.takeUninterruptibly(this.mMayInterruptIfRunningChannel).booleanValue());
                    this.mOutputFuture = null;
                    return;
                }
                outputFuture.addListener(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ChainingListenableFuture.this.set(Futures.getUninterruptibly(outputFuture));
                        }
                        catch (CancellationException e) {
                            ChainingListenableFuture.this.cancel(false);
                            return;
                        }
                        catch (ExecutionException e) {
                            ChainingListenableFuture.this.setException(e.getCause());
                        }
                        finally {
                            ChainingListenableFuture.this.mOutputFuture = null;
                        }
                    }
                }, CameraXExecutors.directExecutor());
                break block16;
                {
                    catch (UndeclaredThrowableException e) {
                        this.setException(e.getCause());
                        break block16;
                    }
                    catch (Exception e) {
                        this.setException(e);
                        break block16;
                    }
                    catch (Error e) {
                        this.setException(e);
                        break block16;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.mFunction = null;
                this.mInputFuture = null;
                this.mOutputCreated.countDown();
            }
        }
    }

    private <E> E takeUninterruptibly(@NonNull BlockingQueue<E> queue) {
        boolean interrupted = false;
        while (true) {
            try {
                E e = queue.take();
                return e;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private <E> void putUninterruptibly(@NonNull BlockingQueue<E> queue, @NonNull E element) {
        boolean interrupted = false;
        while (true) {
            try {
                queue.put(element);
                return;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

