/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.executor;

import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.NonNull;

final class IoExecutor
implements Executor {
    private static volatile Executor sExecutor;
    private final ExecutorService mIoService = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private static final String THREAD_NAME_STEM = "CameraX-camerax_io_%d";
        private final AtomicInteger mThreadId = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setName(String.format(Locale.US, THREAD_NAME_STEM, this.mThreadId.getAndIncrement()));
            return t;
        }
    });

    IoExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Executor getInstance() {
        if (sExecutor != null) {
            return sExecutor;
        }
        Class<IoExecutor> clazz = IoExecutor.class;
        synchronized (IoExecutor.class) {
            if (sExecutor == null) {
                sExecutor = new IoExecutor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sExecutor;
        }
    }

    @Override
    public void execute(@NonNull Runnable command) {
        this.mIoService.execute(command);
    }
}

