/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.executor;

import android.os.Handler;
import androidx.camera.core.impl.utils.executor.AudioExecutor;
import androidx.camera.core.impl.utils.executor.DirectExecutor;
import androidx.camera.core.impl.utils.executor.HandlerScheduledExecutorService;
import androidx.camera.core.impl.utils.executor.HighPriorityExecutor;
import androidx.camera.core.impl.utils.executor.IoExecutor;
import androidx.camera.core.impl.utils.executor.MainThreadExecutor;
import androidx.camera.core.impl.utils.executor.SequentialExecutor;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.jspecify.annotations.NonNull;

public final class CameraXExecutors {
    private CameraXExecutors() {
    }

    public static @NonNull ScheduledExecutorService mainThreadExecutor() {
        return MainThreadExecutor.getInstance();
    }

    public static @NonNull Executor ioExecutor() {
        return IoExecutor.getInstance();
    }

    public static @NonNull Executor audioExecutor() {
        return AudioExecutor.getInstance();
    }

    public static @NonNull Executor directExecutor() {
        return DirectExecutor.getInstance();
    }

    public static @NonNull Executor newSequentialExecutor(@NonNull Executor delegate) {
        return new SequentialExecutor(delegate);
    }

    public static boolean isSequentialExecutor(@NonNull Executor executor) {
        return executor instanceof SequentialExecutor;
    }

    public static @NonNull ScheduledExecutorService myLooperExecutor() {
        return HandlerScheduledExecutorService.currentThreadExecutor();
    }

    public static @NonNull ScheduledExecutorService newHandlerExecutor(@NonNull Handler handler) {
        return new HandlerScheduledExecutorService(handler);
    }

    public static @NonNull Executor highPriorityExecutor() {
        return HighPriorityExecutor.getInstance();
    }
}

