/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils.executor;

import android.os.Process;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.NonNull;

public class AudioExecutor
implements Executor {
    private static volatile Executor sExecutor;
    private final ExecutorService mAudioService = Executors.newFixedThreadPool(2, new ThreadFactory(){
        private static final String THREAD_NAME_STEM = "CameraX-camerax_audio_%d";
        private final AtomicInteger mThreadId = new AtomicInteger(0);

        @Override
        public Thread newThread(Runnable r) {
            Runnable wrapper = () -> {
                Process.setThreadPriority((int)-16);
                r.run();
            };
            Thread t = new Thread(wrapper);
            t.setName(String.format(Locale.US, THREAD_NAME_STEM, this.mThreadId.getAndIncrement()));
            return t;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Executor getInstance() {
        if (sExecutor != null) {
            return sExecutor;
        }
        Class<AudioExecutor> clazz = AudioExecutor.class;
        synchronized (AudioExecutor.class) {
            if (sExecutor == null) {
                sExecutor = new AudioExecutor();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sExecutor;
        }
    }

    @Override
    public void execute(@NonNull Runnable command) {
        this.mAudioService.execute(command);
    }
}

