/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.os.Handler;
import android.os.Looper;
import androidx.camera.core.impl.utils.InterruptedRuntimeException;
import androidx.core.util.Preconditions;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.NonNull;

public final class Threads {
    private static final long TIMEOUT_RUN_ON_MAIN_MS = 30000L;

    private Threads() {
    }

    public static boolean isMainThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static boolean isBackgroundThread() {
        return !Threads.isMainThread();
    }

    public static void checkMainThread() {
        Preconditions.checkState((boolean)Threads.isMainThread(), (String)"Not in application's main thread");
    }

    public static void checkBackgroundThread() {
        Preconditions.checkState((boolean)Threads.isBackgroundThread(), (String)"In application's main thread");
    }

    public static void runOnMain(@NonNull Runnable runnable) {
        if (Threads.isMainThread()) {
            runnable.run();
            return;
        }
        Preconditions.checkState((boolean)Threads.getMainHandler().post(runnable), (String)"Unable to post to main thread");
    }

    public static void runOnMainSync(@NonNull Runnable runnable) {
        if (Threads.isMainThread()) {
            runnable.run();
            return;
        }
        CountDownLatch latch = new CountDownLatch(1);
        boolean postResult = Threads.getMainHandler().post(() -> {
            try {
                runnable.run();
            }
            finally {
                latch.countDown();
            }
        });
        Preconditions.checkState((boolean)postResult, (String)"Unable to post to main thread");
        try {
            if (!latch.await(30000L, TimeUnit.MILLISECONDS)) {
                throw new IllegalStateException("Timeout to wait main thread execution");
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedRuntimeException(e);
        }
    }

    private static @NonNull Handler getMainHandler() {
        return new Handler(Looper.getMainLooper());
    }
}

