/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.view.Surface;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class SurfaceUtil {
    private static final String TAG = "SurfaceUtil";
    public static final String JNI_LIB_NAME = "surface_util_jni";

    private SurfaceUtil() {
    }

    public static @NonNull SurfaceInfo getSurfaceInfo(@NonNull Surface surface) {
        int[] surfaceInfoArray = SurfaceUtil.nativeGetSurfaceInfo(surface);
        SurfaceInfo surfaceInfo = new SurfaceInfo();
        surfaceInfo.format = surfaceInfoArray[0];
        surfaceInfo.width = surfaceInfoArray[1];
        surfaceInfo.height = surfaceInfoArray[2];
        return surfaceInfo;
    }

    private static native int[] nativeGetSurfaceInfo(@Nullable Surface var0);

    static {
        System.loadLibrary(JNI_LIB_NAME);
    }

    public static class SurfaceInfo {
        public int format = 0;
        public int width = 0;
        public int height = 0;
    }
}

