/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.impl.SessionProcessor;
import java.util.ArrayList;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SessionProcessorUtil {
    private SessionProcessorUtil() {
    }

    public static boolean isOperationSupported(@Nullable SessionProcessor sessionProcessor, int ... operations) {
        if (sessionProcessor == null) {
            return true;
        }
        ArrayList<Integer> operationList = new ArrayList<Integer>(operations.length);
        for (int operation : operations) {
            operationList.add(operation);
        }
        return sessionProcessor.getSupportedCameraOperations().containsAll(operationList);
    }

    public static @Nullable FocusMeteringAction getModifiedFocusMeteringAction(@Nullable SessionProcessor sessionProcessor, @NonNull FocusMeteringAction action) {
        if (sessionProcessor == null) {
            return action;
        }
        boolean shouldModify = false;
        FocusMeteringAction.Builder builder = new FocusMeteringAction.Builder(action);
        if (!action.getMeteringPointsAf().isEmpty() && !SessionProcessorUtil.isOperationSupported(sessionProcessor, 1, 2)) {
            shouldModify = true;
            builder.removePoints(1);
        }
        if (!action.getMeteringPointsAe().isEmpty() && !SessionProcessorUtil.isOperationSupported(sessionProcessor, 3)) {
            shouldModify = true;
            builder.removePoints(2);
        }
        if (!action.getMeteringPointsAwb().isEmpty() && !SessionProcessorUtil.isOperationSupported(sessionProcessor, 4)) {
            shouldModify = true;
            builder.removePoints(4);
        }
        if (!shouldModify) {
            return action;
        }
        FocusMeteringAction modifyAction = builder.build();
        if (modifyAction.getMeteringPointsAf().isEmpty() && modifyAction.getMeteringPointsAe().isEmpty() && modifyAction.getMeteringPointsAwb().isEmpty()) {
            return null;
        }
        return builder.build();
    }
}

