/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.camera.core.impl.utils.Absent;
import androidx.camera.core.impl.utils.Present;
import androidx.core.util.Preconditions;
import androidx.core.util.Supplier;
import java.io.Serializable;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class Optional<T>
implements Serializable {
    private static final long serialVersionUID = 0L;

    public static <T> @NonNull Optional<T> absent() {
        return Absent.withType();
    }

    public static <T> @NonNull Optional<T> of(@NonNull T reference) {
        return new Present<Object>(Preconditions.checkNotNull(reference));
    }

    public static <T> @NonNull Optional<T> fromNullable(@Nullable T nullableReference) {
        return nullableReference == null ? Optional.absent() : new Present<T>(nullableReference);
    }

    Optional() {
    }

    public abstract boolean isPresent();

    public abstract @NonNull T get();

    public abstract @NonNull T or(@NonNull T var1);

    public abstract @NonNull Optional<T> or(@NonNull Optional<? extends T> var1);

    public abstract @NonNull T or(@NonNull Supplier<? extends T> var1);

    public abstract @Nullable T orNull();

    public abstract boolean equals(@Nullable Object var1);

    public abstract int hashCode();

    public abstract @NonNull String toString();
}

