/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.arch.core.util.Function;
import androidx.camera.core.impl.utils.Threads;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import androidx.lifecycle.Observer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00028\u0001\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bJ,\u0010\u000e\u001a\u00020\r\"\u0004\b\u0002\u0010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000b2\u000e\u0010\u0011\u001a\n\u0012\u0006\b\u0000\u0012\u0002H\u000f0\u0012H\u0016J\u000f\u0010\u0013\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0014R\u0010\u0010\u0004\u001a\u00028\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Landroidx/camera/core/impl/utils/MappingRedirectableLiveData;", "I", "O", "Landroidx/lifecycle/MediatorLiveData;", "initialValue", "mapFunction", "Landroidx/arch/core/util/Function;", "<init>", "(Ljava/lang/Object;Landroidx/arch/core/util/Function;)V", "Ljava/lang/Object;", "liveDataSource", "Landroidx/lifecycle/LiveData;", "redirectTo", "", "addSource", "S", "source", "onChanged", "Landroidx/lifecycle/Observer;", "getValue", "()Ljava/lang/Object;", "camera-core_release"})
public class MappingRedirectableLiveData<I, O>
extends MediatorLiveData<O> {
    private final O initialValue;
    @NotNull
    private final Function<I, O> mapFunction;
    @Nullable
    private LiveData<I> liveDataSource;

    public MappingRedirectableLiveData(O initialValue, @NotNull Function<I, O> mapFunction) {
        Intrinsics.checkNotNullParameter(mapFunction, (String)"mapFunction");
        this.initialValue = initialValue;
        this.mapFunction = mapFunction;
    }

    public final void redirectTo(@NotNull LiveData<I> liveDataSource) {
        Intrinsics.checkNotNullParameter(liveDataSource, (String)"liveDataSource");
        if (this.liveDataSource != null) {
            LiveData<I> liveData = this.liveDataSource;
            Intrinsics.checkNotNull(liveData);
            super.removeSource(liveData);
        }
        this.liveDataSource = liveDataSource;
        Threads.runOnMain(() -> MappingRedirectableLiveData.redirectTo$lambda$2(this, liveDataSource));
    }

    public <S> void addSource(@NotNull LiveData<S> source, @NotNull Observer<? super S> onChanged) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(onChanged, (String)"onChanged");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public O getValue() {
        LiveData<I> liveDataSource = this.liveDataSource;
        if (liveDataSource == null) {
            return this.initialValue;
        }
        return (O)this.mapFunction.apply(liveDataSource.getValue());
    }

    private static final Unit redirectTo$lambda$2$lambda$0(MappingRedirectableLiveData this$0, Object value) {
        this$0.setValue(this$0.mapFunction.apply(value));
        return Unit.INSTANCE;
    }

    private static final void redirectTo$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void redirectTo$lambda$2(MappingRedirectableLiveData this$0, LiveData $liveDataSource) {
        super.addSource($liveDataSource, arg_0 -> MappingRedirectableLiveData.redirectTo$lambda$2$lambda$1(arg_0 -> MappingRedirectableLiveData.redirectTo$lambda$2$lambda$0(this$0, arg_0), arg_0));
    }
}

