/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.camera.core.Logger;
import androidx.camera.core.impl.utils.ByteOrderedDataInputStream;
import androidx.camera.core.impl.utils.LongRational;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class ExifAttribute {
    private static final String TAG = "ExifAttribute";
    public static final long BYTES_OFFSET_UNKNOWN = -1L;
    static final Charset ASCII = StandardCharsets.US_ASCII;
    static final int IFD_FORMAT_BYTE = 1;
    static final int IFD_FORMAT_STRING = 2;
    static final int IFD_FORMAT_USHORT = 3;
    static final int IFD_FORMAT_ULONG = 4;
    static final int IFD_FORMAT_URATIONAL = 5;
    static final int IFD_FORMAT_SBYTE = 6;
    static final int IFD_FORMAT_UNDEFINED = 7;
    static final int IFD_FORMAT_SSHORT = 8;
    static final int IFD_FORMAT_SLONG = 9;
    static final int IFD_FORMAT_SRATIONAL = 10;
    static final int IFD_FORMAT_SINGLE = 11;
    static final int IFD_FORMAT_DOUBLE = 12;
    static final String[] IFD_FORMAT_NAMES = new String[]{"", "BYTE", "STRING", "USHORT", "ULONG", "URATIONAL", "SBYTE", "UNDEFINED", "SSHORT", "SLONG", "SRATIONAL", "SINGLE", "DOUBLE", "IFD"};
    static final int[] IFD_FORMAT_BYTES_PER_FORMAT = new int[]{0, 1, 1, 2, 4, 8, 1, 1, 2, 4, 8, 4, 8, 1};
    static final byte[] EXIF_ASCII_PREFIX = new byte[]{65, 83, 67, 73, 73, 0, 0, 0};
    public final int format;
    public final int numberOfComponents;
    public final long bytesOffset;
    public final byte[] bytes;

    ExifAttribute(int format, int numberOfComponents, byte[] bytes) {
        this(format, numberOfComponents, -1L, bytes);
    }

    ExifAttribute(int format, int numberOfComponents, long bytesOffset, byte[] bytes) {
        this.format = format;
        this.numberOfComponents = numberOfComponents;
        this.bytesOffset = bytesOffset;
        this.bytes = bytes;
    }

    public static @NonNull ExifAttribute createUShort(int @NonNull [] values, @NonNull ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[3] * values.length]);
        buffer.order(byteOrder);
        for (int value : values) {
            buffer.putShort((short)value);
        }
        return new ExifAttribute(3, values.length, buffer.array());
    }

    public static @NonNull ExifAttribute createUShort(int value, @NonNull ByteOrder byteOrder) {
        return ExifAttribute.createUShort(new int[]{value}, byteOrder);
    }

    public static @NonNull ExifAttribute createULong(long @NonNull [] values, @NonNull ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[4] * values.length]);
        buffer.order(byteOrder);
        for (long value : values) {
            buffer.putInt((int)value);
        }
        return new ExifAttribute(4, values.length, buffer.array());
    }

    public static @NonNull ExifAttribute createULong(long value, @NonNull ByteOrder byteOrder) {
        return ExifAttribute.createULong(new long[]{value}, byteOrder);
    }

    public static @NonNull ExifAttribute createSLong(int @NonNull [] values, @NonNull ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[9] * values.length]);
        buffer.order(byteOrder);
        for (int value : values) {
            buffer.putInt(value);
        }
        return new ExifAttribute(9, values.length, buffer.array());
    }

    public static @NonNull ExifAttribute createSLong(int value, @NonNull ByteOrder byteOrder) {
        return ExifAttribute.createSLong(new int[]{value}, byteOrder);
    }

    public static @NonNull ExifAttribute createByte(@NonNull String value) {
        if (value.length() == 1 && value.charAt(0) >= '0' && value.charAt(0) <= '1') {
            byte[] bytes = new byte[]{(byte)(value.charAt(0) - 48)};
            return new ExifAttribute(1, bytes.length, bytes);
        }
        byte[] ascii = value.getBytes(ASCII);
        return new ExifAttribute(1, ascii.length, ascii);
    }

    public static @NonNull ExifAttribute createString(@NonNull String value) {
        byte[] ascii = (value + '\u0000').getBytes(ASCII);
        return new ExifAttribute(2, ascii.length, ascii);
    }

    public static @NonNull ExifAttribute createURational(LongRational @NonNull [] values, @NonNull ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[5] * values.length]);
        buffer.order(byteOrder);
        for (LongRational value : values) {
            buffer.putInt((int)value.getNumerator());
            buffer.putInt((int)value.getDenominator());
        }
        return new ExifAttribute(5, values.length, buffer.array());
    }

    public static @NonNull ExifAttribute createURational(@NonNull LongRational value, @NonNull ByteOrder byteOrder) {
        return ExifAttribute.createURational(new LongRational[]{value}, byteOrder);
    }

    public static @NonNull ExifAttribute createSRational(LongRational @NonNull [] values, @NonNull ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[10] * values.length]);
        buffer.order(byteOrder);
        for (LongRational value : values) {
            buffer.putInt((int)value.getNumerator());
            buffer.putInt((int)value.getDenominator());
        }
        return new ExifAttribute(10, values.length, buffer.array());
    }

    public static @NonNull ExifAttribute createSRational(@NonNull LongRational value, @NonNull ByteOrder byteOrder) {
        return ExifAttribute.createSRational(new LongRational[]{value}, byteOrder);
    }

    public static @NonNull ExifAttribute createDouble(double @NonNull [] values, @NonNull ByteOrder byteOrder) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[IFD_FORMAT_BYTES_PER_FORMAT[12] * values.length]);
        buffer.order(byteOrder);
        for (double value : values) {
            buffer.putDouble(value);
        }
        return new ExifAttribute(12, values.length, buffer.array());
    }

    public static @NonNull ExifAttribute createDouble(double value, @NonNull ByteOrder byteOrder) {
        return ExifAttribute.createDouble(new double[]{value}, byteOrder);
    }

    public String toString() {
        return "(" + IFD_FORMAT_NAMES[this.format] + ", data length:" + this.bytes.length + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getValue(ByteOrder byteOrder) {
        ByteOrderedDataInputStream inputStream = null;
        try {
            inputStream = new ByteOrderedDataInputStream(this.bytes);
            inputStream.setByteOrder(byteOrder);
            switch (this.format) {
                case 1: 
                case 6: {
                    if (this.bytes.length == 1 && this.bytes[0] >= 0 && this.bytes[0] <= 1) {
                        String string = new String(new char[]{(char)(this.bytes[0] + 48)});
                        return string;
                    }
                    String string = new String(this.bytes, ASCII);
                    return string;
                }
                case 2: 
                case 7: {
                    byte ch22;
                    int index = 0;
                    if (this.numberOfComponents >= EXIF_ASCII_PREFIX.length) {
                        boolean same = true;
                        for (int i = 0; i < EXIF_ASCII_PREFIX.length; ++i) {
                            if (this.bytes[i] == EXIF_ASCII_PREFIX[i]) continue;
                            same = false;
                            break;
                        }
                        if (same) {
                            index = EXIF_ASCII_PREFIX.length;
                        }
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    while (index < this.numberOfComponents && (ch22 = this.bytes[index]) != 0) {
                        if (ch22 >= 32) {
                            stringBuilder.append((char)ch22);
                        } else {
                            stringBuilder.append('?');
                        }
                        ++index;
                    }
                    String ch22 = stringBuilder.toString();
                    return ch22;
                }
                case 3: {
                    int[] values = new int[this.numberOfComponents];
                    for (int i = 0; i < this.numberOfComponents; ++i) {
                        values[i] = inputStream.readUnsignedShort();
                    }
                    int[] i = values;
                    return i;
                }
                case 4: {
                    long[] values = new long[this.numberOfComponents];
                    for (int i = 0; i < this.numberOfComponents; ++i) {
                        values[i] = inputStream.readUnsignedInt();
                    }
                    long[] i = values;
                    return i;
                }
                case 5: {
                    LongRational[] values = new LongRational[this.numberOfComponents];
                    for (int i = 0; i < this.numberOfComponents; ++i) {
                        long numerator = inputStream.readUnsignedInt();
                        long denominator = inputStream.readUnsignedInt();
                        values[i] = new LongRational(numerator, denominator);
                    }
                    LongRational[] i = values;
                    return i;
                }
                case 8: {
                    int[] values = new int[this.numberOfComponents];
                    for (int i = 0; i < this.numberOfComponents; ++i) {
                        values[i] = inputStream.readShort();
                    }
                    int[] i = values;
                    return i;
                }
                case 9: {
                    int[] values = new int[this.numberOfComponents];
                    for (int i = 0; i < this.numberOfComponents; ++i) {
                        values[i] = inputStream.readInt();
                    }
                    int[] i = values;
                    return i;
                }
                case 10: {
                    LongRational[] values = new LongRational[this.numberOfComponents];
                    for (int i = 0; i < this.numberOfComponents; ++i) {
                        long numerator = inputStream.readInt();
                        long denominator = inputStream.readInt();
                        values[i] = new LongRational(numerator, denominator);
                    }
                    LongRational[] i = values;
                    return i;
                }
                case 11: {
                    double[] values = new double[this.numberOfComponents];
                    for (int i = 0; i < this.numberOfComponents; ++i) {
                        values[i] = inputStream.readFloat();
                    }
                    double[] i = values;
                    return i;
                }
                case 12: {
                    double[] values = new double[this.numberOfComponents];
                    for (int i = 0; i < this.numberOfComponents; ++i) {
                        values[i] = inputStream.readDouble();
                    }
                    double[] i = values;
                    return i;
                }
            }
            Object values = null;
            return values;
        }
        catch (IOException e) {
            Logger.w(TAG, "IOException occurred during reading a value", e);
            Object var4_37 = null;
            return var4_37;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    Logger.e(TAG, "IOException occurred while closing InputStream", e);
                }
            }
        }
    }

    public double getDoubleValue(@NonNull ByteOrder byteOrder) {
        Object value = this.getValue(byteOrder);
        if (value == null) {
            throw new NumberFormatException("NULL can't be converted to a double value");
        }
        if (value instanceof String) {
            return Double.parseDouble((String)value);
        }
        if (value instanceof long[]) {
            long[] array = (long[])value;
            if (array.length == 1) {
                return array[0];
            }
            throw new NumberFormatException("There are more than one component");
        }
        if (value instanceof int[]) {
            int[] array = (int[])value;
            if (array.length == 1) {
                return array[0];
            }
            throw new NumberFormatException("There are more than one component");
        }
        if (value instanceof double[]) {
            double[] array = (double[])value;
            if (array.length == 1) {
                return array[0];
            }
            throw new NumberFormatException("There are more than one component");
        }
        if (value instanceof LongRational[]) {
            LongRational[] array = (LongRational[])value;
            if (array.length == 1) {
                return array[0].toDouble();
            }
            throw new NumberFormatException("There are more than one component");
        }
        throw new NumberFormatException("Couldn't find a double value");
    }

    public int getIntValue(@NonNull ByteOrder byteOrder) {
        Object value = this.getValue(byteOrder);
        if (value == null) {
            throw new NumberFormatException("NULL can't be converted to a integer value");
        }
        if (value instanceof String) {
            return Integer.parseInt((String)value);
        }
        if (value instanceof long[]) {
            long[] array = (long[])value;
            if (array.length == 1) {
                return (int)array[0];
            }
            throw new NumberFormatException("There are more than one component");
        }
        if (value instanceof int[]) {
            int[] array = (int[])value;
            if (array.length == 1) {
                return array[0];
            }
            throw new NumberFormatException("There are more than one component");
        }
        throw new NumberFormatException("Couldn't find a integer value");
    }

    public @Nullable String getStringValue(@NonNull ByteOrder byteOrder) {
        Object value = this.getValue(byteOrder);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (value instanceof long[]) {
            long[] array = (long[])value;
            for (int i = 0; i < array.length; ++i) {
                stringBuilder.append(array[i]);
                if (i + 1 == array.length) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        if (value instanceof int[]) {
            int[] array = (int[])value;
            for (int i = 0; i < array.length; ++i) {
                stringBuilder.append(array[i]);
                if (i + 1 == array.length) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        if (value instanceof double[]) {
            double[] array = (double[])value;
            for (int i = 0; i < array.length; ++i) {
                stringBuilder.append(array[i]);
                if (i + 1 == array.length) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        if (value instanceof LongRational[]) {
            LongRational[] array = (LongRational[])value;
            for (int i = 0; i < array.length; ++i) {
                stringBuilder.append(array[i].getNumerator());
                stringBuilder.append('/');
                stringBuilder.append(array[i].getDenominator());
                if (i + 1 == array.length) continue;
                stringBuilder.append(",");
            }
            return stringBuilder.toString();
        }
        return null;
    }

    public int size() {
        return IFD_FORMAT_BYTES_PER_FORMAT[this.format] * this.numberOfComponents;
    }
}

