/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import androidx.annotation.RequiresApi;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ContextUtil {
    public static @NonNull Context getApplicationContext(@NonNull Context context) {
        String attributeTagResultContext;
        String attributeTagContext;
        int deviceIdResultContext;
        int deviceIdContext;
        Context resultContext = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 34 && (deviceIdContext = Api34Impl.getDeviceId(context)) != (deviceIdResultContext = Api34Impl.getDeviceId(resultContext))) {
            resultContext = Api34Impl.createDeviceContext(resultContext, deviceIdContext);
        }
        if (Build.VERSION.SDK_INT >= 30 && !Objects.equals(attributeTagContext = Api30Impl.getAttributionTag(context), attributeTagResultContext = Api30Impl.getAttributionTag(resultContext))) {
            resultContext = Api30Impl.createAttributionContext(resultContext, attributeTagContext);
        }
        return resultContext;
    }

    public static @Nullable Application getApplicationFromContext(@NonNull Context context) {
        Application application = null;
        Context appContext = ContextUtil.getApplicationContext(context);
        while (appContext instanceof ContextWrapper) {
            if (appContext instanceof Application) {
                application = (Application)appContext;
                break;
            }
            appContext = ((ContextWrapper)appContext).getBaseContext();
        }
        return application;
    }

    private ContextUtil() {
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        private Api34Impl() {
        }

        static @NonNull Context createDeviceContext(@NonNull Context context, int deviceId) {
            return context.createDeviceContext(deviceId);
        }

        static int getDeviceId(@NonNull Context context) {
            return context.getDeviceId();
        }
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        static @NonNull Context createAttributionContext(@NonNull Context context, @Nullable String attributeTag) {
            return context.createAttributionContext(attributeTag);
        }

        static @Nullable String getAttributionTag(@NonNull Context context) {
            return context.getAttributionTag();
        }
    }
}

