/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import android.graphics.RectF;
import android.util.Rational;
import android.util.Size;
import androidx.camera.core.internal.utils.SizeUtil;
import androidx.core.util.Preconditions;
import java.util.Comparator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class AspectRatioUtil {
    public static final Rational ASPECT_RATIO_4_3 = new Rational(4, 3);
    public static final Rational ASPECT_RATIO_3_4 = new Rational(3, 4);
    public static final Rational ASPECT_RATIO_16_9 = new Rational(16, 9);
    public static final Rational ASPECT_RATIO_9_16 = new Rational(9, 16);
    private static final int ALIGN16 = 16;

    private AspectRatioUtil() {
    }

    public static boolean hasMatchingAspectRatio(@NonNull Size resolution, @Nullable Rational aspectRatio) {
        return AspectRatioUtil.hasMatchingAspectRatio(resolution, aspectRatio, SizeUtil.RESOLUTION_VGA);
    }

    public static boolean hasMatchingAspectRatio(@NonNull Size resolution, @Nullable Rational aspectRatio, @NonNull Size mod16ResolutionLowerBound) {
        boolean isMatch = false;
        if (aspectRatio == null) {
            isMatch = false;
        } else if (aspectRatio.equals((Object)new Rational(resolution.getWidth(), resolution.getHeight()))) {
            isMatch = true;
        } else if (SizeUtil.getArea(resolution) >= SizeUtil.getArea(mod16ResolutionLowerBound)) {
            isMatch = AspectRatioUtil.isPossibleMod16FromAspectRatio(resolution, aspectRatio);
        }
        return isMatch;
    }

    private static boolean isPossibleMod16FromAspectRatio(@NonNull Size resolution, @NonNull Rational aspectRatio) {
        int width = resolution.getWidth();
        int height = resolution.getHeight();
        Rational invAspectRatio = new Rational(aspectRatio.getDenominator(), aspectRatio.getNumerator());
        if (width % 16 == 0 && height % 16 == 0) {
            return AspectRatioUtil.ratioIntersectsMod16Segment(Math.max(0, height - 16), width, aspectRatio) || AspectRatioUtil.ratioIntersectsMod16Segment(Math.max(0, width - 16), height, invAspectRatio);
        }
        if (width % 16 == 0) {
            return AspectRatioUtil.ratioIntersectsMod16Segment(height, width, aspectRatio);
        }
        if (height % 16 == 0) {
            return AspectRatioUtil.ratioIntersectsMod16Segment(width, height, invAspectRatio);
        }
        return false;
    }

    private static boolean ratioIntersectsMod16Segment(int height, int mod16Width, Rational aspectRatio) {
        Preconditions.checkArgument((mod16Width % 16 == 0 ? 1 : 0) != 0);
        double aspectRatioWidth = (double)(height * aspectRatio.getNumerator()) / (double)aspectRatio.getDenominator();
        return aspectRatioWidth > (double)Math.max(0, mod16Width - 16) && aspectRatioWidth < (double)(mod16Width + 16);
    }

    public static final class CompareAspectRatiosByMappingAreaInFullFovAspectRatioSpace
    implements Comparator<Rational> {
        private final Rational mTargetRatio;
        private final RectF mTransformedMappingArea;
        private final Rational mFullFovRatio;

        public CompareAspectRatiosByMappingAreaInFullFovAspectRatioSpace(@NonNull Rational targetRatio, @Nullable Rational fullFovRatio) {
            this.mTargetRatio = targetRatio;
            this.mFullFovRatio = fullFovRatio != null ? fullFovRatio : new Rational(4, 3);
            this.mTransformedMappingArea = this.getTransformedMappingArea(this.mTargetRatio);
        }

        @Override
        public int compare(Rational lhs, Rational rhs) {
            if (lhs.equals((Object)rhs)) {
                return 0;
            }
            RectF lhsMappingArea = this.getTransformedMappingArea(lhs);
            RectF rhsMappingArea = this.getTransformedMappingArea(rhs);
            boolean isCoveredByLhs = this.isMappingAreaCovered(lhsMappingArea, this.mTransformedMappingArea);
            boolean isCoveredByRhs = this.isMappingAreaCovered(rhsMappingArea, this.mTransformedMappingArea);
            if (isCoveredByLhs && isCoveredByRhs) {
                return (int)Math.signum(this.getMappingAreaSize(lhsMappingArea) - this.getMappingAreaSize(rhsMappingArea));
            }
            if (isCoveredByLhs) {
                return -1;
            }
            if (isCoveredByRhs) {
                return 1;
            }
            float lhsOverlappingArea = this.getOverlappingAreaSize(lhsMappingArea, this.mTransformedMappingArea);
            float rhsOverlappingArea = this.getOverlappingAreaSize(rhsMappingArea, this.mTransformedMappingArea);
            return -((int)Math.signum(lhsOverlappingArea - rhsOverlappingArea));
        }

        private RectF getTransformedMappingArea(Rational ratio) {
            if (ratio.floatValue() == this.mFullFovRatio.floatValue()) {
                return new RectF(0.0f, 0.0f, (float)this.mFullFovRatio.getNumerator(), (float)this.mFullFovRatio.getDenominator());
            }
            if (ratio.floatValue() > this.mFullFovRatio.floatValue()) {
                return new RectF(0.0f, 0.0f, (float)this.mFullFovRatio.getNumerator(), (float)ratio.getDenominator() * (float)this.mFullFovRatio.getNumerator() / (float)ratio.getNumerator());
            }
            return new RectF(0.0f, 0.0f, (float)ratio.getNumerator() * (float)this.mFullFovRatio.getDenominator() / (float)ratio.getDenominator(), (float)this.mFullFovRatio.getDenominator());
        }

        private boolean isMappingAreaCovered(RectF sourceMappingArea, RectF targetMappingArea) {
            return sourceMappingArea.width() >= targetMappingArea.width() && sourceMappingArea.height() >= targetMappingArea.height();
        }

        private float getMappingAreaSize(RectF mappingArea) {
            return mappingArea.width() * mappingArea.height();
        }

        private float getOverlappingAreaSize(RectF mappingArea1, RectF mappingArea2) {
            float overlappingAreaWidth = mappingArea1.width() < mappingArea2.width() ? mappingArea1.width() : mappingArea2.width();
            float overlappingAreaHeight = mappingArea1.height() < mappingArea2.height() ? mappingArea1.height() : mappingArea2.height();
            return overlappingAreaWidth * overlappingAreaHeight;
        }
    }
}

