/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl.utils;

import androidx.camera.core.impl.utils.Optional;
import androidx.core.util.Preconditions;
import androidx.core.util.Supplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class Absent<T>
extends Optional<T> {
    static final Absent<Object> sInstance = new Absent();
    private static final long serialVersionUID = 0L;

    static <T> Optional<T> withType() {
        return sInstance;
    }

    private Absent() {
    }

    @Override
    public boolean isPresent() {
        return false;
    }

    @Override
    public @NonNull T get() {
        throw new IllegalStateException("Optional.get() cannot be called on an absent value");
    }

    @Override
    public @NonNull T or(@NonNull T defaultValue) {
        return (T)Preconditions.checkNotNull(defaultValue, (Object)"use Optional.orNull() instead of Optional.or(null)");
    }

    @Override
    public @NonNull Optional<T> or(@NonNull Optional<? extends T> secondChoice) {
        return (Optional)Preconditions.checkNotNull(secondChoice);
    }

    @Override
    public @NonNull T or(@NonNull Supplier<? extends T> supplier) {
        return (T)Preconditions.checkNotNull((Object)supplier.get(), (Object)"use Optional.orNull() instead of a Supplier that returns null");
    }

    @Override
    public @Nullable T orNull() {
        return null;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return 2040732332;
    }

    @Override
    public @NonNull String toString() {
        return "Optional.absent()";
    }

    private Object readResolve() {
        return sInstance;
    }
}

