/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import androidx.camera.core.ExtendableBuilder;
import androidx.camera.core.UseCase;
import androidx.camera.core.imagecapture.ImageCaptureControl;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.imagecapture.TakePictureManagerImpl;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.StreamUseCase;
import androidx.camera.core.impl.UseCaseConfigFactory;
import androidx.camera.core.internal.TargetConfig;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface UseCaseConfig<T extends UseCase>
extends TargetConfig<T>,
ImageInputConfig {
    public static final Config.Option<SessionConfig> OPTION_DEFAULT_SESSION_CONFIG = Config.Option.create("camerax.core.useCase.defaultSessionConfig", SessionConfig.class);
    public static final Config.Option<CaptureConfig> OPTION_DEFAULT_CAPTURE_CONFIG = Config.Option.create("camerax.core.useCase.defaultCaptureConfig", CaptureConfig.class);
    public static final Config.Option<SessionConfig.OptionUnpacker> OPTION_SESSION_CONFIG_UNPACKER = Config.Option.create("camerax.core.useCase.sessionConfigUnpacker", SessionConfig.OptionUnpacker.class);
    public static final Config.Option<CaptureConfig.OptionUnpacker> OPTION_CAPTURE_CONFIG_UNPACKER = Config.Option.create("camerax.core.useCase.captureConfigUnpacker", CaptureConfig.OptionUnpacker.class);
    public static final Config.Option<Integer> OPTION_SURFACE_OCCUPANCY_PRIORITY = Config.Option.create("camerax.core.useCase.surfaceOccupancyPriority", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_SESSION_TYPE = Config.Option.create("camerax.core.useCase.sessionType", Integer.TYPE);
    public static final Config.Option<Range<Integer>> OPTION_TARGET_FRAME_RATE = Config.Option.create("camerax.core.useCase.targetFrameRate", Range.class);
    public static final Config.Option<Boolean> OPTION_IS_STRICT_FRAME_RATE_REQUIRED = Config.Option.create("camerax.core.useCase.isStrictFrameRateRequired", Boolean.class);
    public static final Config.Option<Boolean> OPTION_ZSL_DISABLED = Config.Option.create("camerax.core.useCase.zslDisabled", Boolean.TYPE);
    public static final Config.Option<Boolean> OPTION_HIGH_RESOLUTION_DISABLED = Config.Option.create("camerax.core.useCase.highResolutionDisabled", Boolean.TYPE);
    public static final Config.Option<UseCaseConfigFactory.CaptureType> OPTION_CAPTURE_TYPE = Config.Option.create("camerax.core.useCase.captureType", UseCaseConfigFactory.CaptureType.class);
    public static final Config.Option<Integer> OPTION_PREVIEW_STABILIZATION_MODE = Config.Option.create("camerax.core.useCase.previewStabilizationMode", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_VIDEO_STABILIZATION_MODE = Config.Option.create("camerax.core.useCase.videoStabilizationMode", Integer.TYPE);
    public static final Config.Option<TakePictureManager.Provider> OPTION_TAKE_PICTURE_MANAGER_PROVIDER = Config.Option.create("camerax.core.useCase.takePictureManagerProvider", TakePictureManager.Provider.class);
    public static final Config.Option<StreamUseCase> OPTION_STREAM_USE_CASE = Config.Option.create("camerax.core.useCase.streamUseCase", StreamUseCase.class);

    default public @Nullable SessionConfig getDefaultSessionConfig(@Nullable SessionConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG, valueIfMissing);
    }

    default public @NonNull SessionConfig getDefaultSessionConfig() {
        return this.retrieveOption(OPTION_DEFAULT_SESSION_CONFIG);
    }

    default public @Nullable CaptureConfig getDefaultCaptureConfig(@Nullable CaptureConfig valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG, valueIfMissing);
    }

    default public @NonNull CaptureConfig getDefaultCaptureConfig() {
        return this.retrieveOption(OPTION_DEFAULT_CAPTURE_CONFIG);
    }

    default public @Nullable SessionConfig.OptionUnpacker getSessionOptionUnpacker(@Nullable SessionConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER, valueIfMissing);
    }

    default public @NonNull SessionConfig.OptionUnpacker getSessionOptionUnpacker() {
        return this.retrieveOption(OPTION_SESSION_CONFIG_UNPACKER);
    }

    default public @Nullable CaptureConfig.OptionUnpacker getCaptureOptionUnpacker(@Nullable CaptureConfig.OptionUnpacker valueIfMissing) {
        return this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER, valueIfMissing);
    }

    default public @NonNull CaptureConfig.OptionUnpacker getCaptureOptionUnpacker() {
        return this.retrieveOption(OPTION_CAPTURE_CONFIG_UNPACKER);
    }

    default public int getSurfaceOccupancyPriority(int valueIfMissing) {
        return this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY, valueIfMissing);
    }

    default public int getSurfaceOccupancyPriority() {
        return this.retrieveOption(OPTION_SURFACE_OCCUPANCY_PRIORITY);
    }

    default public int getSessionType(int valueIfMissing) {
        return this.retrieveOption(OPTION_SESSION_TYPE, valueIfMissing);
    }

    default public int getSessionType() {
        return this.retrieveOption(OPTION_SESSION_TYPE);
    }

    default public boolean hasTargetFrameRate() {
        return this.containsOption(OPTION_TARGET_FRAME_RATE);
    }

    default public @Nullable Range<Integer> getTargetFrameRate(@Nullable Range<Integer> valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_FRAME_RATE, valueIfMissing);
    }

    default public @NonNull Range<Integer> getTargetFrameRate() {
        return this.retrieveOption(OPTION_TARGET_FRAME_RATE);
    }

    default public boolean isStrictFrameRateRequired() {
        return Objects.requireNonNull(this.retrieveOption(OPTION_IS_STRICT_FRAME_RATE_REQUIRED, false));
    }

    default public boolean isZslDisabled(boolean valueIfMissing) {
        return this.retrieveOption(OPTION_ZSL_DISABLED, valueIfMissing);
    }

    default public boolean isHighResolutionDisabled(boolean valueIfMissing) {
        return this.retrieveOption(OPTION_HIGH_RESOLUTION_DISABLED, valueIfMissing);
    }

    default public  @NonNull UseCaseConfigFactory.CaptureType getCaptureType() {
        return this.retrieveOption(OPTION_CAPTURE_TYPE);
    }

    default public int getPreviewStabilizationMode() {
        return this.retrieveOption(OPTION_PREVIEW_STABILIZATION_MODE, 0);
    }

    default public int getVideoStabilizationMode() {
        return this.retrieveOption(OPTION_VIDEO_STABILIZATION_MODE, 0);
    }

    default public @NonNull TakePictureManager.Provider getTakePictureManagerProvider() {
        return Objects.requireNonNull((TakePictureManager.Provider)this.retrieveOption(OPTION_TAKE_PICTURE_MANAGER_PROVIDER, new TakePictureManager.Provider(){

            @Override
            public @NonNull TakePictureManager newInstance(@NonNull ImageCaptureControl imageCaptureControl) {
                return new TakePictureManagerImpl(imageCaptureControl);
            }
        }));
    }

    default public @NonNull StreamUseCase getStreamUseCase() {
        return Objects.requireNonNull(this.retrieveOption(OPTION_STREAM_USE_CASE, StreamUseCase.DEFAULT));
    }

    public static interface Builder<T extends UseCase, C extends UseCaseConfig<T>, B>
    extends TargetConfig.Builder<T, B>,
    ExtendableBuilder<T> {
        public @NonNull B setDefaultSessionConfig(@NonNull SessionConfig var1);

        public @NonNull B setDefaultCaptureConfig(@NonNull CaptureConfig var1);

        public @NonNull B setSessionOptionUnpacker(@NonNull SessionConfig.OptionUnpacker var1);

        public @NonNull B setCaptureOptionUnpacker(@NonNull CaptureConfig.OptionUnpacker var1);

        public @NonNull B setSurfaceOccupancyPriority(int var1);

        public @NonNull B setZslDisabled(boolean var1);

        public @NonNull B setHighResolutionDisabled(boolean var1);

        public @NonNull B setCaptureType( @NonNull UseCaseConfigFactory.CaptureType var1);

        public @NonNull B setStreamUseCase(@NonNull StreamUseCase var1);

        public @NonNull C getUseCaseConfig();
    }
}

