/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.ArrayMap;
import android.util.Pair;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TagBundle {
    protected final Map<String, Object> mTagMap;
    private static final TagBundle EMPTY_TAGBUNDLE = new TagBundle((Map<String, Object>)new ArrayMap());
    private static final String USER_TAG_PREFIX = "android.hardware.camera2.CaptureRequest.setTag.";
    public static final String CAMERAX_USER_TAG_PREFIX = "android.hardware.camera2.CaptureRequest.setTag.CX";

    protected TagBundle(@NonNull Map<String, Object> tagMap) {
        this.mTagMap = tagMap;
    }

    public static @NonNull TagBundle emptyBundle() {
        return EMPTY_TAGBUNDLE;
    }

    public static @NonNull TagBundle create(@NonNull Pair<String, Object> source) {
        ArrayMap map = new ArrayMap();
        map.put((String)source.first, source.second);
        return new TagBundle((Map<String, Object>)map);
    }

    public static @NonNull TagBundle from(@NonNull TagBundle otherTagBundle) {
        ArrayMap tags = new ArrayMap();
        for (String key : otherTagBundle.listKeys()) {
            tags.put(key, otherTagBundle.getTag(key));
        }
        return new TagBundle((Map<String, Object>)tags);
    }

    public @Nullable Object getTag(@NonNull String key) {
        return this.mTagMap.get(key);
    }

    public @NonNull Set<String> listKeys() {
        return this.mTagMap.keySet();
    }

    public final @NonNull String toString() {
        return CAMERAX_USER_TAG_PREFIX;
    }
}

