/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Size;
import androidx.camera.core.impl.AutoValue_SurfaceSizeDefinition;
import com.google.auto.value.AutoValue;
import java.util.Map;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class SurfaceSizeDefinition {
    SurfaceSizeDefinition() {
    }

    public static @NonNull SurfaceSizeDefinition create(@NonNull Size analysisSize, @NonNull Map<Integer, Size> s720pSizeMap, @NonNull Size previewSize, @NonNull Map<Integer, Size> s1440pSizeMap, @NonNull Size recordSize, @NonNull Map<Integer, Size> maximumSizeMap, @NonNull Map<Integer, Size> maximum4x3SizeMap, @NonNull Map<Integer, Size> maximum16x9SizeMap, @NonNull Map<Integer, Size> ultraMaximumSizeMap) {
        return new AutoValue_SurfaceSizeDefinition(analysisSize, s720pSizeMap, previewSize, s1440pSizeMap, recordSize, maximumSizeMap, maximum4x3SizeMap, maximum16x9SizeMap, ultraMaximumSizeMap);
    }

    public abstract @NonNull Size getAnalysisSize();

    public abstract @NonNull Map<Integer, Size> getS720pSizeMap();

    public abstract @NonNull Size getPreviewSize();

    public abstract @NonNull Map<Integer, Size> getS1440pSizeMap();

    public abstract @NonNull Size getRecordSize();

    public abstract @NonNull Map<Integer, Size> getMaximumSizeMap();

    public abstract @NonNull Map<Integer, Size> getMaximum4x3SizeMap();

    public abstract @NonNull Map<Integer, Size> getMaximum16x9SizeMap();

    public abstract @NonNull Map<Integer, Size> getUltraMaximumSizeMap();

    public @NonNull Size getS720pSize(int format) {
        return this.getS720pSizeMap().get(format);
    }

    public @NonNull Size getS1440pSize(int format) {
        return this.getS1440pSizeMap().get(format);
    }

    public @Nullable Size getMaximumSize(int format) {
        return this.getMaximumSizeMap().get(format);
    }

    public @Nullable Size getMaximum4x3Size(int format) {
        return this.getMaximumSizeMap().get(format);
    }

    public @Nullable Size getMaximum16x9Size(int format) {
        return this.getMaximumSizeMap().get(format);
    }

    public @Nullable Size getUltraMaximumSize(int format) {
        return this.getUltraMaximumSizeMap().get(format);
    }
}

