/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Size;
import androidx.camera.core.impl.StreamUseCase;
import androidx.camera.core.impl.SurfaceSizeDefinition;
import androidx.camera.core.internal.utils.SizeUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 #2\u00020\u0001:\u0004#$%&B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020\u0014H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006'"}, d2={"Landroidx/camera/core/impl/SurfaceConfig;", "", "configType", "Landroidx/camera/core/impl/SurfaceConfig$ConfigType;", "configSize", "Landroidx/camera/core/impl/SurfaceConfig$ConfigSize;", "streamUseCase", "Landroidx/camera/core/impl/StreamUseCase;", "<init>", "(Landroidx/camera/core/impl/SurfaceConfig$ConfigType;Landroidx/camera/core/impl/SurfaceConfig$ConfigSize;Landroidx/camera/core/impl/StreamUseCase;)V", "getConfigType", "()Landroidx/camera/core/impl/SurfaceConfig$ConfigType;", "getConfigSize", "()Landroidx/camera/core/impl/SurfaceConfig$ConfigSize;", "getStreamUseCase", "()Landroidx/camera/core/impl/StreamUseCase;", "isSupported", "", "other", "imageFormat", "", "getImageFormat", "()I", "getResolution", "Landroid/util/Size;", "definition", "Landroidx/camera/core/impl/SurfaceSizeDefinition;", "component1", "component2", "component3", "copy", "equals", "hashCode", "toString", "", "Companion", "ConfigType", "ConfigSource", "ConfigSize", "camera-core_release"})
@SourceDebugExtension(value={"SMAP\nSurfaceConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SurfaceConfig.kt\nandroidx/camera/core/impl/SurfaceConfig\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,385:1\n1216#2,2:386\n1246#2,4:388\n*S KotlinDebug\n*F\n+ 1 SurfaceConfig.kt\nandroidx/camera/core/impl/SurfaceConfig\n*L\n61#1:386,2\n61#1:388,4\n*E\n"})
public final class SurfaceConfig {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ConfigType configType;
    @NotNull
    private final ConfigSize configSize;
    @NotNull
    private final StreamUseCase streamUseCase;
    private final int imageFormat;
    @JvmField
    @NotNull
    public static final StreamUseCase DEFAULT_STREAM_USE_CASE;
    @NotNull
    private static final ConfigSize[] FEATURE_COMBO_QUERY_SUPPORTED_SIZES;
    @NotNull
    private static final Map<ConfigType, Integer> IMAGE_FORMATS_BY_CONFIG_TYPE;
    @NotNull
    private static final Map<Integer, ConfigType> CONFIG_TYPES_BY_IMAGE_FORMAT;

    public SurfaceConfig(@NotNull ConfigType configType, @NotNull ConfigSize configSize, @NotNull StreamUseCase streamUseCase) {
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Intrinsics.checkNotNullParameter((Object)((Object)configSize), (String)"configSize");
        Intrinsics.checkNotNullParameter((Object)((Object)streamUseCase), (String)"streamUseCase");
        this.configType = configType;
        this.configSize = configSize;
        this.streamUseCase = streamUseCase;
        Integer n = IMAGE_FORMATS_BY_CONFIG_TYPE.get((Object)this.configType);
        this.imageFormat = n != null ? n : 0;
    }

    public /* synthetic */ SurfaceConfig(ConfigType configType, ConfigSize configSize, StreamUseCase streamUseCase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            streamUseCase = DEFAULT_STREAM_USE_CASE;
        }
        this(configType, configSize, streamUseCase);
    }

    @NotNull
    public final ConfigType getConfigType() {
        return this.configType;
    }

    @NotNull
    public final ConfigSize getConfigSize() {
        return this.configSize;
    }

    @NotNull
    public final StreamUseCase getStreamUseCase() {
        return this.streamUseCase;
    }

    public final boolean isSupported(@NotNull SurfaceConfig other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.configSize.getId() > this.configSize.getId()) {
            return false;
        }
        if (other.configType != this.configType) {
            return false;
        }
        return this.streamUseCase == StreamUseCase.DEFAULT || other.streamUseCase == StreamUseCase.DEFAULT || other.streamUseCase == this.streamUseCase;
    }

    public final int getImageFormat() {
        return this.imageFormat;
    }

    @NotNull
    public final Size getResolution(@NotNull SurfaceSizeDefinition definition) {
        Size size;
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        switch (WhenMappings.$EnumSwitchMapping$0[this.configSize.ordinal()]) {
            case 1: {
                size = definition.getPreviewSize();
                break;
            }
            case 2: {
                size = definition.getRecordSize();
                break;
            }
            case 3: {
                size = definition.getMaximumSize(this.imageFormat);
                break;
            }
            case 4: {
                size = definition.getMaximum4x3Size(this.imageFormat);
                break;
            }
            case 5: {
                size = definition.getMaximum16x9Size(this.imageFormat);
                break;
            }
            case 6: {
                size = definition.getUltraMaximumSize(this.imageFormat);
                break;
            }
            case 7: {
                throw new IllegalStateException("Not supported config size");
            }
            default: {
                size = this.configSize.getRelatedFixedSize();
            }
        }
        Intrinsics.checkNotNull((Object)size);
        return size;
    }

    @NotNull
    public final ConfigType component1() {
        return this.configType;
    }

    @NotNull
    public final ConfigSize component2() {
        return this.configSize;
    }

    @NotNull
    public final StreamUseCase component3() {
        return this.streamUseCase;
    }

    @NotNull
    public final SurfaceConfig copy(@NotNull ConfigType configType, @NotNull ConfigSize configSize, @NotNull StreamUseCase streamUseCase) {
        Intrinsics.checkNotNullParameter((Object)((Object)configType), (String)"configType");
        Intrinsics.checkNotNullParameter((Object)((Object)configSize), (String)"configSize");
        Intrinsics.checkNotNullParameter((Object)((Object)streamUseCase), (String)"streamUseCase");
        return new SurfaceConfig(configType, configSize, streamUseCase);
    }

    public static /* synthetic */ SurfaceConfig copy$default(SurfaceConfig surfaceConfig, ConfigType configType, ConfigSize configSize, StreamUseCase streamUseCase, int n, Object object) {
        if ((n & 1) != 0) {
            configType = surfaceConfig.configType;
        }
        if ((n & 2) != 0) {
            configSize = surfaceConfig.configSize;
        }
        if ((n & 4) != 0) {
            streamUseCase = surfaceConfig.streamUseCase;
        }
        return surfaceConfig.copy(configType, configSize, streamUseCase);
    }

    @NotNull
    public String toString() {
        return "SurfaceConfig(configType=" + (Object)((Object)this.configType) + ", configSize=" + (Object)((Object)this.configSize) + ", streamUseCase=" + (Object)((Object)this.streamUseCase) + ')';
    }

    public int hashCode() {
        int result = this.configType.hashCode();
        result = result * 31 + this.configSize.hashCode();
        result = result * 31 + this.streamUseCase.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SurfaceConfig)) {
            return false;
        }
        SurfaceConfig surfaceConfig = (SurfaceConfig)other;
        if (this.configType != surfaceConfig.configType) {
            return false;
        }
        if (this.configSize != surfaceConfig.configSize) {
            return false;
        }
        return this.streamUseCase == surfaceConfig.streamUseCase;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SurfaceConfig create(@NotNull ConfigType type, @NotNull ConfigSize size, @NotNull StreamUseCase streamUseCase) {
        return Companion.create(type, size, streamUseCase);
    }

    @JvmStatic
    @NotNull
    public static final ConfigType getConfigType(int imageFormat) {
        return Companion.getConfigType(imageFormat);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SurfaceConfig transformSurfaceConfig(int imageFormat, @NotNull Size size, @NotNull SurfaceSizeDefinition surfaceSizeDefinition, int cameraMode, @NotNull ConfigSource configSource, @NotNull StreamUseCase streamUseCase) {
        return Companion.transformSurfaceConfig(imageFormat, size, surfaceSizeDefinition, cameraMode, configSource, streamUseCase);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SurfaceConfig create(@NotNull ConfigType type, @NotNull ConfigSize size) {
        return Companion.create(type, size);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SurfaceConfig transformSurfaceConfig(int imageFormat, @NotNull Size size, @NotNull SurfaceSizeDefinition surfaceSizeDefinition, int cameraMode, @NotNull ConfigSource configSource) {
        return Companion.transformSurfaceConfig(imageFormat, size, surfaceSizeDefinition, cameraMode, configSource);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SurfaceConfig transformSurfaceConfig(int imageFormat, @NotNull Size size, @NotNull SurfaceSizeDefinition surfaceSizeDefinition, int cameraMode) {
        return Companion.transformSurfaceConfig(imageFormat, size, surfaceSizeDefinition, cameraMode);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final SurfaceConfig transformSurfaceConfig(int imageFormat, @NotNull Size size, @NotNull SurfaceSizeDefinition surfaceSizeDefinition) {
        return Companion.transformSurfaceConfig(imageFormat, size, surfaceSizeDefinition);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        DEFAULT_STREAM_USE_CASE = StreamUseCase.DEFAULT;
        ConfigSize[] configSizeArray = new ConfigSize[]{ConfigSize.S720P_16_9, ConfigSize.S1080P_4_3, ConfigSize.S1080P_16_9, ConfigSize.S1440P_16_9, ConfigSize.UHD, ConfigSize.X_VGA};
        FEATURE_COMBO_QUERY_SUPPORTED_SIZES = configSizeArray;
        configSizeArray = new Pair[]{TuplesKt.to((Object)((Object)ConfigType.YUV), (Object)35), TuplesKt.to((Object)((Object)ConfigType.JPEG), (Object)256), TuplesKt.to((Object)((Object)ConfigType.JPEG_R), (Object)4101), TuplesKt.to((Object)((Object)ConfigType.RAW), (Object)32), TuplesKt.to((Object)((Object)ConfigType.PRIV), (Object)34)};
        IMAGE_FORMATS_BY_CONFIG_TYPE = MapsKt.mapOf((Pair[])configSizeArray);
        Iterable $this$associateBy$iv = IMAGE_FORMATS_BY_CONFIG_TYPE.entrySet();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            Integer n = ((Number)it.getValue()).intValue();
            boolean bl2 = false;
            ConfigType configType = (ConfigType)((Object)it.getKey());
            map.put(n, configType);
        }
        CONFIG_TYPES_BY_IMAGE_FORMAT = destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\b2\b\b\u0002\u0010\u0013\u001a\u00020\u0005H\u0007J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\rH\u0007J>\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u0013\u001a\u00020\u0005H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Landroidx/camera/core/impl/SurfaceConfig$Companion;", "", "<init>", "()V", "DEFAULT_STREAM_USE_CASE", "Landroidx/camera/core/impl/StreamUseCase;", "FEATURE_COMBO_QUERY_SUPPORTED_SIZES", "", "Landroidx/camera/core/impl/SurfaceConfig$ConfigSize;", "[Landroidx/camera/core/impl/SurfaceConfig$ConfigSize;", "IMAGE_FORMATS_BY_CONFIG_TYPE", "", "Landroidx/camera/core/impl/SurfaceConfig$ConfigType;", "", "CONFIG_TYPES_BY_IMAGE_FORMAT", "create", "Landroidx/camera/core/impl/SurfaceConfig;", "type", "size", "streamUseCase", "getConfigType", "imageFormat", "transformSurfaceConfig", "Landroid/util/Size;", "surfaceSizeDefinition", "Landroidx/camera/core/impl/SurfaceSizeDefinition;", "cameraMode", "configSource", "Landroidx/camera/core/impl/SurfaceConfig$ConfigSource;", "camera-core_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SurfaceConfig create(@NotNull ConfigType type, @NotNull ConfigSize size, @NotNull StreamUseCase streamUseCase) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
            Intrinsics.checkNotNullParameter((Object)((Object)streamUseCase), (String)"streamUseCase");
            return new SurfaceConfig(type, size, streamUseCase);
        }

        public static /* synthetic */ SurfaceConfig create$default(Companion companion, ConfigType configType, ConfigSize configSize, StreamUseCase streamUseCase, int n, Object object) {
            if ((n & 4) != 0) {
                streamUseCase = DEFAULT_STREAM_USE_CASE;
            }
            return companion.create(configType, configSize, streamUseCase);
        }

        @JvmStatic
        @NotNull
        public final ConfigType getConfigType(int imageFormat) {
            ConfigType configType = (ConfigType)((Object)CONFIG_TYPES_BY_IMAGE_FORMAT.get(imageFormat));
            if (configType == null) {
                configType = ConfigType.PRIV;
            }
            return configType;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SurfaceConfig transformSurfaceConfig(int imageFormat, @NotNull Size size, @NotNull SurfaceSizeDefinition surfaceSizeDefinition, int cameraMode, @NotNull ConfigSource configSource, @NotNull StreamUseCase streamUseCase) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            Intrinsics.checkNotNullParameter((Object)surfaceSizeDefinition, (String)"surfaceSizeDefinition");
            Intrinsics.checkNotNullParameter((Object)((Object)configSource), (String)"configSource");
            Intrinsics.checkNotNullParameter((Object)((Object)streamUseCase), (String)"streamUseCase");
            ConfigType configType = this.getConfigType(imageFormat);
            ConfigSize configSize = ConfigSize.NOT_SUPPORT;
            int sizeArea = SizeUtil.getArea(size);
            if (cameraMode == 1) {
                if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getS720pSize(imageFormat))) {
                    configSize = ConfigSize.S720P_16_9;
                } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getS1440pSize(imageFormat))) {
                    configSize = ConfigSize.S1440P_4_3;
                }
            } else if (configSource == ConfigSource.FEATURE_COMBINATION_TABLE) {
                Size maximumSize = surfaceSizeDefinition.getMaximumSize(imageFormat);
                for (ConfigSize supportedSize : FEATURE_COMBO_QUERY_SUPPORTED_SIZES) {
                    if (!Intrinsics.areEqual((Object)size, (Object)supportedSize.getRelatedFixedSize())) continue;
                    configSize = supportedSize;
                    break;
                }
                if (configSize == ConfigSize.NOT_SUPPORT && Intrinsics.areEqual((Object)size, (Object)maximumSize)) {
                    configSize = ConfigSize.MAXIMUM;
                }
            } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getAnalysisSize())) {
                configSize = ConfigSize.VGA;
            } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getPreviewSize())) {
                configSize = ConfigSize.PREVIEW;
            } else if (sizeArea <= SizeUtil.getArea(surfaceSizeDefinition.getRecordSize())) {
                configSize = ConfigSize.RECORD;
            } else {
                Size maximumSize = surfaceSizeDefinition.getMaximumSize(imageFormat);
                Size ultraMaximumSize = surfaceSizeDefinition.getUltraMaximumSize(imageFormat);
                if ((maximumSize == null || sizeArea <= SizeUtil.getArea(maximumSize)) && cameraMode != 2) {
                    configSize = ConfigSize.MAXIMUM;
                } else if (ultraMaximumSize != null && sizeArea <= SizeUtil.getArea(ultraMaximumSize)) {
                    configSize = ConfigSize.ULTRA_MAXIMUM;
                }
            }
            return this.create(configType, configSize, streamUseCase);
        }

        public static /* synthetic */ SurfaceConfig transformSurfaceConfig$default(Companion companion, int n, Size size, SurfaceSizeDefinition surfaceSizeDefinition, int n2, ConfigSource configSource, StreamUseCase streamUseCase, int n3, Object object) {
            if ((n3 & 8) != 0) {
                n2 = 0;
            }
            if ((n3 & 0x10) != 0) {
                configSource = ConfigSource.CAPTURE_SESSION_TABLES;
            }
            if ((n3 & 0x20) != 0) {
                streamUseCase = DEFAULT_STREAM_USE_CASE;
            }
            return companion.transformSurfaceConfig(n, size, surfaceSizeDefinition, n2, configSource, streamUseCase);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SurfaceConfig create(@NotNull ConfigType type, @NotNull ConfigSize size) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            Intrinsics.checkNotNullParameter((Object)((Object)size), (String)"size");
            return androidx.camera.core.impl.SurfaceConfig$Companion.create$default(this, type, size, null, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SurfaceConfig transformSurfaceConfig(int imageFormat, @NotNull Size size, @NotNull SurfaceSizeDefinition surfaceSizeDefinition, int cameraMode, @NotNull ConfigSource configSource) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            Intrinsics.checkNotNullParameter((Object)surfaceSizeDefinition, (String)"surfaceSizeDefinition");
            Intrinsics.checkNotNullParameter((Object)((Object)configSource), (String)"configSource");
            return androidx.camera.core.impl.SurfaceConfig$Companion.transformSurfaceConfig$default(this, imageFormat, size, surfaceSizeDefinition, cameraMode, configSource, null, 32, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SurfaceConfig transformSurfaceConfig(int imageFormat, @NotNull Size size, @NotNull SurfaceSizeDefinition surfaceSizeDefinition, int cameraMode) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            Intrinsics.checkNotNullParameter((Object)surfaceSizeDefinition, (String)"surfaceSizeDefinition");
            return androidx.camera.core.impl.SurfaceConfig$Companion.transformSurfaceConfig$default(this, imageFormat, size, surfaceSizeDefinition, cameraMode, null, null, 48, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final SurfaceConfig transformSurfaceConfig(int imageFormat, @NotNull Size size, @NotNull SurfaceSizeDefinition surfaceSizeDefinition) {
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            Intrinsics.checkNotNullParameter((Object)surfaceSizeDefinition, (String)"surfaceSizeDefinition");
            return androidx.camera.core.impl.SurfaceConfig$Companion.transformSurfaceConfig$default(this, imageFormat, size, surfaceSizeDefinition, 0, null, null, 56, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001a\u00a8\u0006\u001b"}, d2={"Landroidx/camera/core/impl/SurfaceConfig$ConfigSize;", "", "id", "", "relatedFixedSize", "Landroid/util/Size;", "<init>", "(Ljava/lang/String;IILandroid/util/Size;)V", "getId", "()I", "getRelatedFixedSize", "()Landroid/util/Size;", "VGA", "X_VGA", "S720P_16_9", "PREVIEW", "S1080P_4_3", "S1080P_16_9", "S1440P_4_3", "S1440P_16_9", "UHD", "RECORD", "MAXIMUM", "MAXIMUM_4_3", "MAXIMUM_16_9", "ULTRA_MAXIMUM", "NOT_SUPPORT", "camera-core_release"})
    public static final class ConfigSize
    extends Enum<ConfigSize> {
        private final int id;
        @Nullable
        private final Size relatedFixedSize;
        public static final /* enum */ ConfigSize VGA = new ConfigSize(0, new Size(640, 480));
        public static final /* enum */ ConfigSize X_VGA = new ConfigSize(1, new Size(1024, 768));
        public static final /* enum */ ConfigSize S720P_16_9 = new ConfigSize(2, new Size(1280, 720));
        public static final /* enum */ ConfigSize PREVIEW = new ConfigSize("PREVIEW", 3, 3, null, 2, null);
        public static final /* enum */ ConfigSize S1080P_4_3 = new ConfigSize(4, new Size(1440, 1080));
        public static final /* enum */ ConfigSize S1080P_16_9 = new ConfigSize(5, new Size(1920, 1080));
        public static final /* enum */ ConfigSize S1440P_4_3 = new ConfigSize(6, new Size(1920, 1440));
        public static final /* enum */ ConfigSize S1440P_16_9 = new ConfigSize(7, new Size(2560, 1440));
        public static final /* enum */ ConfigSize UHD = new ConfigSize(8, new Size(3840, 2160));
        public static final /* enum */ ConfigSize RECORD = new ConfigSize("RECORD", 9, 9, null, 2, null);
        public static final /* enum */ ConfigSize MAXIMUM = new ConfigSize("MAXIMUM", 10, 10, null, 2, null);
        public static final /* enum */ ConfigSize MAXIMUM_4_3 = new ConfigSize("MAXIMUM_4_3", 11, 11, null, 2, null);
        public static final /* enum */ ConfigSize MAXIMUM_16_9 = new ConfigSize("MAXIMUM_16_9", 12, 12, null, 2, null);
        public static final /* enum */ ConfigSize ULTRA_MAXIMUM = new ConfigSize("ULTRA_MAXIMUM", 13, 13, null, 2, null);
        public static final /* enum */ ConfigSize NOT_SUPPORT = new ConfigSize("NOT_SUPPORT", 14, 14, null, 2, null);
        private static final /* synthetic */ ConfigSize[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ConfigSize(int id, Size relatedFixedSize) {
            this.id = id;
            this.relatedFixedSize = relatedFixedSize;
        }

        /* synthetic */ ConfigSize(String string, int n, int n2, Size size, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                size = null;
            }
            this(n2, size);
        }

        public final int getId() {
            return this.id;
        }

        @Nullable
        public final Size getRelatedFixedSize() {
            return this.relatedFixedSize;
        }

        public static ConfigSize[] values() {
            return (ConfigSize[])$VALUES.clone();
        }

        public static ConfigSize valueOf(String value) {
            return Enum.valueOf(ConfigSize.class, value);
        }

        @NotNull
        public static EnumEntries<ConfigSize> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = configSizeArray = new ConfigSize[]{ConfigSize.VGA, ConfigSize.X_VGA, ConfigSize.S720P_16_9, ConfigSize.PREVIEW, ConfigSize.S1080P_4_3, ConfigSize.S1080P_16_9, ConfigSize.S1440P_4_3, ConfigSize.S1440P_16_9, ConfigSize.UHD, ConfigSize.RECORD, ConfigSize.MAXIMUM, ConfigSize.MAXIMUM_4_3, ConfigSize.MAXIMUM_16_9, ConfigSize.ULTRA_MAXIMUM, ConfigSize.NOT_SUPPORT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/camera/core/impl/SurfaceConfig$ConfigSource;", "", "<init>", "(Ljava/lang/String;I)V", "FEATURE_COMBINATION_TABLE", "CAPTURE_SESSION_TABLES", "camera-core_release"})
    public static final class ConfigSource
    extends Enum<ConfigSource> {
        public static final /* enum */ ConfigSource FEATURE_COMBINATION_TABLE = new ConfigSource();
        public static final /* enum */ ConfigSource CAPTURE_SESSION_TABLES = new ConfigSource();
        private static final /* synthetic */ ConfigSource[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConfigSource[] values() {
            return (ConfigSource[])$VALUES.clone();
        }

        public static ConfigSource valueOf(String value) {
            return Enum.valueOf(ConfigSource.class, value);
        }

        @NotNull
        public static EnumEntries<ConfigSource> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = configSourceArray = new ConfigSource[]{ConfigSource.FEATURE_COMBINATION_TABLE, ConfigSource.CAPTURE_SESSION_TABLES};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Landroidx/camera/core/impl/SurfaceConfig$ConfigType;", "", "<init>", "(Ljava/lang/String;I)V", "PRIV", "YUV", "JPEG", "JPEG_R", "RAW", "camera-core_release"})
    public static final class ConfigType
    extends Enum<ConfigType> {
        public static final /* enum */ ConfigType PRIV = new ConfigType();
        public static final /* enum */ ConfigType YUV = new ConfigType();
        public static final /* enum */ ConfigType JPEG = new ConfigType();
        public static final /* enum */ ConfigType JPEG_R = new ConfigType();
        public static final /* enum */ ConfigType RAW = new ConfigType();
        private static final /* synthetic */ ConfigType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ConfigType[] values() {
            return (ConfigType[])$VALUES.clone();
        }

        public static ConfigType valueOf(String value) {
            return Enum.valueOf(ConfigType.class, value);
        }

        @NotNull
        public static EnumEntries<ConfigType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = configTypeArray = new ConfigType[]{ConfigType.PRIV, ConfigType.YUV, ConfigType.JPEG, ConfigType.JPEG_R, ConfigType.RAW};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ConfigSize.values().length];
            try {
                nArray[ConfigSize.PREVIEW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigSize.RECORD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigSize.MAXIMUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigSize.MAXIMUM_4_3.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigSize.MAXIMUM_16_9.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigSize.ULTRA_MAXIMUM.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ConfigSize.NOT_SUPPORT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

