/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Size;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AutoValue_StreamSpec;
import androidx.camera.core.impl.Config;
import com.google.auto.value.AutoValue;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class StreamSpec {
    public static final Range<Integer> FRAME_RATE_RANGE_UNSPECIFIED = new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));

    public abstract @NonNull Size getResolution();

    public abstract @NonNull Size getOriginalConfiguredResolution();

    public abstract @NonNull DynamicRange getDynamicRange();

    public abstract int getSessionType();

    public abstract @NonNull Range<Integer> getExpectedFrameRateRange();

    public abstract @Nullable Config getImplementationOptions();

    public abstract boolean getZslDisabled();

    public static @NonNull Builder builder(@NonNull Size resolution) {
        return new AutoValue_StreamSpec.Builder().setResolution(resolution).setOriginalConfiguredResolution(resolution).setSessionType(0).setExpectedFrameRateRange(FRAME_RATE_RANGE_UNSPECIFIED).setDynamicRange(DynamicRange.SDR).setZslDisabled(false);
    }

    public abstract @NonNull Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        Builder() {
        }

        public abstract @NonNull Builder setResolution(@NonNull Size var1);

        public abstract @NonNull Builder setOriginalConfiguredResolution(@NonNull Size var1);

        public abstract @NonNull Builder setSessionType(int var1);

        public abstract @NonNull Builder setDynamicRange(@NonNull DynamicRange var1);

        public abstract @NonNull Builder setExpectedFrameRateRange(@NonNull Range<Integer> var1);

        public abstract @NonNull Builder setImplementationOptions(@NonNull Config var1);

        public abstract @NonNull Builder setZslDisabled(boolean var1);

        public abstract @NonNull StreamSpec build();
    }
}

