/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.hardware.camera2.CameraCharacteristics;
import android.os.Build;
import android.util.Pair;
import android.util.Range;
import android.util.Size;
import androidx.annotation.IntRange;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.OutputSurfaceConfiguration;
import androidx.camera.core.impl.RequestProcessor;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.TagBundle;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface SessionProcessor {
    public static final int TYPE_VENDOR_LIBRARY = 0;
    public static final int TYPE_CAMERA2_EXTENSION = 1;

    public @Nullable SessionConfig initSession(@NonNull CameraInfo var1, @Nullable OutputSurfaceConfiguration var2);

    public void deInitSession();

    public void setParameters(@NonNull Config var1);

    public void onCaptureSessionStart(@NonNull RequestProcessor var1);

    public void onCaptureSessionEnd();

    public int startRepeating(@NonNull TagBundle var1, @NonNull CaptureCallback var2);

    public void stopRepeating();

    public int startCapture(boolean var1, @NonNull TagBundle var2, @NonNull CaptureCallback var3);

    public void abortCapture(int var1);

    default public int startTrigger(@NonNull Config config, @NonNull TagBundle tagBundle, @NonNull CaptureCallback callback) {
        return -1;
    }

    default public @NonNull Map<Integer, List<Size>> getSupportedPostviewSize(@NonNull Size captureSize) {
        return Collections.emptyMap();
    }

    default public @NonNull Set<Integer> getSupportedCameraOperations() {
        return Collections.emptySet();
    }

    default public @NonNull List<Pair<// Could not load outer class - annotation placement on inner may be incorrect
    CameraCharacteristics.Key, Object>> getAvailableCharacteristicsKeyValues() {
        return Collections.emptyList();
    }

    default public @Nullable Range<Float> getExtensionZoomRange() {
        if (Build.VERSION.SDK_INT >= 30) {
            List<Pair<CameraCharacteristics.Key, Object>> keyValues = this.getAvailableCharacteristicsKeyValues();
            for (Pair<CameraCharacteristics.Key, Object> keyValue : keyValues) {
                if (!((CameraCharacteristics.Key)keyValue.first).equals((Object)CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE)) continue;
                return (Range)keyValue.second;
            }
        }
        return null;
    }

    default public int @Nullable [] getExtensionAvailableStabilizationModes() {
        List<Pair<CameraCharacteristics.Key, Object>> keyValues = this.getAvailableCharacteristicsKeyValues();
        for (Pair<CameraCharacteristics.Key, Object> keyValue : keyValues) {
            if (!((CameraCharacteristics.Key)keyValue.first).equals((Object)CameraCharacteristics.CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES)) continue;
            return (int[])keyValue.second;
        }
        return null;
    }

    default public @Nullable Pair<Long, Long> getRealtimeCaptureLatency() {
        return null;
    }

    default public @NonNull Pair<Integer, Integer> getImplementationType() {
        return Pair.create((Object)0, (Object)0);
    }

    default public void setCaptureSessionRequestProcessor(@Nullable CaptureSessionRequestProcessor processor) {
    }

    public static interface CaptureSessionRequestProcessor {
        public @Nullable Pair<Long, Long> getRealtimeStillCaptureLatency();

        public void setExtensionStrength(@IntRange(from=0L, to=100L) int var1);
    }

    public static interface CaptureCallback {
        default public void onCaptureStarted(int captureSequenceId, long timestamp) {
        }

        default public void onCaptureProcessStarted(int captureSequenceId) {
        }

        default public void onCaptureFailed(int captureSequenceId) {
        }

        default public void onCaptureSequenceCompleted(int captureSequenceId) {
        }

        default public void onCaptureSequenceAborted(int captureSequenceId) {
        }

        default public void onCaptureCompleted(long timestamp, int captureSequenceId, @NonNull CameraCaptureResult captureResult) {
        }

        default public void onCaptureProcessProgressed(int progress) {
        }
    }
}

