/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.params.InputConfiguration;
import android.util.Range;
import android.util.Size;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.AutoValue_SessionConfig_OutputConfig;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.HighSpeedFpsModifier;
import androidx.camera.core.internal.compat.workaround.SurfaceSorter;
import com.google.auto.value.AutoValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class SessionConfig {
    public static final int SESSION_TYPE_REGULAR = 0;
    public static final int SESSION_TYPE_HIGH_SPEED = 1;
    public static final int DEFAULT_SESSION_TYPE = 0;
    private static final List<Integer> SUPPORTED_TEMPLATE_PRIORITY = Arrays.asList(1, 5, 3);
    private final List<OutputConfig> mOutputConfigs;
    private final OutputConfig mPostviewOutputConfig;
    private final List<CameraDevice.StateCallback> mDeviceStateCallbacks;
    private final List<CameraCaptureSession.StateCallback> mSessionStateCallbacks;
    private final List<CameraCaptureCallback> mSingleCameraCaptureCallbacks;
    private final ErrorListener mErrorListener;
    private final CaptureConfig mRepeatingCaptureConfig;
    private final int mSessionType;
    private @Nullable InputConfiguration mInputConfiguration;

    SessionConfig(List<OutputConfig> outputConfigs, List<CameraDevice.StateCallback> deviceStateCallbacks, List<CameraCaptureSession.StateCallback> sessionStateCallbacks, List<CameraCaptureCallback> singleCameraCaptureCallbacks, CaptureConfig repeatingCaptureConfig, @Nullable ErrorListener errorListener, @Nullable InputConfiguration inputConfiguration, int sessionType, @Nullable OutputConfig postviewOutputConfig) {
        this.mOutputConfigs = outputConfigs;
        this.mDeviceStateCallbacks = Collections.unmodifiableList(deviceStateCallbacks);
        this.mSessionStateCallbacks = Collections.unmodifiableList(sessionStateCallbacks);
        this.mSingleCameraCaptureCallbacks = Collections.unmodifiableList(singleCameraCaptureCallbacks);
        this.mErrorListener = errorListener;
        this.mRepeatingCaptureConfig = repeatingCaptureConfig;
        this.mInputConfiguration = inputConfiguration;
        this.mSessionType = sessionType;
        this.mPostviewOutputConfig = postviewOutputConfig;
    }

    public static @NonNull SessionConfig defaultEmptySessionConfig() {
        return new SessionConfig(new ArrayList<OutputConfig>(), new ArrayList<CameraDevice.StateCallback>(0), new ArrayList<CameraCaptureSession.StateCallback>(0), new ArrayList<CameraCaptureCallback>(0), new CaptureConfig.Builder().build(), null, null, 0, null);
    }

    public @Nullable InputConfiguration getInputConfiguration() {
        return this.mInputConfiguration;
    }

    public @NonNull List<DeferrableSurface> getSurfaces() {
        ArrayList<DeferrableSurface> deferrableSurfaces = new ArrayList<DeferrableSurface>();
        for (OutputConfig outputConfig : this.mOutputConfigs) {
            deferrableSurfaces.add(outputConfig.getSurface());
            for (DeferrableSurface sharedSurface : outputConfig.getSharedSurfaces()) {
                deferrableSurfaces.add(sharedSurface);
            }
        }
        return Collections.unmodifiableList(deferrableSurfaces);
    }

    public @NonNull List<OutputConfig> getOutputConfigs() {
        return this.mOutputConfigs;
    }

    public @Nullable OutputConfig getPostviewOutputConfig() {
        return this.mPostviewOutputConfig;
    }

    public @NonNull Config getImplementationOptions() {
        return this.mRepeatingCaptureConfig.getImplementationOptions();
    }

    public int getTemplateType() {
        return this.mRepeatingCaptureConfig.getTemplateType();
    }

    public int getSessionType() {
        return this.mSessionType;
    }

    public @NonNull Range<Integer> getExpectedFrameRateRange() {
        return this.mRepeatingCaptureConfig.getExpectedFrameRateRange();
    }

    public @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    CameraDevice.StateCallback> getDeviceStateCallbacks() {
        return this.mDeviceStateCallbacks;
    }

    public @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    CameraCaptureSession.StateCallback> getSessionStateCallbacks() {
        return this.mSessionStateCallbacks;
    }

    public @NonNull List<CameraCaptureCallback> getRepeatingCameraCaptureCallbacks() {
        return this.mRepeatingCaptureConfig.getCameraCaptureCallbacks();
    }

    public @Nullable ErrorListener getErrorListener() {
        return this.mErrorListener;
    }

    public @NonNull List<CameraCaptureCallback> getSingleCameraCaptureCallbacks() {
        return this.mSingleCameraCaptureCallbacks;
    }

    public @NonNull CaptureConfig getRepeatingCaptureConfig() {
        return this.mRepeatingCaptureConfig;
    }

    public static int getHigherPriorityTemplateType(int type1, int type2) {
        return SUPPORTED_TEMPLATE_PRIORITY.indexOf(type1) >= SUPPORTED_TEMPLATE_PRIORITY.indexOf(type2) ? type1 : type2;
    }

    @AutoValue
    public static abstract class OutputConfig {
        public static final int SURFACE_GROUP_ID_NONE = -1;

        public abstract @NonNull DeferrableSurface getSurface();

        public abstract @NonNull List<DeferrableSurface> getSharedSurfaces();

        public abstract @Nullable String getPhysicalCameraId();

        public abstract int getMirrorMode();

        public abstract int getSurfaceGroupId();

        public abstract @NonNull DynamicRange getDynamicRange();

        public static @NonNull Builder builder(@NonNull DeferrableSurface surface) {
            return new AutoValue_SessionConfig_OutputConfig.Builder().setSurface(surface).setSharedSurfaces(Collections.emptyList()).setPhysicalCameraId(null).setMirrorMode(-1).setSurfaceGroupId(-1).setDynamicRange(DynamicRange.SDR);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @NonNull Builder setSurface(@NonNull DeferrableSurface var1);

            public abstract @NonNull Builder setSharedSurfaces(@NonNull List<DeferrableSurface> var1);

            public abstract @NonNull Builder setPhysicalCameraId(@Nullable String var1);

            public abstract @NonNull Builder setMirrorMode(int var1);

            public abstract @NonNull Builder setSurfaceGroupId(int var1);

            public abstract @NonNull Builder setDynamicRange(@NonNull DynamicRange var1);

            public abstract @NonNull OutputConfig build();
        }
    }

    public static interface ErrorListener {
        public void onError(@NonNull SessionConfig var1, @NonNull SessionError var2);
    }

    public static final class ValidatingBuilder
    extends BaseBuilder {
        private static final String TAG = "ValidatingBuilder";
        private final SurfaceSorter mSurfaceSorter = new SurfaceSorter();
        private boolean mValid = true;
        private StringBuilder mInvalidReason = new StringBuilder();
        private boolean mTemplateSet = false;
        private List<ErrorListener> mErrorListeners = new ArrayList<ErrorListener>();

        public <T> void addImplementationOption(@NonNull Config.Option<T> option, @NonNull T value) {
            this.mCaptureConfigBuilder.addImplementationOption(option, value);
        }

        public void add(@NonNull SessionConfig sessionConfig) {
            String errorMessage;
            CaptureConfig captureConfig = sessionConfig.getRepeatingCaptureConfig();
            if (captureConfig.getTemplateType() != -1) {
                this.mTemplateSet = true;
                this.mCaptureConfigBuilder.setTemplateType(SessionConfig.getHigherPriorityTemplateType(captureConfig.getTemplateType(), this.mCaptureConfigBuilder.getTemplateType()));
            }
            this.setOrVerifyExpectFrameRateRange(captureConfig.getExpectedFrameRateRange());
            this.setPreviewStabilizationMode(captureConfig.getPreviewStabilizationMode());
            this.setVideoStabilizationMode(captureConfig.getVideoStabilizationMode());
            TagBundle tagBundle = sessionConfig.getRepeatingCaptureConfig().getTagBundle();
            this.mCaptureConfigBuilder.addAllTags(tagBundle);
            this.mDeviceStateCallbacks.addAll(sessionConfig.getDeviceStateCallbacks());
            this.mSessionStateCallbacks.addAll(sessionConfig.getSessionStateCallbacks());
            this.mCaptureConfigBuilder.addAllCameraCaptureCallbacks(sessionConfig.getRepeatingCameraCaptureCallbacks());
            this.mSingleCameraCaptureCallbacks.addAll(sessionConfig.getSingleCameraCaptureCallbacks());
            if (sessionConfig.getErrorListener() != null) {
                this.mErrorListeners.add(sessionConfig.getErrorListener());
            }
            if (sessionConfig.getInputConfiguration() != null) {
                this.mInputConfiguration = sessionConfig.getInputConfiguration();
            }
            this.mOutputConfigs.addAll(sessionConfig.getOutputConfigs());
            this.mCaptureConfigBuilder.getSurfaces().addAll(captureConfig.getSurfaces());
            if (!this.getSurfaces().containsAll(this.mCaptureConfigBuilder.getSurfaces())) {
                errorMessage = "Invalid configuration due to capture request surfaces are not a subset of surfaces";
                Logger.d(TAG, errorMessage);
                this.mValid = false;
                this.mInvalidReason.append(errorMessage);
            }
            if (sessionConfig.getSessionType() != this.mSessionType && sessionConfig.getSessionType() != 0 && this.mSessionType != 0) {
                errorMessage = "Invalid configuration due to that two non-default session types are set";
                Logger.d(TAG, errorMessage);
                this.mValid = false;
                this.mInvalidReason.append(errorMessage);
            } else if (sessionConfig.getSessionType() != 0) {
                this.mSessionType = sessionConfig.getSessionType();
            }
            if (sessionConfig.mPostviewOutputConfig != null) {
                if (this.mPostviewOutputConfig != sessionConfig.mPostviewOutputConfig && this.mPostviewOutputConfig != null) {
                    errorMessage = "Invalid configuration due to that two different postview output configs are set";
                    Logger.d(TAG, errorMessage);
                    this.mValid = false;
                    this.mInvalidReason.append(errorMessage);
                } else {
                    this.mPostviewOutputConfig = sessionConfig.mPostviewOutputConfig;
                }
            }
            this.mCaptureConfigBuilder.addImplementationOptions(captureConfig.getImplementationOptions());
        }

        private void setOrVerifyExpectFrameRateRange(@NonNull Range<Integer> expectedFrameRateRange) {
            if (expectedFrameRateRange.equals(StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                return;
            }
            if (this.mCaptureConfigBuilder.getExpectedFrameRateRange().equals(StreamSpec.FRAME_RATE_RANGE_UNSPECIFIED)) {
                this.mCaptureConfigBuilder.setExpectedFrameRateRange(expectedFrameRateRange);
                return;
            }
            if (!this.mCaptureConfigBuilder.getExpectedFrameRateRange().equals(expectedFrameRateRange)) {
                this.mValid = false;
                String errorMessage = "Different ExpectedFrameRateRange values; current = " + this.mCaptureConfigBuilder.getExpectedFrameRateRange() + ", new = " + expectedFrameRateRange;
                Logger.e(TAG, errorMessage);
                this.mInvalidReason.append(errorMessage);
            }
        }

        private void setPreviewStabilizationMode(int mode) {
            if (mode != 0) {
                this.mCaptureConfigBuilder.setPreviewStabilization(mode);
            }
        }

        private void setVideoStabilizationMode(int mode) {
            if (mode != 0) {
                this.mCaptureConfigBuilder.setVideoStabilization(mode);
            }
        }

        private List<DeferrableSurface> getSurfaces() {
            ArrayList<DeferrableSurface> surfaces = new ArrayList<DeferrableSurface>();
            for (OutputConfig outputConfig : this.mOutputConfigs) {
                surfaces.add(outputConfig.getSurface());
                for (DeferrableSurface sharedSurface : outputConfig.getSharedSurfaces()) {
                    surfaces.add(sharedSurface);
                }
            }
            return surfaces;
        }

        public void clearSurfaces() {
            this.mOutputConfigs.clear();
            this.mCaptureConfigBuilder.clearSurfaces();
        }

        public boolean isValid() {
            return this.mTemplateSet && this.mValid;
        }

        public @NonNull String getInvalidReason() {
            if (!this.mTemplateSet) {
                return "Template is not set";
            }
            return this.mInvalidReason.toString();
        }

        public @NonNull SessionConfig build() {
            if (!this.mValid) {
                throw new IllegalArgumentException("Unsupported session configuration combination");
            }
            ArrayList<OutputConfig> outputConfigs = new ArrayList<OutputConfig>(this.mOutputConfigs);
            this.mSurfaceSorter.sort(outputConfigs);
            if (this.mSessionType == 1) {
                new HighSpeedFpsModifier().modifyFpsForPreviewOnlyRepeating(outputConfigs, this.mCaptureConfigBuilder);
            }
            ErrorListener errorListener = null;
            if (!this.mErrorListeners.isEmpty()) {
                errorListener = (sessionConfig, error) -> {
                    for (ErrorListener listener : this.mErrorListeners) {
                        listener.onError(sessionConfig, error);
                    }
                };
            }
            return new SessionConfig(outputConfigs, new ArrayList<CameraDevice.StateCallback>(this.mDeviceStateCallbacks), new ArrayList<CameraCaptureSession.StateCallback>(this.mSessionStateCallbacks), new ArrayList<CameraCaptureCallback>(this.mSingleCameraCaptureCallbacks), this.mCaptureConfigBuilder.build(), errorListener, this.mInputConfiguration, this.mSessionType, this.mPostviewOutputConfig);
        }
    }

    public static class Builder
    extends BaseBuilder {
        public static @NonNull Builder createFrom(@NonNull UseCaseConfig<?> config, @NonNull Size resolution) {
            OptionUnpacker unpacker = config.getSessionOptionUnpacker(null);
            if (unpacker == null) {
                throw new IllegalStateException("Implementation is missing option unpacker for " + config.getTargetName(config.toString()));
            }
            Builder builder = new Builder();
            unpacker.unpack(resolution, config, builder);
            return builder;
        }

        public @NonNull Builder setInputConfiguration(@Nullable InputConfiguration inputConfiguration) {
            this.mInputConfiguration = inputConfiguration;
            return this;
        }

        public @NonNull Builder setTemplateType(int templateType) {
            this.mCaptureConfigBuilder.setTemplateType(templateType);
            return this;
        }

        public @NonNull Builder setSessionType(int sessionType) {
            this.mSessionType = sessionType;
            return this;
        }

        public @NonNull Builder setExpectedFrameRateRange(@NonNull Range<Integer> expectedFrameRateRange) {
            this.mCaptureConfigBuilder.setExpectedFrameRateRange(expectedFrameRateRange);
            return this;
        }

        public @NonNull Builder setPreviewStabilization(int mode) {
            if (mode != 0) {
                this.mCaptureConfigBuilder.setPreviewStabilization(mode);
            }
            return this;
        }

        public @NonNull Builder setVideoStabilization(int mode) {
            if (mode != 0) {
                this.mCaptureConfigBuilder.setVideoStabilization(mode);
            }
            return this;
        }

        public @NonNull Builder addTag(@NonNull String key, @NonNull Object tag) {
            this.mCaptureConfigBuilder.addTag(key, tag);
            return this;
        }

        public @NonNull Builder addDeviceStateCallback(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull CameraDevice.StateCallback deviceStateCallback) {
            if (this.mDeviceStateCallbacks.contains(deviceStateCallback)) {
                return this;
            }
            this.mDeviceStateCallbacks.add(deviceStateCallback);
            return this;
        }

        public @NonNull Builder addAllDeviceStateCallbacks(@NonNull Collection<// Could not load outer class - annotation placement on inner may be incorrect
        CameraDevice.StateCallback> deviceStateCallbacks) {
            for (CameraDevice.StateCallback callback : deviceStateCallbacks) {
                this.addDeviceStateCallback(callback);
            }
            return this;
        }

        public @NonNull Builder addSessionStateCallback(// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull CameraCaptureSession.StateCallback sessionStateCallback) {
            if (this.mSessionStateCallbacks.contains(sessionStateCallback)) {
                return this;
            }
            this.mSessionStateCallbacks.add(sessionStateCallback);
            return this;
        }

        public @NonNull Builder addAllSessionStateCallbacks(@NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        CameraCaptureSession.StateCallback> sessionStateCallbacks) {
            for (CameraCaptureSession.StateCallback callback : sessionStateCallbacks) {
                this.addSessionStateCallback(callback);
            }
            return this;
        }

        public @NonNull Builder addRepeatingCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mCaptureConfigBuilder.addCameraCaptureCallback(cameraCaptureCallback);
            return this;
        }

        public @NonNull Builder addAllRepeatingCameraCaptureCallbacks(@NonNull Collection<CameraCaptureCallback> cameraCaptureCallbacks) {
            this.mCaptureConfigBuilder.addAllCameraCaptureCallbacks(cameraCaptureCallbacks);
            return this;
        }

        public @NonNull Builder addCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            this.mCaptureConfigBuilder.addCameraCaptureCallback(cameraCaptureCallback);
            if (!this.mSingleCameraCaptureCallbacks.contains(cameraCaptureCallback)) {
                this.mSingleCameraCaptureCallbacks.add(cameraCaptureCallback);
            }
            return this;
        }

        public @NonNull Builder addAllCameraCaptureCallbacks(@NonNull Collection<CameraCaptureCallback> cameraCaptureCallbacks) {
            for (CameraCaptureCallback c : cameraCaptureCallbacks) {
                this.mCaptureConfigBuilder.addCameraCaptureCallback(c);
                if (this.mSingleCameraCaptureCallbacks.contains(c)) continue;
                this.mSingleCameraCaptureCallbacks.add(c);
            }
            return this;
        }

        public boolean removeCameraCaptureCallback(@NonNull CameraCaptureCallback cameraCaptureCallback) {
            boolean removedFromRepeating = this.mCaptureConfigBuilder.removeCameraCaptureCallback(cameraCaptureCallback);
            boolean removedFromSingle = this.mSingleCameraCaptureCallbacks.remove(cameraCaptureCallback);
            return removedFromRepeating || removedFromSingle;
        }

        public @NonNull List<CameraCaptureCallback> getSingleCameraCaptureCallbacks() {
            return Collections.unmodifiableList(this.mSingleCameraCaptureCallbacks);
        }

        public @NonNull Builder setErrorListener(@NonNull ErrorListener errorListener) {
            this.mErrorListener = errorListener;
            return this;
        }

        public @NonNull Builder addSurface(@NonNull DeferrableSurface surface) {
            return this.addSurface(surface, DynamicRange.SDR);
        }

        public @NonNull Builder addSurface(@NonNull DeferrableSurface surface, @NonNull DynamicRange dynamicRange) {
            return this.addSurface(surface, dynamicRange, null, -1);
        }

        public @NonNull Builder addSurface(@NonNull DeferrableSurface surface, @NonNull DynamicRange dynamicRange, @Nullable String physicalCameraId, int mirrorMode) {
            OutputConfig outputConfig = OutputConfig.builder(surface).setPhysicalCameraId(physicalCameraId).setDynamicRange(dynamicRange).setMirrorMode(mirrorMode).build();
            this.mOutputConfigs.add(outputConfig);
            this.mCaptureConfigBuilder.addSurface(surface);
            return this;
        }

        public @NonNull Builder addOutputConfig(@NonNull OutputConfig outputConfig) {
            this.mOutputConfigs.add(outputConfig);
            this.mCaptureConfigBuilder.addSurface(outputConfig.getSurface());
            for (DeferrableSurface sharedSurface : outputConfig.getSharedSurfaces()) {
                this.mCaptureConfigBuilder.addSurface(sharedSurface);
            }
            return this;
        }

        public @NonNull Builder addNonRepeatingSurface(@NonNull DeferrableSurface surface) {
            return this.addNonRepeatingSurface(surface, DynamicRange.SDR);
        }

        public @NonNull Builder addNonRepeatingSurface(@NonNull DeferrableSurface surface, @NonNull DynamicRange dynamicRange) {
            OutputConfig outputConfig = OutputConfig.builder(surface).setDynamicRange(dynamicRange).build();
            this.mOutputConfigs.add(outputConfig);
            return this;
        }

        public @NonNull Builder setPostviewSurface(@NonNull DeferrableSurface surface) {
            this.mPostviewOutputConfig = OutputConfig.builder(surface).build();
            return this;
        }

        public @NonNull Builder removeSurface(@NonNull DeferrableSurface surface) {
            OutputConfig outputConfigToRemove = null;
            for (OutputConfig config : this.mOutputConfigs) {
                if (!config.getSurface().equals(surface)) continue;
                outputConfigToRemove = config;
                break;
            }
            if (outputConfigToRemove != null) {
                this.mOutputConfigs.remove(outputConfigToRemove);
            }
            this.mCaptureConfigBuilder.removeSurface(surface);
            return this;
        }

        public @NonNull Builder clearSurfaces() {
            this.mOutputConfigs.clear();
            this.mCaptureConfigBuilder.clearSurfaces();
            return this;
        }

        public @NonNull Builder setImplementationOptions(@NonNull Config config) {
            this.mCaptureConfigBuilder.setImplementationOptions(config);
            return this;
        }

        public @NonNull Builder addImplementationOptions(@NonNull Config config) {
            this.mCaptureConfigBuilder.addImplementationOptions(config);
            return this;
        }

        public @NonNull SessionConfig build() {
            return new SessionConfig(new ArrayList<OutputConfig>(this.mOutputConfigs), new ArrayList<CameraDevice.StateCallback>(this.mDeviceStateCallbacks), new ArrayList<CameraCaptureSession.StateCallback>(this.mSessionStateCallbacks), new ArrayList<CameraCaptureCallback>(this.mSingleCameraCaptureCallbacks), this.mCaptureConfigBuilder.build(), this.mErrorListener, this.mInputConfiguration, this.mSessionType, this.mPostviewOutputConfig);
        }
    }

    static class BaseBuilder {
        final Set<OutputConfig> mOutputConfigs = new LinkedHashSet<OutputConfig>();
        final CaptureConfig.Builder mCaptureConfigBuilder = new CaptureConfig.Builder();
        final List<CameraDevice.StateCallback> mDeviceStateCallbacks = new ArrayList<CameraDevice.StateCallback>();
        final List<CameraCaptureSession.StateCallback> mSessionStateCallbacks = new ArrayList<CameraCaptureSession.StateCallback>();
        final List<CameraCaptureCallback> mSingleCameraCaptureCallbacks = new ArrayList<CameraCaptureCallback>();
        @Nullable ErrorListener mErrorListener;
        @Nullable InputConfiguration mInputConfiguration;
        int mSessionType = 0;
        @Nullable OutputConfig mPostviewOutputConfig;

        BaseBuilder() {
        }
    }

    public static interface OptionUnpacker {
        public void unpack(@NonNull Size var1, @NonNull UseCaseConfig<?> var2, @NonNull Builder var3);
    }

    public static final class CloseableErrorListener
    implements ErrorListener {
        private final AtomicBoolean mIsClosed = new AtomicBoolean(false);
        private final ErrorListener mErrorListener;

        public CloseableErrorListener(@NonNull ErrorListener errorListener) {
            this.mErrorListener = errorListener;
        }

        @Override
        public void onError(@NonNull SessionConfig sessionConfig, @NonNull SessionError error) {
            if (!this.mIsClosed.get()) {
                this.mErrorListener.onError(sessionConfig, error);
            }
        }

        public void close() {
            this.mIsClosed.set(true);
        }
    }

    public static enum SessionError {
        SESSION_ERROR_SURFACE_NEEDS_RESET,
        SESSION_ERROR_UNKNOWN;

    }
}

