/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.Config;
import java.util.List;
import org.jspecify.annotations.NonNull;

public interface RequestProcessor {
    public int submit(@NonNull Request var1, @NonNull Callback var2);

    public int submit(@NonNull List<Request> var1, @NonNull Callback var2);

    public int setRepeating(@NonNull Request var1, @NonNull Callback var2);

    public void abortCaptures();

    public void stopRepeating();

    public static interface Callback {
        default public void onCaptureStarted(@NonNull Request request, long frameNumber, long timestamp) {
        }

        default public void onCaptureProgressed(@NonNull Request request, @NonNull CameraCaptureResult captureResult) {
        }

        default public void onCaptureCompleted(@NonNull Request request, @NonNull CameraCaptureResult captureResult) {
        }

        default public void onCaptureFailed(@NonNull Request request, @NonNull CameraCaptureFailure captureFailure) {
        }

        default public void onCaptureBufferLost(@NonNull Request request, long frameNumber, int outputConfigId) {
        }

        default public void onCaptureSequenceCompleted(int sequenceId, long frameNumber) {
        }

        default public void onCaptureSequenceAborted(int sequenceId) {
        }
    }

    public static interface Request {
        public @NonNull List<Integer> getTargetOutputConfigIds();

        public @NonNull Config getParameters();

        public int getTemplateId();
    }
}

