/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.impl.Quirk;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class QuirkSettings {
    private final boolean mEnabledWhenDeviceHasQuirk;
    private final Set<Class<? extends Quirk>> mForceEnabledQuirks;
    private final Set<Class<? extends Quirk>> mForceDisabledQuirks;

    private QuirkSettings(boolean enabledWhenDeviceHasQuirk, @Nullable Set<Class<? extends Quirk>> forceEnabledQuirks, @Nullable Set<Class<? extends Quirk>> forceDisabledQuirks) {
        this.mEnabledWhenDeviceHasQuirk = enabledWhenDeviceHasQuirk;
        this.mForceEnabledQuirks = forceEnabledQuirks == null ? Collections.emptySet() : new HashSet<Class<? extends Quirk>>(forceEnabledQuirks);
        this.mForceDisabledQuirks = forceDisabledQuirks == null ? Collections.emptySet() : new HashSet<Class<? extends Quirk>>(forceDisabledQuirks);
    }

    public static @NonNull QuirkSettings withDefaultBehavior() {
        return new Builder().setEnabledWhenDeviceHasQuirk(true).build();
    }

    public static @NonNull QuirkSettings withAllQuirksDisabled() {
        return new Builder().setEnabledWhenDeviceHasQuirk(false).build();
    }

    public static @NonNull QuirkSettings withQuirksForceEnabled(@NonNull Set<Class<? extends Quirk>> quirks) {
        return new Builder().forceEnableQuirks(quirks).build();
    }

    public static @NonNull QuirkSettings withQuirksForceDisabled(@NonNull Set<Class<? extends Quirk>> quirks) {
        return new Builder().forceDisableQuirks(quirks).build();
    }

    public boolean isEnabledWhenDeviceHasQuirk() {
        return this.mEnabledWhenDeviceHasQuirk;
    }

    public @NonNull Set<Class<? extends Quirk>> getForceEnabledQuirks() {
        return Collections.unmodifiableSet(this.mForceEnabledQuirks);
    }

    public @NonNull Set<Class<? extends Quirk>> getForceDisabledQuirks() {
        return Collections.unmodifiableSet(this.mForceDisabledQuirks);
    }

    public boolean shouldEnableQuirk(@NonNull Class<? extends Quirk> quirk, boolean deviceHasQuirk) {
        if (this.mForceEnabledQuirks.contains(quirk)) {
            return true;
        }
        if (this.mForceDisabledQuirks.contains(quirk)) {
            return false;
        }
        return this.mEnabledWhenDeviceHasQuirk && deviceHasQuirk;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof QuirkSettings)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        QuirkSettings other = (QuirkSettings)obj;
        return this.mEnabledWhenDeviceHasQuirk == other.mEnabledWhenDeviceHasQuirk && Objects.equals(this.mForceEnabledQuirks, other.mForceEnabledQuirks) && Objects.equals(this.mForceDisabledQuirks, other.mForceDisabledQuirks);
    }

    public int hashCode() {
        return Objects.hash(this.mEnabledWhenDeviceHasQuirk, this.mForceEnabledQuirks, this.mForceDisabledQuirks);
    }

    public @NonNull String toString() {
        return "QuirkSettings{enabledWhenDeviceHasQuirk=" + this.mEnabledWhenDeviceHasQuirk + ", forceEnabledQuirks=" + this.mForceEnabledQuirks + ", forceDisabledQuirks=" + this.mForceDisabledQuirks + '}';
    }

    public static class Builder {
        private boolean mEnabledWhenDeviceHasQuirk = true;
        private Set<Class<? extends Quirk>> mForceEnabledQuirks;
        private Set<Class<? extends Quirk>> mForceDisabledQuirks;

        public @NonNull Builder setEnabledWhenDeviceHasQuirk(boolean enabled) {
            this.mEnabledWhenDeviceHasQuirk = enabled;
            return this;
        }

        public @NonNull Builder forceEnableQuirks(@NonNull Set<Class<? extends Quirk>> quirks) {
            this.mForceEnabledQuirks = new HashSet<Class<? extends Quirk>>(quirks);
            return this;
        }

        public @NonNull Builder forceDisableQuirks(@NonNull Set<Class<? extends Quirk>> quirks) {
            this.mForceDisabledQuirks = new HashSet<Class<? extends Quirk>>(quirks);
            return this;
        }

        public @NonNull QuirkSettings build() {
            return new QuirkSettings(this.mEnabledWhenDeviceHasQuirk, this.mForceEnabledQuirks, this.mForceDisabledQuirks);
        }
    }
}

