/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Pair;
import android.util.Size;
import androidx.camera.core.AspectRatio;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ReadableConfig;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface ImageOutputConfig
extends ReadableConfig {
    public static final int INVALID_ROTATION = -1;
    public static final int ROTATION_NOT_SPECIFIED = -1;
    public static final Config.Option<Integer> OPTION_TARGET_ASPECT_RATIO = Config.Option.create("camerax.core.imageOutput.targetAspectRatio", AspectRatio.class);
    public static final Config.Option<Integer> OPTION_TARGET_ROTATION = Config.Option.create("camerax.core.imageOutput.targetRotation", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_APP_TARGET_ROTATION = Config.Option.create("camerax.core.imageOutput.appTargetRotation", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_MIRROR_MODE = Config.Option.create("camerax.core.imageOutput.mirrorMode", Integer.TYPE);
    public static final Config.Option<Size> OPTION_TARGET_RESOLUTION = Config.Option.create("camerax.core.imageOutput.targetResolution", Size.class);
    public static final Config.Option<Size> OPTION_DEFAULT_RESOLUTION = Config.Option.create("camerax.core.imageOutput.defaultResolution", Size.class);
    public static final Config.Option<Size> OPTION_MAX_RESOLUTION = Config.Option.create("camerax.core.imageOutput.maxResolution", Size.class);
    public static final Config.Option<List<Pair<Integer, Size[]>>> OPTION_SUPPORTED_RESOLUTIONS = Config.Option.create("camerax.core.imageOutput.supportedResolutions", List.class);
    public static final Config.Option<ResolutionSelector> OPTION_RESOLUTION_SELECTOR = Config.Option.create("camerax.core.imageOutput.resolutionSelector", ResolutionSelector.class);
    public static final Config.Option<List<Size>> OPTION_CUSTOM_ORDERED_RESOLUTIONS = Config.Option.create("camerax.core.imageOutput.customOrderedResolutions", List.class);

    default public boolean hasTargetAspectRatio() {
        return this.containsOption(OPTION_TARGET_ASPECT_RATIO);
    }

    default public int getTargetAspectRatio() {
        return this.retrieveOption(OPTION_TARGET_ASPECT_RATIO);
    }

    default public int getTargetRotation(int valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_ROTATION, valueIfMissing);
    }

    default public int getAppTargetRotation(int valueIfMissing) {
        return this.retrieveOption(OPTION_APP_TARGET_ROTATION, valueIfMissing);
    }

    default public int getTargetRotation() {
        return this.retrieveOption(OPTION_TARGET_ROTATION);
    }

    default public @Nullable Size getTargetResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_TARGET_RESOLUTION, valueIfMissing);
    }

    default public int getMirrorMode(int valueIfMissing) {
        return this.retrieveOption(OPTION_MIRROR_MODE, valueIfMissing);
    }

    default public @NonNull Size getTargetResolution() {
        return this.retrieveOption(OPTION_TARGET_RESOLUTION);
    }

    default public @Nullable Size getDefaultResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_DEFAULT_RESOLUTION, valueIfMissing);
    }

    default public @NonNull Size getDefaultResolution() {
        return this.retrieveOption(OPTION_DEFAULT_RESOLUTION);
    }

    default public @Nullable Size getMaxResolution(@Nullable Size valueIfMissing) {
        return this.retrieveOption(OPTION_MAX_RESOLUTION, valueIfMissing);
    }

    default public @NonNull Size getMaxResolution() {
        return this.retrieveOption(OPTION_MAX_RESOLUTION);
    }

    default public @Nullable List<Pair<Integer, Size[]>> getSupportedResolutions(@Nullable List<Pair<Integer, Size[]>> valueIfMissing) {
        return this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS, valueIfMissing);
    }

    default public @Nullable ResolutionSelector getResolutionSelector(@Nullable ResolutionSelector valueIfMissing) {
        return this.retrieveOption(OPTION_RESOLUTION_SELECTOR, valueIfMissing);
    }

    default public @NonNull ResolutionSelector getResolutionSelector() {
        return this.retrieveOption(OPTION_RESOLUTION_SELECTOR);
    }

    default public @NonNull List<Pair<Integer, Size[]>> getSupportedResolutions() {
        return this.retrieveOption(OPTION_SUPPORTED_RESOLUTIONS);
    }

    default public @Nullable List<Size> getCustomOrderedResolutions(@Nullable List<Size> valueIfMissing) {
        List<Size> list = this.retrieveOption(OPTION_CUSTOM_ORDERED_RESOLUTIONS, valueIfMissing);
        return list != null ? new ArrayList<Size>(list) : null;
    }

    default public @NonNull List<Size> getCustomOrderedResolutions() {
        return new ArrayList<Size>((Collection)Objects.requireNonNull(this.retrieveOption(OPTION_CUSTOM_ORDERED_RESOLUTIONS)));
    }

    public static void validateConfig(@NonNull ImageOutputConfig config) {
        boolean hasTargetResolution;
        boolean hasTargetAspectRatio = config.hasTargetAspectRatio();
        boolean bl = hasTargetResolution = config.getTargetResolution(null) != null;
        if (hasTargetAspectRatio && hasTargetResolution) {
            throw new IllegalArgumentException("Cannot use both setTargetResolution and setTargetAspectRatio on the same config.");
        }
        ResolutionSelector resolutionSelector = config.getResolutionSelector(null);
        if (resolutionSelector != null && (hasTargetAspectRatio || hasTargetResolution)) {
            throw new IllegalArgumentException("Cannot use setTargetResolution or setTargetAspectRatio with setResolutionSelector on the same config.");
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RotationDegreesValue {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OptionalRotationValue {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RotationValue {
    }

    public static interface Builder<B> {
        public @NonNull B setTargetAspectRatio(int var1);

        public @NonNull B setTargetRotation(int var1);

        public @NonNull B setMirrorMode(int var1);

        public @NonNull B setTargetResolution(@NonNull Size var1);

        public @NonNull B setDefaultResolution(@NonNull Size var1);

        public @NonNull B setMaxResolution(@NonNull Size var1);

        public @NonNull B setSupportedResolutions(@NonNull List<Pair<Integer, Size[]>> var1);

        public @NonNull B setCustomOrderedResolutions(@NonNull List<Size> var1);

        public @NonNull B setResolutionSelector(@NonNull ResolutionSelector var1);
    }
}

