/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ReadableConfig;
import androidx.core.util.Preconditions;
import org.jspecify.annotations.NonNull;

public interface ImageInputConfig
extends ReadableConfig {
    public static final Config.Option<Integer> OPTION_INPUT_FORMAT = Config.Option.create("camerax.core.imageInput.inputFormat", Integer.TYPE);
    public static final Config.Option<Integer> OPTION_SECONDARY_INPUT_FORMAT = Config.Option.create("camerax.core.imageInput.secondaryInputFormat", Integer.TYPE);
    public static final Config.Option<DynamicRange> OPTION_INPUT_DYNAMIC_RANGE = Config.Option.create("camerax.core.imageInput.inputDynamicRange", DynamicRange.class);

    default public int getInputFormat() {
        return this.retrieveOption(OPTION_INPUT_FORMAT);
    }

    default public int getSecondaryInputFormat() {
        return this.retrieveOption(OPTION_SECONDARY_INPUT_FORMAT, 0);
    }

    default public @NonNull DynamicRange getDynamicRange() {
        return (DynamicRange)Preconditions.checkNotNull((Object)this.retrieveOption(OPTION_INPUT_DYNAMIC_RANGE, DynamicRange.UNSPECIFIED));
    }

    default public boolean hasDynamicRange() {
        return this.containsOption(OPTION_INPUT_DYNAMIC_RANGE);
    }

    public static interface Builder<B> {
        public @NonNull B setDynamicRange(@NonNull DynamicRange var1);
    }
}

