/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageReaderProxyProvider;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.UseCaseConfig;
import androidx.camera.core.internal.ThreadConfig;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class ImageAnalysisConfig
implements UseCaseConfig<ImageAnalysis>,
ImageOutputConfig,
ThreadConfig {
    public static final Config.Option<Integer> OPTION_BACKPRESSURE_STRATEGY = Config.Option.create("camerax.core.imageAnalysis.backpressureStrategy", ImageAnalysis.BackpressureStrategy.class);
    public static final Config.Option<Integer> OPTION_IMAGE_QUEUE_DEPTH = Config.Option.create("camerax.core.imageAnalysis.imageQueueDepth", Integer.TYPE);
    public static final Config.Option<ImageReaderProxyProvider> OPTION_IMAGE_READER_PROXY_PROVIDER = Config.Option.create("camerax.core.imageAnalysis.imageReaderProxyProvider", ImageReaderProxyProvider.class);
    public static final Config.Option<Integer> OPTION_OUTPUT_IMAGE_FORMAT = Config.Option.create("camerax.core.imageAnalysis.outputImageFormat", ImageAnalysis.OutputImageFormat.class);
    public static final Config.Option<Boolean> OPTION_ONE_PIXEL_SHIFT_ENABLED = Config.Option.create("camerax.core.imageAnalysis.onePixelShiftEnabled", Boolean.class);
    public static final Config.Option<Boolean> OPTION_OUTPUT_IMAGE_ROTATION_ENABLED = Config.Option.create("camerax.core.imageAnalysis.outputImageRotationEnabled", Boolean.class);
    private final OptionsBundle mConfig;

    public ImageAnalysisConfig(@NonNull OptionsBundle config) {
        this.mConfig = config;
    }

    @Override
    public @NonNull Config getConfig() {
        return this.mConfig;
    }

    public int getBackpressureStrategy(int valueIfMissing) {
        return this.retrieveOption(OPTION_BACKPRESSURE_STRATEGY, valueIfMissing);
    }

    public int getBackpressureStrategy() {
        return this.retrieveOption(OPTION_BACKPRESSURE_STRATEGY);
    }

    public int getImageQueueDepth(int valueIfMissing) {
        return this.retrieveOption(OPTION_IMAGE_QUEUE_DEPTH, valueIfMissing);
    }

    public int getImageQueueDepth() {
        return this.retrieveOption(OPTION_IMAGE_QUEUE_DEPTH);
    }

    public int getOutputImageFormat(int valueIfMissing) {
        return this.retrieveOption(OPTION_OUTPUT_IMAGE_FORMAT, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable Boolean getOnePixelShiftEnabled(@Nullable Boolean valueIfMissing) {
        return this.retrieveOption(OPTION_ONE_PIXEL_SHIFT_ENABLED, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable Boolean isOutputImageRotationEnabled(@Nullable Boolean valueIfMissing) {
        return this.retrieveOption(OPTION_OUTPUT_IMAGE_ROTATION_ENABLED, valueIfMissing);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public @Nullable ImageReaderProxyProvider getImageReaderProxyProvider() {
        return this.retrieveOption(OPTION_IMAGE_READER_PROXY_PROVIDER, null);
    }

    @Override
    public int getInputFormat() {
        return 35;
    }
}

