/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.DynamicRange;
import androidx.core.util.Preconditions;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007J*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a8\u0006\u0011"}, d2={"Landroidx/camera/core/impl/DynamicRanges;", "", "<init>", "()V", "canResolve", "", "dynamicRangeToTest", "Landroidx/camera/core/DynamicRange;", "fullySpecifiedDynamicRanges", "", "findAllPossibleMatches", "dynamicRangesToTest", "canResolveUnderSpecifiedTo", "underSpecifiedDynamicRange", "fullySpecifiedDynamicRange", "canMatchBitDepth", "canMatchEncoding", "camera-core_release"})
@SourceDebugExtension(value={"SMAP\nDynamicRanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DynamicRanges.kt\nandroidx/camera/core/impl/DynamicRanges\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n295#2,2:131\n1863#2:133\n1863#2,2:134\n1864#2:136\n*S KotlinDebug\n*F\n+ 1 DynamicRanges.kt\nandroidx/camera/core/impl/DynamicRanges\n*L\n40#1:131,2\n65#1:133\n74#1:134,2\n65#1:136\n*E\n"})
public final class DynamicRanges {
    @NotNull
    public static final DynamicRanges INSTANCE = new DynamicRanges();

    private DynamicRanges() {
    }

    @JvmStatic
    public static final boolean canResolve(@NotNull DynamicRange dynamicRangeToTest, @NotNull Set<DynamicRange> fullySpecifiedDynamicRanges) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dynamicRangeToTest, (String)"dynamicRangeToTest");
        Intrinsics.checkNotNullParameter(fullySpecifiedDynamicRanges, (String)"fullySpecifiedDynamicRanges");
        if (dynamicRangeToTest.isFullySpecified()) {
            bl = fullySpecifiedDynamicRanges.contains(dynamicRangeToTest);
        } else {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = fullySpecifiedDynamicRanges;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DynamicRange fullySpecifiedDynamicRange = (DynamicRange)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.canResolveUnderSpecifiedTo(dynamicRangeToTest, fullySpecifiedDynamicRange)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            bl = v1 != null;
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final Set<DynamicRange> findAllPossibleMatches(@NotNull Set<DynamicRange> dynamicRangesToTest, @NotNull Set<DynamicRange> fullySpecifiedDynamicRanges) {
        Set set;
        Intrinsics.checkNotNullParameter(dynamicRangesToTest, (String)"dynamicRangesToTest");
        Intrinsics.checkNotNullParameter(fullySpecifiedDynamicRanges, (String)"fullySpecifiedDynamicRanges");
        if (dynamicRangesToTest.isEmpty()) {
            throw new IllegalArgumentException("Candidate dynamic range set must contain at least 1 candidate dynamic range.");
        }
        Set $this$findAllPossibleMatches_u24lambda_u243 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = dynamicRangesToTest;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DynamicRange it = (DynamicRange)element$iv;
            boolean bl2 = false;
            if (it.isFullySpecified()) {
                if (!fullySpecifiedDynamicRanges.contains(it)) continue;
                $this$findAllPossibleMatches_u24lambda_u243.add(it);
                continue;
            }
            Iterable $this$forEach$iv2 = fullySpecifiedDynamicRanges;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DynamicRange fullySpecifiedDynamicRange = (DynamicRange)element$iv2;
                boolean bl3 = false;
                if (!INSTANCE.canResolveUnderSpecifiedTo(it, fullySpecifiedDynamicRange)) continue;
                $this$findAllPossibleMatches_u24lambda_u243.add(fullySpecifiedDynamicRange);
            }
        }
        return SetsKt.build((Set)set);
    }

    private final boolean canResolveUnderSpecifiedTo(DynamicRange underSpecifiedDynamicRange, DynamicRange fullySpecifiedDynamicRange) {
        return this.canMatchBitDepth(underSpecifiedDynamicRange, fullySpecifiedDynamicRange) && this.canMatchEncoding(underSpecifiedDynamicRange, fullySpecifiedDynamicRange);
    }

    private final boolean canMatchBitDepth(DynamicRange dynamicRangeToTest, DynamicRange fullySpecifiedDynamicRange) {
        Preconditions.checkState((boolean)fullySpecifiedDynamicRange.isFullySpecified(), (String)"Fully specified range is not actually fully specified.");
        return dynamicRangeToTest.getBitDepth() == 0 ? true : dynamicRangeToTest.getBitDepth() == fullySpecifiedDynamicRange.getBitDepth();
    }

    private final boolean canMatchEncoding(DynamicRange dynamicRangeToTest, DynamicRange fullySpecifiedDynamicRange) {
        Preconditions.checkState((boolean)fullySpecifiedDynamicRange.isFullySpecified(), (String)"Fully specified range is not actually fully specified.");
        int encodingToTest = dynamicRangeToTest.getEncoding();
        if (encodingToTest == 0) {
            return true;
        }
        int fullySpecifiedEncoding = fullySpecifiedDynamicRange.getEncoding();
        return encodingToTest == 2 && fullySpecifiedEncoding != 1 ? true : encodingToTest == fullySpecifiedEncoding;
    }
}

