/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.CameraCaptureResult;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jspecify.annotations.NonNull;

public class ConvergenceUtils {
    private static final String TAG = "ConvergenceUtils";
    private static final Set<CameraCaptureMetaData.AfState> AF_CONVERGED_STATE_SET = Collections.unmodifiableSet(EnumSet.of(CameraCaptureMetaData.AfState.PASSIVE_FOCUSED, CameraCaptureMetaData.AfState.PASSIVE_NOT_FOCUSED, CameraCaptureMetaData.AfState.LOCKED_FOCUSED, CameraCaptureMetaData.AfState.LOCKED_NOT_FOCUSED));
    private static final Set<CameraCaptureMetaData.AwbState> AWB_CONVERGED_STATE_SET = Collections.unmodifiableSet(EnumSet.of(CameraCaptureMetaData.AwbState.CONVERGED, CameraCaptureMetaData.AwbState.UNKNOWN));
    private static final Set<CameraCaptureMetaData.AeState> AE_CONVERGED_STATE_SET = Collections.unmodifiableSet(EnumSet.of(CameraCaptureMetaData.AeState.CONVERGED, CameraCaptureMetaData.AeState.FLASH_REQUIRED, CameraCaptureMetaData.AeState.UNKNOWN));
    private static final Set<CameraCaptureMetaData.AeState> AE_TORCH_AS_FLASH_CONVERGED_STATE_SET;

    private ConvergenceUtils() {
    }

    public static boolean is3AConverged(@NonNull CameraCaptureResult captureResult, boolean isTorchAsFlash) {
        boolean isAeModeOff;
        boolean isAfReady = captureResult.getAfMode() == CameraCaptureMetaData.AfMode.OFF || captureResult.getAfMode() == CameraCaptureMetaData.AfMode.UNKNOWN || AF_CONVERGED_STATE_SET.contains((Object)captureResult.getAfState());
        boolean bl = isAeModeOff = captureResult.getAeMode() == CameraCaptureMetaData.AeMode.OFF;
        boolean isAeReady = isTorchAsFlash ? isAeModeOff || AE_TORCH_AS_FLASH_CONVERGED_STATE_SET.contains((Object)captureResult.getAeState()) : isAeModeOff || AE_CONVERGED_STATE_SET.contains((Object)captureResult.getAeState());
        boolean isAwbModeOff = captureResult.getAwbMode() == CameraCaptureMetaData.AwbMode.OFF;
        boolean isAwbReady = isAwbModeOff || AWB_CONVERGED_STATE_SET.contains((Object)captureResult.getAwbState());
        Logger.d(TAG, "checkCaptureResult, AE=" + (Object)((Object)captureResult.getAeState()) + " AF =" + (Object)((Object)captureResult.getAfState()) + " AWB=" + (Object)((Object)captureResult.getAwbState()));
        return isAfReady && isAeReady && isAwbReady;
    }

    static {
        EnumSet<CameraCaptureMetaData.AeState> aeStateSet = EnumSet.copyOf(AE_CONVERGED_STATE_SET);
        aeStateSet.remove((Object)CameraCaptureMetaData.AeState.FLASH_REQUIRED);
        aeStateSet.remove((Object)CameraCaptureMetaData.AeState.UNKNOWN);
        AE_TORCH_AS_FLASH_CONVERGED_STATE_SET = Collections.unmodifiableSet(aeStateSet);
    }
}

