/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.impl.AutoValue_Config_Option;
import androidx.camera.core.impl.ImageOutputConfig;
import androidx.camera.core.impl.MutableOptionsBundle;
import androidx.camera.core.impl.OptionsBundle;
import androidx.camera.core.impl.utils.ResolutionSelectorUtil;
import androidx.camera.core.resolutionselector.ResolutionSelector;
import com.google.auto.value.AutoValue;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface Config {
    public boolean containsOption(@NonNull Option<?> var1);

    public <ValueT> @Nullable ValueT retrieveOption(@NonNull Option<ValueT> var1);

    public <ValueT> @Nullable ValueT retrieveOption(@NonNull Option<ValueT> var1, @Nullable ValueT var2);

    public <ValueT> @Nullable ValueT retrieveOptionWithPriority(@NonNull Option<ValueT> var1, @NonNull OptionPriority var2);

    public @NonNull OptionPriority getOptionPriority(@NonNull Option<?> var1);

    public void findOptions(@NonNull String var1, @NonNull OptionMatcher var2);

    public @NonNull Set<Option<?>> listOptions();

    public @NonNull Set<OptionPriority> getPriorities(@NonNull Option<?> var1);

    public static boolean hasConflict(@NonNull OptionPriority priority1, @NonNull OptionPriority priority2) {
        return priority1 == OptionPriority.REQUIRED && priority2 == OptionPriority.REQUIRED;
    }

    public static @NonNull Config mergeConfigs(@Nullable Config extendedConfig, @Nullable Config baseConfig) {
        if (extendedConfig == null && baseConfig == null) {
            return OptionsBundle.emptyBundle();
        }
        MutableOptionsBundle mergedConfig = baseConfig != null ? MutableOptionsBundle.from(baseConfig) : MutableOptionsBundle.create();
        if (extendedConfig != null) {
            for (Option<?> opt : extendedConfig.listOptions()) {
                Config.mergeOptionValue(mergedConfig, baseConfig, extendedConfig, opt);
            }
        }
        return OptionsBundle.from(mergedConfig);
    }

    public static void mergeOptionValue(@NonNull MutableOptionsBundle mergedConfig, @NonNull Config baseConfig, @NonNull Config extendedConfig, @NonNull Option<?> opt) {
        Option<?> objectOpt = opt;
        if (Objects.equals(objectOpt, ImageOutputConfig.OPTION_RESOLUTION_SELECTOR)) {
            ResolutionSelector resolutionSelectorToOverride = extendedConfig.retrieveOption(objectOpt, null);
            ResolutionSelector baseResolutionSelector = baseConfig.retrieveOption(objectOpt, null);
            mergedConfig.insertOption(objectOpt, extendedConfig.getOptionPriority(opt), ResolutionSelectorUtil.overrideResolutionSelectors(baseResolutionSelector, resolutionSelectorToOverride));
        } else {
            mergedConfig.insertOption(objectOpt, extendedConfig.getOptionPriority(opt), extendedConfig.retrieveOption(objectOpt));
        }
    }

    public static enum OptionPriority {
        ALWAYS_OVERRIDE,
        HIGH_PRIORITY_REQUIRED,
        REQUIRED,
        OPTIONAL;

    }

    @AutoValue
    public static abstract class Option<T> {
        Option() {
        }

        public static <T> @NonNull Option<T> create(@NonNull String id, @NonNull Class<?> valueClass) {
            return Option.create(id, valueClass, null);
        }

        public static <T> @NonNull Option<T> create(@NonNull String id, @NonNull Class<?> valueClass, @Nullable Object token) {
            return new AutoValue_Config_Option(id, valueClass, token);
        }

        public abstract @NonNull String getId();

        public abstract @NonNull Class<T> getValueClass();

        public abstract @Nullable Object getToken();
    }

    public static interface OptionMatcher {
        public boolean onOptionMatched(@NonNull Option<?> var1);
    }
}

