/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.ExperimentalRetryPolicy;
import androidx.camera.core.Logger;
import androidx.camera.core.RetryPolicy;
import androidx.camera.core.impl.CameraValidator;
import androidx.camera.core.impl.RetryPolicyInternal;
import androidx.camera.core.impl.TimeoutRetryPolicy;
import org.jspecify.annotations.NonNull;

@ExperimentalRetryPolicy
public final class CameraProviderInitRetryPolicy
implements RetryPolicyInternal {
    private final RetryPolicy mDelegatePolicy;

    public CameraProviderInitRetryPolicy(final long timeoutInMillis) {
        this.mDelegatePolicy = new TimeoutRetryPolicy(timeoutInMillis, new RetryPolicy(){

            @Override
            public @NonNull RetryPolicy.RetryConfig onRetryDecisionRequested(@NonNull RetryPolicy.ExecutionState executionState) {
                if (executionState.getStatus() == 1) {
                    return RetryPolicy.RetryConfig.NOT_RETRY;
                }
                return RetryPolicy.RetryConfig.DEFAULT_DELAY_RETRY;
            }

            @Override
            public long getTimeoutInMillis() {
                return timeoutInMillis;
            }
        });
    }

    @Override
    public @NonNull RetryPolicy.RetryConfig onRetryDecisionRequested(@NonNull RetryPolicy.ExecutionState executionState) {
        return this.mDelegatePolicy.onRetryDecisionRequested(executionState);
    }

    @Override
    public long getTimeoutInMillis() {
        return this.mDelegatePolicy.getTimeoutInMillis();
    }

    @Override
    public @NonNull RetryPolicy copy(long timeoutInMillis) {
        return new CameraProviderInitRetryPolicy(timeoutInMillis);
    }

    public static final class Legacy
    implements RetryPolicyInternal {
        private final RetryPolicy mBasePolicy;

        public Legacy(long timeoutInMillis) {
            this.mBasePolicy = new CameraProviderInitRetryPolicy(timeoutInMillis);
        }

        @Override
        public @NonNull RetryPolicy.RetryConfig onRetryDecisionRequested(@NonNull RetryPolicy.ExecutionState executionState) {
            if (!this.mBasePolicy.onRetryDecisionRequested(executionState).shouldRetry()) {
                Throwable cause = executionState.getCause();
                if (cause instanceof CameraValidator.CameraIdListIncorrectException) {
                    Logger.e("CameraX", "The device might underreport the amount of the cameras. Finish the initialize task since we are already reaching the maximum number of retries.");
                    if (((CameraValidator.CameraIdListIncorrectException)cause).getAvailableCameraCount() > 0) {
                        return RetryPolicy.RetryConfig.COMPLETE_WITHOUT_FAILURE;
                    }
                }
                return RetryPolicy.RetryConfig.NOT_RETRY;
            }
            return RetryPolicy.RetryConfig.DEFAULT_DELAY_RETRY;
        }

        @Override
        public long getTimeoutInMillis() {
            return this.mBasePolicy.getTimeoutInMillis();
        }

        @Override
        public @NonNull RetryPolicy copy(long timeoutInMillis) {
            return new Legacy(timeoutInMillis);
        }
    }
}

