/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.GuardedBy;
import androidx.camera.core.CameraIdentifier;
import androidx.camera.core.CameraPresenceListener;
import androidx.camera.core.CameraState;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.CameraRepository;
import androidx.camera.core.impl.InternalCameraPresenceListener;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 ;2\u00020\u0001:\u00039:;B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010 \u001a\u00020\u001fJ\u0016\u0010!\u001a\u00020\u001f2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J$\u0010#\u001a\u00020\u001f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0%H\u0002J\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0016J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0016J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001bH\u0002J\u0010\u0010,\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020\u001bH\u0002J\b\u00100\u001a\u00020\u001fH\u0002J\u0016\u00101\u001a\u00020\u001f2\u0006\u0010(\u001a\u0002022\u0006\u00103\u001a\u00020\u0003J\u000e\u00104\u001a\u00020\u001f2\u0006\u0010(\u001a\u000202J\u0016\u00105\u001a\u00020\u001f2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u000e0%H\u0002J\u0016\u00107\u001a\u00020\u001f2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u000e0%H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Landroidx/camera/core/impl/CameraPresenceProvider;", "", "backgroundExecutor", "Ljava/util/concurrent/Executor;", "<init>", "(Ljava/util/concurrent/Executor;)V", "observerLock", "cameraFactory", "Landroidx/camera/core/impl/CameraFactory;", "cameraRepository", "Landroidx/camera/core/impl/CameraRepository;", "sourcePresenceObservable", "Landroidx/camera/core/impl/Observable;", "", "Landroidx/camera/core/CameraIdentifier;", "sourceObserver", "Landroidx/camera/core/impl/CameraPresenceProvider$SourceObservableObserver;", "currentFilteredIds", "isMonitoring", "Ljava/util/concurrent/atomic/AtomicBoolean;", "dependentInternalListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Landroidx/camera/core/impl/InternalCameraPresenceListener;", "publicApiListeners", "Landroidx/camera/core/impl/CameraPresenceProvider$ListenerWrapper;", "cameraStateObservers", "", "", "Landroidx/lifecycle/Observer;", "Landroidx/camera/core/CameraState;", "startup", "", "shutdown", "processFilteredCameraIdUpdate", "newFilteredIdentifiers", "notifyPublicListeners", "addedCameras", "", "removedCameras", "addDependentInternalListener", "listener", "removeDependentInternalListener", "conditionallySetupCameraStateObserver", "systemCameraId", "setupCameraStateObserver", "cameraInfoInternal", "Landroidx/camera/core/impl/CameraInfoInternal;", "removeCameraStateObserver", "clearAllCameraStateObservers", "addCameraPresenceListener", "Landroidx/camera/core/CameraPresenceListener;", "executor", "removeCameraPresenceListener", "notifyPublicCamerasAdded", "addedIds", "notifyPublicCamerasRemoved", "removedIds", "ListenerWrapper", "SourceObservableObserver", "Companion", "camera-core_release"})
@SourceDebugExtension(value={"SMAP\nCameraPresenseProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraPresenseProvider.kt\nandroidx/camera/core/impl/CameraPresenceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,351:1\n1557#2:352\n1628#2,3:353\n1557#2:356\n1628#2,3:357\n1863#2,2:360\n1863#2,2:362\n1863#2,2:364\n1557#2:366\n1628#2,3:367\n1863#2,2:370\n1863#2,2:372\n1863#2,2:374\n1557#2:376\n1628#2,3:377\n1863#2,2:384\n1863#2,2:386\n295#2,2:388\n126#3:380\n153#3,3:381\n*S KotlinDebug\n*F\n+ 1 CameraPresenseProvider.kt\nandroidx/camera/core/impl/CameraPresenceProvider\n*L\n77#1:352\n77#1:353,3\n145#1:356\n145#1:357,3\n149#1:360,2\n162#1:362,2\n170#1:364,2\n175#1:366\n175#1:367,3\n178#1:370,2\n189#1:372,2\n190#1:374,2\n302#1:376\n302#1:377,3\n336#1:384,2\n342#1:386,2\n308#1:388,2\n304#1:380\n304#1:381,3\n*E\n"})
public final class CameraPresenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Executor backgroundExecutor;
    @NotNull
    private final Object observerLock;
    @Nullable
    private CameraFactory cameraFactory;
    @Nullable
    private CameraRepository cameraRepository;
    @Nullable
    private Observable<List<CameraIdentifier>> sourcePresenceObservable;
    @NotNull
    private final SourceObservableObserver sourceObserver;
    @NotNull
    private volatile List<CameraIdentifier> currentFilteredIds;
    @NotNull
    private final AtomicBoolean isMonitoring;
    @NotNull
    private final CopyOnWriteArrayList<InternalCameraPresenceListener> dependentInternalListeners;
    @NotNull
    private final CopyOnWriteArrayList<ListenerWrapper> publicApiListeners;
    @GuardedBy(value="observerLock")
    @NotNull
    private final Map<String, Observer<CameraState>> cameraStateObservers;
    @NotNull
    private static final String TAG = "CameraPresencePrvdr";

    public CameraPresenceProvider(@NotNull Executor backgroundExecutor) {
        Intrinsics.checkNotNullParameter((Object)backgroundExecutor, (String)"backgroundExecutor");
        this.backgroundExecutor = backgroundExecutor;
        this.observerLock = new Object();
        this.sourceObserver = new SourceObservableObserver();
        this.currentFilteredIds = CollectionsKt.emptyList();
        this.isMonitoring = new AtomicBoolean(false);
        this.dependentInternalListeners = new CopyOnWriteArrayList();
        this.publicApiListeners = new CopyOnWriteArrayList();
        this.cameraStateObservers = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public final void startup(@NotNull CameraFactory cameraFactory, @NotNull CameraRepository cameraRepository) {
        block2: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)cameraFactory, (String)"cameraFactory");
            Intrinsics.checkNotNullParameter((Object)cameraRepository, (String)"cameraRepository");
            if (!this.isMonitoring.compareAndSet(false, true)) {
                return;
            }
            Logger.i(TAG, "Starting CameraPresenceProvider monitoring.");
            Set<String> set = cameraFactory.getAvailableCameraIds();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAvailableCameraIds(...)");
            Iterable iterable = set;
            CameraPresenceProvider cameraPresenceProvider = this;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(CameraIdentifier.Companion.create$default(CameraIdentifier.Companion, (String)it, null, null, 6, null));
            }
            cameraPresenceProvider.currentFilteredIds = (List)destination$iv$iv;
            this.cameraFactory = cameraFactory;
            this.cameraRepository = cameraRepository;
            Observable<List<CameraIdentifier>> observable = this.sourcePresenceObservable = cameraFactory.getCameraPresenceSource();
            if (observable == null) break block2;
            observable.addObserver(this.backgroundExecutor, this.sourceObserver);
        }
    }

    public final void shutdown() {
        if (!this.isMonitoring.getAndSet(false)) {
            Logger.d(TAG, "Shutdown called when not monitoring. Ignoring.");
            return;
        }
        Logger.i(TAG, "Shutting down CameraPresenceProvider monitoring.");
        Observable<List<CameraIdentifier>> observable = this.sourcePresenceObservable;
        if (observable != null) {
            observable.removeObserver(this.sourceObserver);
        }
        this.clearAllCameraStateObservers();
        this.dependentInternalListeners.clear();
        this.publicApiListeners.clear();
        this.currentFilteredIds = CollectionsKt.emptyList();
        this.cameraFactory = null;
        this.cameraRepository = null;
    }

    /*
     * WARNING - void declaration
     */
    private final void processFilteredCameraIdUpdate(List<CameraIdentifier> newFilteredIdentifiers) {
        Collection collection;
        Iterator $this$mapTo$iv$iv;
        List oldFilteredIdsSnapshot = CollectionsKt.toList((Iterable)this.currentFilteredIds);
        if (Intrinsics.areEqual(newFilteredIdentifiers, (Object)oldFilteredIdsSnapshot)) {
            return;
        }
        Set oldIdSet = CollectionsKt.toSet((Iterable)oldFilteredIdsSnapshot);
        Set newIdSet = CollectionsKt.toSet((Iterable)newFilteredIdentifiers);
        Set addedCameras = SetsKt.minus((Set)newIdSet, (Iterable)oldIdSet);
        Set removedCameras = SetsKt.minus((Set)oldIdSet, (Iterable)newIdSet);
        List successfullyUpdatedListeners = new ArrayList();
        Iterable $this$map$iv = newFilteredIdentifiers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Iterator it;
            Object item$iv$iv = iterator.next();
            CameraIdentifier cameraIdentifier = (CameraIdentifier)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((CameraIdentifier)((Object)it)).getInternalId());
        }
        List newFilteredIdStrings = (List)destination$iv$iv;
        try {
            Iterable $this$forEach$iv = removedCameras;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CameraIdentifier it = (CameraIdentifier)element$iv;
                boolean bl = false;
                this.removeCameraStateObserver(it.getInternalId());
            }
            CameraRepository cameraRepository = this.cameraRepository;
            if (cameraRepository != null) {
                Iterator it = cameraRepository;
                boolean bl = false;
                Logger.d(TAG, "Updating CameraRepository...");
                ((CameraRepository)((Object)it)).onCamerasUpdated(newFilteredIdStrings);
                successfullyUpdatedListeners.add(it);
                Logger.d(TAG, "CameraRepository updated successfully.");
            }
            if (!((Collection)this.dependentInternalListeners).isEmpty()) {
                Logger.d(TAG, "Updating " + this.dependentInternalListeners.size() + " dependent listeners...");
                $this$forEach$iv = this.dependentInternalListeners;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    InternalCameraPresenceListener listener = (InternalCameraPresenceListener)element$iv;
                    boolean bl = false;
                    listener.onCamerasUpdated(newFilteredIdStrings);
                    Intrinsics.checkNotNull((Object)listener);
                    successfullyUpdatedListeners.add(listener);
                }
            }
            this.currentFilteredIds = newFilteredIdentifiers;
            $this$forEach$iv = addedCameras;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CameraIdentifier it = (CameraIdentifier)element$iv;
                boolean bl = false;
                this.conditionallySetupCameraStateObserver(it.getInternalId());
            }
            this.notifyPublicListeners(addedCameras, removedCameras);
        }
        catch (Exception e) {
            void $this$mapTo$iv$iv2;
            Logger.e(TAG, "A core module failed to update. Rolling back changes.", e);
            Iterable $this$map$iv2 = oldFilteredIdsSnapshot;
            boolean $i$f$map2 = false;
            Iterable it = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                CameraIdentifier cameraIdentifier = (CameraIdentifier)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it2.getInternalId());
            }
            List oldFilteredIdStrings = (List)destination$iv$iv2;
            Iterable $this$forEach$iv = CollectionsKt.asReversedMutable((List)successfullyUpdatedListeners);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                InternalCameraPresenceListener listener = (InternalCameraPresenceListener)element$iv;
                boolean bl = false;
                try {
                    listener.onCamerasUpdated(oldFilteredIdStrings);
                }
                catch (Exception rollbackException) {
                    Logger.e(TAG, "Failed to rollback listener: " + listener, rollbackException);
                }
            }
            $this$forEach$iv = removedCameras;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CameraIdentifier it3 = (CameraIdentifier)element$iv;
                boolean bl = false;
                this.conditionallySetupCameraStateObserver(it3.getInternalId());
            }
            $this$forEach$iv = addedCameras;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CameraIdentifier it4 = (CameraIdentifier)element$iv;
                boolean bl = false;
                this.removeCameraStateObserver(it4.getInternalId());
            }
        }
    }

    private final void notifyPublicListeners(Set<CameraIdentifier> addedCameras, Set<CameraIdentifier> removedCameras) {
        if (!((Collection)addedCameras).isEmpty()) {
            Logger.i(TAG, "Notifying " + addedCameras.size() + " cameras added.");
            this.notifyPublicCamerasAdded(addedCameras);
        }
        if (!((Collection)removedCameras).isEmpty()) {
            Logger.i(TAG, "Notifying " + removedCameras.size() + " cameras removed.");
            this.notifyPublicCamerasRemoved(removedCameras);
        }
    }

    public final void addDependentInternalListener(@NotNull InternalCameraPresenceListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.dependentInternalListeners.add(listener);
    }

    public final void removeDependentInternalListener(@NotNull InternalCameraPresenceListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.dependentInternalListeners.remove(listener);
    }

    private final void conditionallySetupCameraStateObserver(String systemCameraId) {
        CameraRepository cameraRepository = this.cameraRepository;
        if (cameraRepository == null) {
            return;
        }
        CameraRepository repo = cameraRepository;
        try {
            CameraInternal cameraInternal = repo.getCamera(systemCameraId);
            Intrinsics.checkNotNullExpressionValue((Object)cameraInternal, (String)"getCamera(...)");
            CameraInternal cameraInternal2 = cameraInternal;
            CameraInfoInternal cameraInfoInternal = cameraInternal2.getCameraInfoInternal();
            Intrinsics.checkNotNullExpressionValue((Object)cameraInfoInternal, (String)"getCameraInfoInternal(...)");
            this.setupCameraStateObserver(cameraInfoInternal);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.w(TAG, "CameraInternal not found for " + systemCameraId + ". Cannot setup state observer.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setupCameraStateObserver(CameraInfoInternal cameraInfoInternal) {
        String string = cameraInfoInternal.getCameraId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getCameraId(...)");
        String cameraIdStr = string;
        if (!this.isMonitoring.get()) {
            return;
        }
        Object object = this.observerLock;
        synchronized (object) {
            boolean bl = false;
            if (this.cameraStateObservers.containsKey(cameraIdStr)) {
                return;
            }
            Observer stateObserver = arg_0 -> CameraPresenceProvider.setupCameraStateObserver$lambda$12$lambda$10(this, cameraIdStr, arg_0);
            CameraXExecutors.mainThreadExecutor().execute(() -> CameraPresenceProvider.setupCameraStateObserver$lambda$12$lambda$11(cameraInfoInternal, stateObserver));
            this.cameraStateObservers.put(cameraIdStr, (Observer<CameraState>)stateObserver);
            Logger.d(TAG, "Registered state observer for camera: " + cameraIdStr);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeCameraStateObserver(String systemCameraId) {
        Object object = this.observerLock;
        synchronized (object) {
            boolean bl = false;
            Observer<CameraState> observer = this.cameraStateObservers.remove(systemCameraId);
            CameraRepository repo = this.cameraRepository;
            if (observer != null && repo != null) {
                try {
                    CameraInternal cameraInternal = repo.getCamera(systemCameraId);
                    Intrinsics.checkNotNullExpressionValue((Object)cameraInternal, (String)"getCamera(...)");
                    CameraInternal cameraInternal2 = cameraInternal;
                    CameraXExecutors.mainThreadExecutor().execute(() -> CameraPresenceProvider.removeCameraStateObserver$lambda$14$lambda$13(cameraInternal2, observer));
                    Logger.d(TAG, "Removed state observer for: " + systemCameraId);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void clearAllCameraStateObservers() {
        Map observersToClear = null;
        Object object = this.observerLock;
        synchronized (object) {
            boolean bl = false;
            if (this.cameraStateObservers.isEmpty()) {
                return;
            }
            observersToClear = MapsKt.toMap(this.cameraStateObservers);
            this.cameraStateObservers.clear();
            Unit $i$a$-synchronized-CameraPresenceProvider$clearAllCameraStateObservers$2 = Unit.INSTANCE;
        }
        CameraRepository repo = this.cameraRepository;
        if (repo != null) {
            boolean bl;
            Collection collection;
            Object object2;
            Object $this$mapTo$iv$iv;
            LinkedHashSet<CameraInternal> linkedHashSet = repo.getCameras();
            Intrinsics.checkNotNullExpressionValue(linkedHashSet, (String)"getCameras(...)");
            Object $this$map$iv = linkedHashSet;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator<Object> iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void cameraInternal;
                Object t = iterator.next();
                object2 = (CameraInternal)t;
                collection = destination$iv$iv;
                bl = false;
                collection.add(cameraInternal.getCameraInfoInternal());
            }
            List cameraInfosToRemoveObserver = (List)destination$iv$iv;
            Logger.d(TAG, "Clearing all " + observersToClear.size() + " state observers.");
            $this$map$iv = observersToClear;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            for (Map.Entry entry : $this$mapTo$iv$iv.entrySet()) {
                object2 = entry;
                collection = destination$iv$iv;
                bl = false;
                String cameraId = (String)object2.getKey();
                Observer observer = (Observer)object2.getValue();
                CameraXExecutors.mainThreadExecutor().execute(() -> CameraPresenceProvider.clearAllCameraStateObservers$lambda$19$lambda$18(cameraInfosToRemoveObserver, observer, cameraId));
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
    }

    public final void addCameraPresenceListener(@NotNull CameraPresenceListener listener, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        ListenerWrapper wrapper = new ListenerWrapper(listener, executor);
        this.publicApiListeners.add(wrapper);
        executor.execute(() -> CameraPresenceProvider.addCameraPresenceListener$lambda$20(this, listener));
    }

    public final void removeCameraPresenceListener(@NotNull CameraPresenceListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        CollectionsKt.removeAll((List)this.publicApiListeners, arg_0 -> CameraPresenceProvider.removeCameraPresenceListener$lambda$21(listener, arg_0));
    }

    private final void notifyPublicCamerasAdded(Set<CameraIdentifier> addedIds) {
        Iterable $this$forEach$iv = this.publicApiListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ListenerWrapper wrapper = (ListenerWrapper)element$iv;
            boolean bl = false;
            wrapper.getExecutor().execute(() -> CameraPresenceProvider.notifyPublicCamerasAdded$lambda$23$lambda$22(wrapper, addedIds));
        }
    }

    private final void notifyPublicCamerasRemoved(Set<CameraIdentifier> removedIds) {
        Iterable $this$forEach$iv = this.publicApiListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ListenerWrapper wrapper = (ListenerWrapper)element$iv;
            boolean bl = false;
            wrapper.getExecutor().execute(() -> CameraPresenceProvider.notifyPublicCamerasRemoved$lambda$25$lambda$24(wrapper, removedIds));
        }
    }

    private static final void setupCameraStateObserver$lambda$12$lambda$10(CameraPresenceProvider this$0, String $cameraIdStr, CameraState cameraState) {
        block2: {
            block3: {
                block1: {
                    if (this$0.isMonitoring.get()) break block1;
                    Logger.d(TAG, "Ignore camera state change handling since already stop monitoring");
                    break block2;
                }
                CameraState cameraState2 = cameraState;
                if ((cameraState2 != null ? cameraState2.getError() : null) != null) break block3;
                CameraState cameraState3 = cameraState;
                if ((cameraState3 != null ? cameraState3.getType() : null) != CameraState.Type.CLOSED) break block2;
            }
            CameraState.StateError stateError = cameraState.getError();
            Logger.w(TAG, "Camera " + $cameraIdStr + " state changed to " + (Object)((Object)cameraState.getType()) + " with error: " + (stateError != null ? Integer.valueOf(stateError.getCode()) : null) + ". Triggering refresh.");
            Observable<List<CameraIdentifier>> observable = this$0.sourcePresenceObservable;
            if (observable != null) {
                observable.fetchData();
            }
        }
    }

    private static final void setupCameraStateObserver$lambda$12$lambda$11(CameraInfoInternal $cameraInfoInternal, Observer $stateObserver) {
        $cameraInfoInternal.getCameraState().observeForever($stateObserver);
    }

    private static final void removeCameraStateObserver$lambda$14$lambda$13(CameraInternal $cameraInternal, Observer $observer) {
        $cameraInternal.getCameraInfoInternal().getCameraState().removeObserver($observer);
    }

    /*
     * WARNING - void declaration
     */
    private static final void clearAllCameraStateObservers$lambda$19$lambda$18(List $cameraInfosToRemoveObserver, Observer $observer, String $cameraId) {
        try {
            Object v0;
            LiveData<CameraState> liveData;
            block4: {
                void $this$firstOrNull$iv;
                liveData = (LiveData<CameraState>)$cameraInfosToRemoveObserver;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CameraInfoInternal it = (CameraInfoInternal)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getCameraId(), (Object)$cameraId)) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            CameraInfoInternal cameraInfoInternal = v0;
            if (cameraInfoInternal != null && (liveData = cameraInfoInternal.getCameraState()) != null) {
                liveData.removeObserver($observer);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static final void addCameraPresenceListener$lambda$20(CameraPresenceProvider this$0, CameraPresenceListener $listener) {
        Set currentIds = CollectionsKt.toSet((Iterable)this$0.currentFilteredIds);
        if (!((Collection)currentIds).isEmpty()) {
            $listener.onCamerasAdded(currentIds);
        }
    }

    private static final boolean removeCameraPresenceListener$lambda$21(CameraPresenceListener $listener, ListenerWrapper it) {
        return Intrinsics.areEqual((Object)it.getListener(), (Object)$listener);
    }

    private static final void notifyPublicCamerasAdded$lambda$23$lambda$22(ListenerWrapper $wrapper, Set $addedIds) {
        $wrapper.getListener().onCamerasAdded($addedIds);
    }

    private static final void notifyPublicCamerasRemoved$lambda$25$lambda$24(ListenerWrapper $wrapper, Set $removedIds) {
        $wrapper.getListener().onCamerasRemoved($removedIds);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Landroidx/camera/core/impl/CameraPresenceProvider$Companion;", "", "<init>", "()V", "TAG", "", "camera-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Landroidx/camera/core/impl/CameraPresenceProvider$ListenerWrapper;", "", "listener", "Landroidx/camera/core/CameraPresenceListener;", "executor", "Ljava/util/concurrent/Executor;", "<init>", "(Landroidx/camera/core/CameraPresenceListener;Ljava/util/concurrent/Executor;)V", "getListener", "()Landroidx/camera/core/CameraPresenceListener;", "getExecutor", "()Ljava/util/concurrent/Executor;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "camera-core_release"})
    private static final class ListenerWrapper {
        @NotNull
        private final CameraPresenceListener listener;
        @NotNull
        private final Executor executor;

        public ListenerWrapper(@NotNull CameraPresenceListener listener, @NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            this.listener = listener;
            this.executor = executor;
        }

        @NotNull
        public final CameraPresenceListener getListener() {
            return this.listener;
        }

        @NotNull
        public final Executor getExecutor() {
            return this.executor;
        }

        @NotNull
        public final CameraPresenceListener component1() {
            return this.listener;
        }

        @NotNull
        public final Executor component2() {
            return this.executor;
        }

        @NotNull
        public final ListenerWrapper copy(@NotNull CameraPresenceListener listener, @NotNull Executor executor) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            return new ListenerWrapper(listener, executor);
        }

        public static /* synthetic */ ListenerWrapper copy$default(ListenerWrapper listenerWrapper, CameraPresenceListener cameraPresenceListener, Executor executor, int n, Object object) {
            if ((n & 1) != 0) {
                cameraPresenceListener = listenerWrapper.listener;
            }
            if ((n & 2) != 0) {
                executor = listenerWrapper.executor;
            }
            return listenerWrapper.copy(cameraPresenceListener, executor);
        }

        @NotNull
        public String toString() {
            return "ListenerWrapper(listener=" + this.listener + ", executor=" + this.executor + ')';
        }

        public int hashCode() {
            int result = this.listener.hashCode();
            result = result * 31 + this.executor.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ListenerWrapper)) {
                return false;
            }
            ListenerWrapper listenerWrapper = (ListenerWrapper)other;
            if (!Intrinsics.areEqual((Object)this.listener, (Object)listenerWrapper.listener)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.executor, (Object)listenerWrapper.executor);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0002H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Landroidx/camera/core/impl/CameraPresenceProvider$SourceObservableObserver;", "Landroidx/camera/core/impl/Observable$Observer;", "", "Landroidx/camera/core/CameraIdentifier;", "<init>", "(Landroidx/camera/core/impl/CameraPresenceProvider;)V", "onNewData", "", "rawCameraIdentifiers", "onError", "t", "", "camera-core_release"})
    @SourceDebugExtension(value={"SMAP\nCameraPresenseProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CameraPresenseProvider.kt\nandroidx/camera/core/impl/CameraPresenceProvider$SourceObservableObserver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,351:1\n1557#2:352\n1628#2,3:353\n1557#2:356\n1628#2,3:357\n*S KotlinDebug\n*F\n+ 1 CameraPresenseProvider.kt\nandroidx/camera/core/impl/CameraPresenceProvider$SourceObservableObserver\n*L\n109#1:352\n109#1:353,3\n119#1:356\n119#1:357,3\n*E\n"})
    private final class SourceObservableObserver
    implements Observable.Observer<List<? extends CameraIdentifier>> {
        @Override
        public void onNewData(@Nullable List<CameraIdentifier> rawCameraIdentifiers) {
            List list;
            String it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            boolean $i$f$map;
            Iterable $this$map$iv;
            if (!CameraPresenceProvider.this.isMonitoring.get()) {
                return;
            }
            CameraFactory cameraFactory = CameraPresenceProvider.this.cameraFactory;
            if (cameraFactory == null) {
                return;
            }
            CameraFactory factory = cameraFactory;
            List<CameraIdentifier> list2 = rawCameraIdentifiers;
            if (list2 != null) {
                $this$map$iv = list2;
                $i$f$map = false;
                Iterable iterable = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    CameraIdentifier cameraIdentifier = (CameraIdentifier)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(((CameraIdentifier)((Object)it)).getInternalId());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List rawIdStrings = list;
            try {
                factory.onCameraIdsUpdated(rawIdStrings);
            }
            catch (Exception e) {
                Logger.e(CameraPresenceProvider.TAG, "CameraFactory failed to update. Triggering refresh.", e);
                Observable observable = CameraPresenceProvider.this.sourcePresenceObservable;
                if (observable != null) {
                    observable.fetchData();
                }
                return;
            }
            Set<String> set = factory.getAvailableCameraIds();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getAvailableCameraIds(...)");
            $this$map$iv = set;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(CameraIdentifier.Companion.create$default(CameraIdentifier.Companion, it, null, null, 6, null));
            }
            List newFilteredIds = (List)destination$iv$iv;
            CameraPresenceProvider.this.processFilteredCameraIdUpdate(newFilteredIds);
        }

        @Override
        public void onError(@NotNull Throwable t) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                if (!CameraPresenceProvider.this.isMonitoring.get()) {
                    return;
                }
                Logger.e(CameraPresenceProvider.TAG, "Error from source camera presence observable. Triggering refresh.", t);
                Observable observable = CameraPresenceProvider.this.sourcePresenceObservable;
                if (observable == null) break block1;
                observable.fetchData();
            }
        }
    }
}

