/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.graphics.Rect;
import android.util.Range;
import android.util.Size;
import androidx.annotation.OptIn;
import androidx.camera.core.CameraIdentifier;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.CameraUseCaseAdapterProvider;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.ExperimentalSessionConfig;
import androidx.camera.core.Logger;
import androidx.camera.core.SessionConfig;
import androidx.camera.core.UseCase;
import androidx.camera.core.featuregroup.GroupableFeature;
import androidx.camera.core.featuregroup.impl.ResolvedFeatureGroup;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraConfigs;
import androidx.camera.core.impl.EncoderProfilesProvider;
import androidx.camera.core.impl.LensFacingCameraFilter;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.Timebase;
import androidx.camera.core.impl.UseCaseAdditionSimulator;
import androidx.camera.core.impl.utils.RangeUtil;
import androidx.camera.core.internal.CalculatedUseCaseInfo;
import androidx.camera.core.internal.CameraUseCaseAdapter;
import androidx.core.util.Preconditions;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface CameraInfoInternal
extends CameraInfo {
    public @NonNull String getCameraId();

    public @NonNull Object getCameraCharacteristics();

    public @Nullable Object getPhysicalCameraCharacteristics(@NonNull String var1);

    public void addSessionCaptureCallback(@NonNull Executor var1, @NonNull CameraCaptureCallback var2);

    public void removeSessionCaptureCallback(@NonNull CameraCaptureCallback var1);

    public @NonNull Quirks getCameraQuirks();

    public @NonNull EncoderProfilesProvider getEncoderProfilesProvider();

    public @NonNull Timebase getTimebase();

    public @NonNull Set<Integer> getSupportedOutputFormats();

    public @NonNull List<Size> getSupportedResolutions(int var1);

    public @NonNull List<Size> getSupportedHighResolutions(int var1);

    public @NonNull Set<DynamicRange> getSupportedDynamicRanges();

    public boolean isHighSpeedSupported();

    public @NonNull Set<Range<Integer>> getSupportedHighSpeedFrameRateRanges();

    public @NonNull Set<Range<Integer>> getSupportedHighSpeedFrameRateRangesFor(@NonNull Size var1);

    public @NonNull List<Size> getSupportedHighSpeedResolutions();

    public @NonNull List<Size> getSupportedHighSpeedResolutionsFor(@NonNull Range<Integer> var1);

    public @NonNull Rect getSensorRect();

    @Override
    @ExperimentalSessionConfig
    default public @NonNull Set<Range<Integer>> getSupportedFrameRateRanges(@NonNull SessionConfig sessionConfig) {
        Set<Range<Integer>> allSupportedFrameRates;
        int maxSupportedFrameRate;
        try {
            CalculatedUseCaseInfo info = UseCaseAdditionSimulator.simulateAddUseCases(this, sessionConfig, true);
            maxSupportedFrameRate = info.getPrimaryStreamSpecResult().getMaxSupportedFrameRate();
        }
        catch (Throwable t) {
            Logger.w("CameraInfoInternal", "Failed to get max supported frameRate by SessionConfig: " + sessionConfig, t);
            return Collections.emptySet();
        }
        Set<Range<Integer>> set = allSupportedFrameRates = sessionConfig.getSessionType() == 1 ? RangeUtil.filterFixedRanges(this.getSupportedHighSpeedFrameRateRanges()) : this.getSupportedFrameRateRanges();
        if (allSupportedFrameRates.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Range<Integer>> filteredFrameRates = new LinkedHashSet<Range<Integer>>();
        for (Range<Integer> frameRate : allSupportedFrameRates) {
            if ((Integer)frameRate.getUpper() > maxSupportedFrameRate) continue;
            filteredFrameRates.add(frameRate);
        }
        return filteredFrameRates;
    }

    public boolean isPreviewStabilizationSupported();

    public boolean isVideoStabilizationSupported();

    default public @NonNull CameraInfoInternal getImplementation() {
        return this;
    }

    default public boolean isPostviewSupported() {
        return false;
    }

    default public boolean isCaptureProcessProgressSupported() {
        return false;
    }

    @Override
    default public @NonNull CameraSelector getCameraSelector() {
        return new CameraSelector.Builder().addCameraFilter(cameraInfos -> {
            String cameraId = this.getCameraId();
            for (CameraInfo cameraInfo : cameraInfos) {
                Preconditions.checkArgument((boolean)(cameraInfo instanceof CameraInfoInternal));
                CameraInfoInternal cameraInfoInternal = (CameraInfoInternal)cameraInfo;
                if (!cameraInfoInternal.getCameraId().equals(cameraId)) continue;
                return Collections.singletonList(cameraInfo);
            }
            throw new IllegalStateException("Unable to find camera with id " + cameraId + " from list of available cameras.");
        }).addCameraFilter(new LensFacingCameraFilter(this.getLensFacing())).build();
    }

    default public boolean isUseCaseCombinationSupported(@NonNull List<@NonNull UseCase> useCases) {
        return this.isUseCaseCombinationSupported(useCases, 0);
    }

    default public boolean isUseCaseCombinationSupported(@NonNull List<@NonNull UseCase> useCases, int cameraMode) {
        return this.isUseCaseCombinationSupported(useCases, cameraMode, false);
    }

    default public boolean isUseCaseCombinationSupported(@NonNull List<@NonNull UseCase> useCases, int cameraMode, boolean isFeatureComboInvocation) {
        return this.isUseCaseCombinationSupported(useCases, cameraMode, isFeatureComboInvocation, CameraConfigs.defaultConfig());
    }

    default public boolean isUseCaseCombinationSupported(@NonNull List<@NonNull UseCase> useCases, int cameraMode, boolean isFeatureComboInvocation, @NonNull CameraConfig cameraConfig) {
        return false;
    }

    @Override
    @ExperimentalSessionConfig
    default public boolean isFeatureGroupSupported(@NonNull SessionConfig sessionConfig) {
        try {
            UseCaseAdditionSimulator.simulateAddUseCases(this, sessionConfig, false);
            return true;
        }
        catch (CameraUseCaseAdapter.CameraException | IllegalArgumentException e) {
            Logger.d("CameraInfoInternal", "CameraInfoInternal.isResolvedFeatureGroupSupported failed", e);
            return false;
        }
    }

    @OptIn(markerClass={ExperimentalSessionConfig.class})
    default public boolean isResolvedFeatureGroupSupported(@NonNull ResolvedFeatureGroup resolvedFeatureGroup, @NonNull SessionConfig sessionConfig) {
        for (GroupableFeature feature : resolvedFeatureGroup.getFeatures()) {
            if (feature.isSupportedIndividually(this, sessionConfig)) continue;
            Logger.d("CameraInfoInternal", feature + " is not supported.");
            return false;
        }
        try {
            UseCaseAdditionSimulator.simulateAddUseCases(this, sessionConfig, false, resolvedFeatureGroup);
            return true;
        }
        catch (CameraUseCaseAdapter.CameraException | IllegalArgumentException e) {
            Logger.d("CameraInfoInternal", "CameraInfoInternal.isResolvedFeatureGroupSupported failed", e);
            return false;
        }
    }

    default public void setCameraUseCaseAdapterProvider(@NonNull CameraUseCaseAdapterProvider cameraUseCaseAdapterProvider) {
        UseCaseAdditionSimulator.setCameraUseCaseAdapterProvider(cameraUseCaseAdapterProvider);
    }

    @Override
    default public @NonNull CameraIdentifier getCameraIdentifier() {
        return CameraIdentifier.create(this.getCameraId());
    }

    default public @NonNull Set<@NonNull Integer> getAvailableCapabilities() {
        return Collections.emptySet();
    }
}

