/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraControl;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.imagecapture.CameraCapturePipeline;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface CameraControlInternal
extends CameraControl {
    public static final @NonNull CameraControlInternal DEFAULT_EMPTY_INSTANCE = new CameraControlInternal(){

        @Override
        public int getFlashMode() {
            return 2;
        }

        @Override
        public void setFlashMode(int flashMode) {
        }

        @Override
        public void setZslDisabledByUserCaseConfig(boolean disabled) {
        }

        @Override
        public boolean isZslDisabledByByUserCaseConfig() {
            return false;
        }

        @Override
        public void addZslConfig(@NonNull SessionConfig.Builder sessionConfigBuilder) {
        }

        @Override
        public void clearZslConfig() {
        }

        @Override
        public @NonNull ListenableFuture<Void> enableTorch(boolean torch) {
            return Futures.immediateFuture(null);
        }

        @Override
        public @NonNull ListenableFuture<Integer> setExposureCompensationIndex(int exposure) {
            return Futures.immediateFuture(0);
        }

        @Override
        public @NonNull ListenableFuture<List<Void>> submitStillCaptureRequests(@NonNull List<CaptureConfig> captureConfigs, int captureMode, int flashType) {
            return Futures.immediateFuture(Collections.emptyList());
        }

        @Override
        public @NonNull SessionConfig getSessionConfig() {
            return SessionConfig.defaultEmptySessionConfig();
        }

        @Override
        public @NonNull ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action) {
            return Futures.immediateFuture(FocusMeteringResult.emptyInstance());
        }

        @Override
        public @NonNull ListenableFuture<Void> cancelFocusAndMetering() {
            return Futures.immediateFuture(null);
        }

        @Override
        public @NonNull ListenableFuture<Void> setZoomRatio(float ratio) {
            return Futures.immediateFuture(null);
        }

        @Override
        public @NonNull ListenableFuture<Void> setLinearZoom(float linearZoom) {
            return Futures.immediateFuture(null);
        }

        @Override
        public void addInteropConfig(@NonNull Config config) {
        }

        @Override
        public void clearInteropConfig() {
        }

        @Override
        public @NonNull Config getInteropConfig() {
            return null;
        }
    };

    public int getFlashMode();

    public void setFlashMode(int var1);

    default public void setScreenFlash(@Nullable ImageCapture.ScreenFlash screenFlash) {
    }

    public void addZslConfig(@NonNull SessionConfig.Builder var1);

    public void clearZslConfig();

    public void setZslDisabledByUserCaseConfig(boolean var1);

    public boolean isZslDisabledByByUserCaseConfig();

    default public void setLowLightBoostDisabledByUseCaseSessionConfig(boolean disabled) {
    }

    public @NonNull ListenableFuture<List<Void>> submitStillCaptureRequests(@NonNull List<CaptureConfig> var1, int var2, int var3);

    default public @NonNull ListenableFuture<CameraCapturePipeline> getCameraCapturePipelineAsync(int captureMode, int flashType) {
        return Futures.immediateFuture(new CameraCapturePipeline(){

            @Override
            public @NonNull ListenableFuture<Void> invokePreCapture() {
                return Futures.immediateFuture(null);
            }

            @Override
            public @NonNull ListenableFuture<Void> invokePostCapture() {
                return Futures.immediateFuture(null);
            }
        });
    }

    public @NonNull SessionConfig getSessionConfig();

    public void addInteropConfig(@NonNull Config var1);

    public void clearInteropConfig();

    public @NonNull Config getInteropConfig();

    default public @NonNull CameraControlInternal getImplementation() {
        return this;
    }

    default public void incrementVideoUsage() {
    }

    default public void decrementVideoUsage() {
    }

    @VisibleForTesting
    default public boolean isInVideoUsage() {
        return false;
    }

    public static final class CameraControlException
    extends Exception {
        private @NonNull CameraCaptureFailure mCameraCaptureFailure;

        public CameraControlException(@NonNull CameraCaptureFailure failure) {
            this.mCameraCaptureFailure = failure;
        }

        public CameraControlException(@NonNull CameraCaptureFailure failure, @NonNull Throwable cause) {
            super(cause);
            this.mCameraCaptureFailure = failure;
        }

        public @NonNull CameraCaptureFailure getCameraCaptureFailure() {
            return this.mCameraCaptureFailure;
        }
    }

    public static interface ControlUpdateCallback {
        public void onCameraControlUpdateSessionConfig();

        public void onCameraControlCaptureRequests(@NonNull List<CaptureConfig> var1);
    }
}

