/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Identifier;
import androidx.camera.core.impl.ReadableConfig;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.UseCaseConfigFactory;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface CameraConfig
extends ReadableConfig {
    public static final Config.Option<UseCaseConfigFactory> OPTION_USECASE_CONFIG_FACTORY = Config.Option.create("camerax.core.camera.useCaseConfigFactory", UseCaseConfigFactory.class);
    public static final Config.Option<Identifier> OPTION_COMPATIBILITY_ID = Config.Option.create("camerax.core.camera.compatibilityId", Identifier.class);
    public static final Config.Option<Integer> OPTION_USE_CASE_COMBINATION_REQUIRED_RULE = Config.Option.create("camerax.core.camera.useCaseCombinationRequiredRule", Integer.class);
    public static final Config.Option<SessionProcessor> OPTION_SESSION_PROCESSOR = Config.Option.create("camerax.core.camera.SessionProcessor", SessionProcessor.class);
    public static final Config.Option<Boolean> OPTION_ZSL_DISABLED = Config.Option.create("camerax.core.camera.isZslDisabled", Boolean.class);
    public static final Config.Option<Boolean> OPTION_POSTVIEW_SUPPORTED = Config.Option.create("camerax.core.camera.isPostviewSupported", Boolean.class);
    public static final Config.Option<PostviewFormatSelector> OPTION_POSTVIEW_FORMAT_SELECTOR = Config.Option.create("camerax.core.camera.PostviewFormatSelector", PostviewFormatSelector.class);
    public static final Config.Option<Boolean> OPTION_CAPTURE_PROCESS_PROGRESS_SUPPORTED = Config.Option.create("camerax.core.camera.isCaptureProcessProgressSupported", Boolean.class);
    public static final int REQUIRED_RULE_NONE = 0;
    public static final int REQUIRED_RULE_COEXISTING_PREVIEW_AND_IMAGE_CAPTURE = 1;
    public static final PostviewFormatSelector DEFAULT_POSTVIEW_FORMAT_SELECTOR = (stillImageFormat, supportedPostviewFormats) -> {
        if (supportedPostviewFormats.contains(35)) {
            return 35;
        }
        if (supportedPostviewFormats.contains(256)) {
            return 256;
        }
        if (supportedPostviewFormats.contains(4101)) {
            return 4101;
        }
        return 0;
    };

    default public @NonNull UseCaseConfigFactory getUseCaseConfigFactory() {
        return this.retrieveOption(OPTION_USECASE_CONFIG_FACTORY, UseCaseConfigFactory.EMPTY_INSTANCE);
    }

    public @NonNull Identifier getCompatibilityId();

    default public int getUseCaseCombinationRequiredRule() {
        return this.retrieveOption(OPTION_USE_CASE_COMBINATION_REQUIRED_RULE, 0);
    }

    default public @Nullable SessionProcessor getSessionProcessor(@Nullable SessionProcessor valueIfMissing) {
        return this.retrieveOption(OPTION_SESSION_PROCESSOR, valueIfMissing);
    }

    default public boolean isPostviewSupported() {
        return this.retrieveOption(OPTION_POSTVIEW_SUPPORTED, false);
    }

    default public @NonNull PostviewFormatSelector getPostviewFormatSelector() {
        return this.retrieveOption(OPTION_POSTVIEW_FORMAT_SELECTOR, DEFAULT_POSTVIEW_FORMAT_SELECTOR);
    }

    default public boolean isCaptureProcessProgressSupported() {
        return this.retrieveOption(OPTION_CAPTURE_PROCESS_PROGRESS_SUPPORTED, false);
    }

    default public @NonNull SessionProcessor getSessionProcessor() {
        return this.retrieveOption(OPTION_SESSION_PROCESSOR);
    }

    public static interface PostviewFormatSelector {
        public int select(int var1, @NonNull List<Integer> var2);
    }

    public static interface Builder<B> {
        public @NonNull B setUseCaseConfigFactory(@NonNull UseCaseConfigFactory var1);

        public @NonNull B setCompatibilityId(@NonNull Identifier var1);

        public @NonNull B setUseCaseCombinationRequiredRule(int var1);

        public @NonNull B setSessionProcessor(@NonNull SessionProcessor var1);

        public @NonNull B setZslDisabled(boolean var1);

        public B setPostviewSupported(boolean var1);

        public B setPostviewFormatSelector(@NonNull PostviewFormatSelector var1);

        public B setCaptureProcessProgressSupported(boolean var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequiredRule {
    }
}

