/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.hardware.camera2.CaptureResult;
import androidx.camera.core.impl.CameraCaptureMetaData;
import androidx.camera.core.impl.TagBundle;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public interface CameraCaptureResult {
    public @NonNull CameraCaptureMetaData.AfMode getAfMode();

    public @NonNull CameraCaptureMetaData.AfState getAfState();

    public @NonNull CameraCaptureMetaData.AeState getAeState();

    public @NonNull CameraCaptureMetaData.AwbState getAwbState();

    public @NonNull CameraCaptureMetaData.FlashState getFlashState();

    public @NonNull CameraCaptureMetaData.AeMode getAeMode();

    public @NonNull CameraCaptureMetaData.AwbMode getAwbMode();

    public long getTimestamp();

    public @NonNull TagBundle getTagBundle();

    default public void populateExifData( @NonNull ExifData.Builder exifBuilder) {
        exifBuilder.setFlashState(this.getFlashState());
    }

    default public @Nullable CaptureResult getCaptureResult() {
        return null;
    }

    public static final class EmptyCameraCaptureResult
    implements CameraCaptureResult {
        public static @NonNull CameraCaptureResult create() {
            return new EmptyCameraCaptureResult();
        }

        @Override
        public @NonNull CameraCaptureMetaData.AfMode getAfMode() {
            return CameraCaptureMetaData.AfMode.UNKNOWN;
        }

        @Override
        public @NonNull CameraCaptureMetaData.AfState getAfState() {
            return CameraCaptureMetaData.AfState.UNKNOWN;
        }

        @Override
        public @NonNull CameraCaptureMetaData.AeState getAeState() {
            return CameraCaptureMetaData.AeState.UNKNOWN;
        }

        @Override
        public @NonNull CameraCaptureMetaData.AwbState getAwbState() {
            return CameraCaptureMetaData.AwbState.UNKNOWN;
        }

        @Override
        public @NonNull CameraCaptureMetaData.FlashState getFlashState() {
            return CameraCaptureMetaData.FlashState.UNKNOWN;
        }

        @Override
        public @NonNull CameraCaptureMetaData.AeMode getAeMode() {
            return CameraCaptureMetaData.AeMode.UNKNOWN;
        }

        @Override
        public @NonNull CameraCaptureMetaData.AwbMode getAwbMode() {
            return CameraCaptureMetaData.AwbMode.UNKNOWN;
        }

        @Override
        public long getTimestamp() {
            return -1L;
        }

        @Override
        public @NonNull TagBundle getTagBundle() {
            return TagBundle.emptyBundle();
        }

        @Override
        public @Nullable CaptureResult getCaptureResult() {
            return null;
        }
    }
}

