/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Size;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class AutoValue_StreamSpec
extends StreamSpec {
    private final @NonNull Size resolution;
    private final @NonNull Size originalConfiguredResolution;
    private final @NonNull DynamicRange dynamicRange;
    private final int sessionType;
    private final @NonNull Range<Integer> expectedFrameRateRange;
    private final @Nullable Config implementationOptions;
    private final boolean zslDisabled;

    private AutoValue_StreamSpec(@NonNull Size resolution, @NonNull Size originalConfiguredResolution, @NonNull DynamicRange dynamicRange, int sessionType, @NonNull Range<Integer> expectedFrameRateRange, @Nullable Config implementationOptions, boolean zslDisabled) {
        this.resolution = resolution;
        this.originalConfiguredResolution = originalConfiguredResolution;
        this.dynamicRange = dynamicRange;
        this.sessionType = sessionType;
        this.expectedFrameRateRange = expectedFrameRateRange;
        this.implementationOptions = implementationOptions;
        this.zslDisabled = zslDisabled;
    }

    @Override
    public @NonNull Size getResolution() {
        return this.resolution;
    }

    @Override
    public @NonNull Size getOriginalConfiguredResolution() {
        return this.originalConfiguredResolution;
    }

    @Override
    public @NonNull DynamicRange getDynamicRange() {
        return this.dynamicRange;
    }

    @Override
    public int getSessionType() {
        return this.sessionType;
    }

    @Override
    public @NonNull Range<Integer> getExpectedFrameRateRange() {
        return this.expectedFrameRateRange;
    }

    @Override
    public @Nullable Config getImplementationOptions() {
        return this.implementationOptions;
    }

    @Override
    public boolean getZslDisabled() {
        return this.zslDisabled;
    }

    public String toString() {
        return "StreamSpec{resolution=" + this.resolution + ", originalConfiguredResolution=" + this.originalConfiguredResolution + ", dynamicRange=" + this.dynamicRange + ", sessionType=" + this.sessionType + ", expectedFrameRateRange=" + this.expectedFrameRateRange + ", implementationOptions=" + this.implementationOptions + ", zslDisabled=" + this.zslDisabled + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof StreamSpec) {
            StreamSpec that = (StreamSpec)o;
            return this.resolution.equals((Object)that.getResolution()) && this.originalConfiguredResolution.equals((Object)that.getOriginalConfiguredResolution()) && this.dynamicRange.equals(that.getDynamicRange()) && this.sessionType == that.getSessionType() && this.expectedFrameRateRange.equals(that.getExpectedFrameRateRange()) && (this.implementationOptions == null ? that.getImplementationOptions() == null : this.implementationOptions.equals(that.getImplementationOptions())) && this.zslDisabled == that.getZslDisabled();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resolution.hashCode();
        h$ *= 1000003;
        h$ ^= this.originalConfiguredResolution.hashCode();
        h$ *= 1000003;
        h$ ^= this.dynamicRange.hashCode();
        h$ *= 1000003;
        h$ ^= this.sessionType;
        h$ *= 1000003;
        h$ ^= this.expectedFrameRateRange.hashCode();
        h$ *= 1000003;
        h$ ^= this.implementationOptions == null ? 0 : this.implementationOptions.hashCode();
        h$ *= 1000003;
        return h$ ^= this.zslDisabled ? 1231 : 1237;
    }

    @Override
    public StreamSpec.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends StreamSpec.Builder {
        private @NonNull Size resolution;
        private @NonNull Size originalConfiguredResolution;
        private @NonNull DynamicRange dynamicRange;
        private Integer sessionType;
        private @NonNull Range<Integer> expectedFrameRateRange;
        private @Nullable Config implementationOptions;
        private Boolean zslDisabled;

        Builder() {
        }

        private Builder(StreamSpec source) {
            this.resolution = source.getResolution();
            this.originalConfiguredResolution = source.getOriginalConfiguredResolution();
            this.dynamicRange = source.getDynamicRange();
            this.sessionType = source.getSessionType();
            this.expectedFrameRateRange = source.getExpectedFrameRateRange();
            this.implementationOptions = source.getImplementationOptions();
            this.zslDisabled = source.getZslDisabled();
        }

        @Override
        public StreamSpec.Builder setResolution(@NonNull Size resolution) {
            if (resolution == null) {
                throw new NullPointerException("Null resolution");
            }
            this.resolution = resolution;
            return this;
        }

        @Override
        public StreamSpec.Builder setOriginalConfiguredResolution(@NonNull Size originalConfiguredResolution) {
            if (originalConfiguredResolution == null) {
                throw new NullPointerException("Null originalConfiguredResolution");
            }
            this.originalConfiguredResolution = originalConfiguredResolution;
            return this;
        }

        @Override
        public StreamSpec.Builder setDynamicRange(@NonNull DynamicRange dynamicRange) {
            if (dynamicRange == null) {
                throw new NullPointerException("Null dynamicRange");
            }
            this.dynamicRange = dynamicRange;
            return this;
        }

        @Override
        public StreamSpec.Builder setSessionType(int sessionType) {
            this.sessionType = sessionType;
            return this;
        }

        @Override
        public StreamSpec.Builder setExpectedFrameRateRange(@NonNull Range<Integer> expectedFrameRateRange) {
            if (expectedFrameRateRange == null) {
                throw new NullPointerException("Null expectedFrameRateRange");
            }
            this.expectedFrameRateRange = expectedFrameRateRange;
            return this;
        }

        @Override
        public StreamSpec.Builder setImplementationOptions(@NonNull Config implementationOptions) {
            this.implementationOptions = implementationOptions;
            return this;
        }

        @Override
        public StreamSpec.Builder setZslDisabled(boolean zslDisabled) {
            this.zslDisabled = zslDisabled;
            return this;
        }

        @Override
        public StreamSpec build() {
            String missing = "";
            if (this.resolution == null) {
                missing = missing + " resolution";
            }
            if (this.originalConfiguredResolution == null) {
                missing = missing + " originalConfiguredResolution";
            }
            if (this.dynamicRange == null) {
                missing = missing + " dynamicRange";
            }
            if (this.sessionType == null) {
                missing = missing + " sessionType";
            }
            if (this.expectedFrameRateRange == null) {
                missing = missing + " expectedFrameRateRange";
            }
            if (this.zslDisabled == null) {
                missing = missing + " zslDisabled";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_StreamSpec(this.resolution, this.originalConfiguredResolution, this.dynamicRange, this.sessionType, this.expectedFrameRateRange, this.implementationOptions, this.zslDisabled);
        }
    }
}

