/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.SessionConfig;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class AutoValue_SessionConfig_OutputConfig
extends SessionConfig.OutputConfig {
    private final @NonNull DeferrableSurface surface;
    private final @NonNull List<DeferrableSurface> sharedSurfaces;
    private final @Nullable String physicalCameraId;
    private final int mirrorMode;
    private final int surfaceGroupId;
    private final @NonNull DynamicRange dynamicRange;

    private AutoValue_SessionConfig_OutputConfig(@NonNull DeferrableSurface surface, @NonNull List<DeferrableSurface> sharedSurfaces, @Nullable String physicalCameraId, int mirrorMode, int surfaceGroupId, @NonNull DynamicRange dynamicRange) {
        this.surface = surface;
        this.sharedSurfaces = sharedSurfaces;
        this.physicalCameraId = physicalCameraId;
        this.mirrorMode = mirrorMode;
        this.surfaceGroupId = surfaceGroupId;
        this.dynamicRange = dynamicRange;
    }

    @Override
    public @NonNull DeferrableSurface getSurface() {
        return this.surface;
    }

    @Override
    public @NonNull List<DeferrableSurface> getSharedSurfaces() {
        return this.sharedSurfaces;
    }

    @Override
    public @Nullable String getPhysicalCameraId() {
        return this.physicalCameraId;
    }

    @Override
    public int getMirrorMode() {
        return this.mirrorMode;
    }

    @Override
    public int getSurfaceGroupId() {
        return this.surfaceGroupId;
    }

    @Override
    public @NonNull DynamicRange getDynamicRange() {
        return this.dynamicRange;
    }

    public String toString() {
        return "OutputConfig{surface=" + this.surface + ", sharedSurfaces=" + this.sharedSurfaces + ", physicalCameraId=" + this.physicalCameraId + ", mirrorMode=" + this.mirrorMode + ", surfaceGroupId=" + this.surfaceGroupId + ", dynamicRange=" + this.dynamicRange + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SessionConfig.OutputConfig) {
            SessionConfig.OutputConfig that = (SessionConfig.OutputConfig)o;
            return this.surface.equals(that.getSurface()) && this.sharedSurfaces.equals(that.getSharedSurfaces()) && (this.physicalCameraId == null ? that.getPhysicalCameraId() == null : this.physicalCameraId.equals(that.getPhysicalCameraId())) && this.mirrorMode == that.getMirrorMode() && this.surfaceGroupId == that.getSurfaceGroupId() && this.dynamicRange.equals(that.getDynamicRange());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.surface.hashCode();
        h$ *= 1000003;
        h$ ^= this.sharedSurfaces.hashCode();
        h$ *= 1000003;
        h$ ^= this.physicalCameraId == null ? 0 : this.physicalCameraId.hashCode();
        h$ *= 1000003;
        h$ ^= this.mirrorMode;
        h$ *= 1000003;
        h$ ^= this.surfaceGroupId;
        h$ *= 1000003;
        return h$ ^= this.dynamicRange.hashCode();
    }

    static final class Builder
    extends SessionConfig.OutputConfig.Builder {
        private @NonNull DeferrableSurface surface;
        private @NonNull List<DeferrableSurface> sharedSurfaces;
        private @Nullable String physicalCameraId;
        private Integer mirrorMode;
        private Integer surfaceGroupId;
        private @NonNull DynamicRange dynamicRange;

        Builder() {
        }

        @Override
        public SessionConfig.OutputConfig.Builder setSurface(@NonNull DeferrableSurface surface) {
            if (surface == null) {
                throw new NullPointerException("Null surface");
            }
            this.surface = surface;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setSharedSurfaces(@NonNull List<DeferrableSurface> sharedSurfaces) {
            if (sharedSurfaces == null) {
                throw new NullPointerException("Null sharedSurfaces");
            }
            this.sharedSurfaces = sharedSurfaces;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setPhysicalCameraId(@Nullable String physicalCameraId) {
            this.physicalCameraId = physicalCameraId;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setMirrorMode(int mirrorMode) {
            this.mirrorMode = mirrorMode;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setSurfaceGroupId(int surfaceGroupId) {
            this.surfaceGroupId = surfaceGroupId;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig.Builder setDynamicRange(@NonNull DynamicRange dynamicRange) {
            if (dynamicRange == null) {
                throw new NullPointerException("Null dynamicRange");
            }
            this.dynamicRange = dynamicRange;
            return this;
        }

        @Override
        public SessionConfig.OutputConfig build() {
            String missing = "";
            if (this.surface == null) {
                missing = missing + " surface";
            }
            if (this.sharedSurfaces == null) {
                missing = missing + " sharedSurfaces";
            }
            if (this.mirrorMode == null) {
                missing = missing + " mirrorMode";
            }
            if (this.surfaceGroupId == null) {
                missing = missing + " surfaceGroupId";
            }
            if (this.dynamicRange == null) {
                missing = missing + " dynamicRange";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SessionConfig_OutputConfig(this.surface, this.sharedSurfaces, this.physicalCameraId, this.mirrorMode, this.surfaceGroupId, this.dynamicRange);
        }
    }
}

