/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Size;
import androidx.camera.core.DynamicRange;
import androidx.camera.core.impl.AutoValue_AttachedSurfaceInfo;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.StreamSpec;
import androidx.camera.core.impl.SurfaceConfig;
import androidx.camera.core.impl.UseCaseConfigFactory;
import com.google.auto.value.AutoValue;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class AttachedSurfaceInfo {
    AttachedSurfaceInfo() {
    }

    public static @NonNull AttachedSurfaceInfo create(@NonNull SurfaceConfig surfaceConfig, int imageFormat, @NonNull Size size, @NonNull DynamicRange dynamicRange, @NonNull List<UseCaseConfigFactory.CaptureType> captureTypes, @Nullable Config implementationOptions, int sessionType, @NonNull Range<Integer> targetFrameRate, boolean isStrictFrameRateRequired) {
        return new AutoValue_AttachedSurfaceInfo(surfaceConfig, imageFormat, size, dynamicRange, captureTypes, implementationOptions, sessionType, targetFrameRate, isStrictFrameRateRequired);
    }

    public @NonNull StreamSpec toStreamSpec(@NonNull Config implementationOptions) {
        StreamSpec.Builder streamSpecBuilder = StreamSpec.builder(this.getSize()).setSessionType(this.getSessionType()).setExpectedFrameRateRange(this.getTargetFrameRate()).setDynamicRange(this.getDynamicRange()).setImplementationOptions(implementationOptions);
        return streamSpecBuilder.build();
    }

    public abstract @NonNull SurfaceConfig getSurfaceConfig();

    public abstract int getImageFormat();

    public abstract @NonNull Size getSize();

    public abstract @NonNull DynamicRange getDynamicRange();

    public abstract @NonNull List<UseCaseConfigFactory.CaptureType> getCaptureTypes();

    public abstract @Nullable Config getImplementationOptions();

    public abstract int getSessionType();

    public abstract @NonNull Range<Integer> getTargetFrameRate();

    public abstract boolean isStrictFrameRateRequired();
}

