/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.camera.core.CameraControl;
import androidx.camera.core.CameraInfo;
import androidx.camera.core.UseCase;
import androidx.camera.core.impl.AdapterCameraControl;
import androidx.camera.core.impl.AdapterCameraInfo;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Observable;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AdapterCameraInternal
implements CameraInternal {
    private final @NonNull CameraInternal mCameraInternal;
    private final AdapterCameraInfo mAdapterCameraInfo;
    private final AdapterCameraControl mAdapterCameraControl;

    public AdapterCameraInternal(@NonNull CameraInternal cameraInternal, @NonNull AdapterCameraInfo adapterCameraInfo) {
        this.mCameraInternal = cameraInternal;
        this.mAdapterCameraInfo = adapterCameraInfo;
        CameraConfig cameraConfig = this.mAdapterCameraInfo.getCameraConfig();
        this.mAdapterCameraControl = new AdapterCameraControl(this.mCameraInternal.getCameraControlInternal(), cameraConfig.getSessionProcessor(null));
    }

    public @NonNull CameraInternal getImplementation() {
        return this.mCameraInternal;
    }

    @Override
    public void open() {
        this.mCameraInternal.open();
    }

    @Override
    public void close() {
        this.mCameraInternal.close();
    }

    @Override
    public void setActiveResumingMode(boolean enabled) {
        this.mCameraInternal.setActiveResumingMode(enabled);
    }

    @Override
    public boolean isFrontFacing() {
        return this.mCameraInternal.isFrontFacing();
    }

    @Override
    public @NonNull ListenableFuture<Void> release() {
        return this.mCameraInternal.release();
    }

    @Override
    public @NonNull Observable<CameraInternal.State> getCameraState() {
        return this.mCameraInternal.getCameraState();
    }

    @Override
    public void attachUseCases(@NonNull Collection<UseCase> useCases) {
        this.mCameraInternal.attachUseCases(useCases);
    }

    @Override
    public void detachUseCases(@NonNull Collection<UseCase> useCases) {
        this.mCameraInternal.detachUseCases(useCases);
    }

    @Override
    public @NonNull CameraControlInternal getCameraControlInternal() {
        return this.mAdapterCameraControl;
    }

    @Override
    public @NonNull CameraInfoInternal getCameraInfoInternal() {
        return this.mAdapterCameraInfo;
    }

    @Override
    public @NonNull CameraControl getCameraControl() {
        return this.mAdapterCameraControl;
    }

    @Override
    public @NonNull CameraInfo getCameraInfo() {
        return this.mAdapterCameraInfo;
    }

    @Override
    public boolean getHasTransform() {
        return this.mCameraInternal.getHasTransform();
    }

    @Override
    public void setPrimary(boolean isPrimary) {
        this.mCameraInternal.setPrimary(isPrimary);
    }

    @Override
    public @NonNull CameraConfig getExtendedConfig() {
        return this.mCameraInternal.getExtendedConfig();
    }

    @Override
    public boolean isUseCasesCombinationSupported(UseCase ... useCases) {
        return this.mCameraInternal.isUseCasesCombinationSupported(useCases);
    }

    @Override
    public boolean isUseCasesCombinationSupportedByFramework(UseCase ... useCases) {
        return this.mCameraInternal.isUseCasesCombinationSupportedByFramework(useCases);
    }

    @Override
    public boolean isUseCasesCombinationSupported(boolean withStreamSharing, UseCase ... useCases) {
        return this.mCameraInternal.isUseCasesCombinationSupported(withStreamSharing, useCases);
    }

    @Override
    public void setExtendedConfig(@Nullable CameraConfig cameraConfig) {
        this.mCameraInternal.setExtendedConfig(cameraConfig);
    }

    @Override
    public void onUseCaseActive(@NonNull UseCase useCase) {
        this.mCameraInternal.onUseCaseActive(useCase);
    }

    @Override
    public void onUseCaseInactive(@NonNull UseCase useCase) {
        this.mCameraInternal.onUseCaseInactive(useCase);
    }

    @Override
    public void onUseCaseUpdated(@NonNull UseCase useCase) {
        this.mCameraInternal.onUseCaseUpdated(useCase);
    }

    @Override
    public void onUseCaseReset(@NonNull UseCase useCase) {
        this.mCameraInternal.onUseCaseReset(useCase);
    }
}

