/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import android.util.Rational;
import androidx.camera.core.ExposureState;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.CameraConfig;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.ForwardingCameraInfo;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.utils.LiveDataUtil;
import androidx.camera.core.impl.utils.SessionProcessorUtil;
import androidx.camera.core.internal.ImmutableZoomState;
import androidx.core.math.MathUtils;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AdapterCameraInfo
extends ForwardingCameraInfo {
    public static final int CAMERA_OPERATION_ZOOM = 0;
    public static final int CAMERA_OPERATION_AUTO_FOCUS = 1;
    public static final int CAMERA_OPERATION_AF_REGION = 2;
    public static final int CAMERA_OPERATION_AE_REGION = 3;
    public static final int CAMERA_OPERATION_AWB_REGION = 4;
    public static final int CAMERA_OPERATION_FLASH = 5;
    public static final int CAMERA_OPERATION_TORCH = 6;
    public static final int CAMERA_OPERATION_EXPOSURE_COMPENSATION = 7;
    public static final int CAMERA_OPERATION_EXTENSION_STRENGTH = 8;
    private final CameraInfoInternal mCameraInfo;
    private final @Nullable SessionProcessor mSessionProcessor;
    private boolean mIsPostviewSupported = false;
    private boolean mIsCaptureProcessProgressSupported = false;
    private final @NonNull CameraConfig mCameraConfig;
    private @Nullable LiveData<ZoomState> mExtensionZoomStateLiveData = null;

    public AdapterCameraInfo(@NonNull CameraInfoInternal cameraInfo, @NonNull CameraConfig cameraConfig) {
        super(cameraInfo);
        this.mCameraInfo = cameraInfo;
        this.mCameraConfig = cameraConfig;
        this.mSessionProcessor = cameraConfig.getSessionProcessor(null);
        this.setPostviewSupported(cameraConfig.isPostviewSupported());
        this.setCaptureProcessProgressSupported(cameraConfig.isCaptureProcessProgressSupported());
    }

    public @NonNull CameraConfig getCameraConfig() {
        return this.mCameraConfig;
    }

    @Override
    public @NonNull CameraInfoInternal getImplementation() {
        return this.mCameraInfo;
    }

    public @Nullable SessionProcessor getSessionProcessor() {
        return this.mSessionProcessor;
    }

    @Override
    public boolean hasFlashUnit() {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 5)) {
            return false;
        }
        return this.mCameraInfo.hasFlashUnit();
    }

    @Override
    public @NonNull LiveData<Integer> getTorchState() {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 6)) {
            return new MutableLiveData((Object)0);
        }
        return this.mCameraInfo.getTorchState();
    }

    public static float getZoomRatioByPercentage(float percentage, float minZoomRatio, float maxZoomRatio) {
        if (percentage == 1.0f) {
            return maxZoomRatio;
        }
        if (percentage == 0.0f) {
            return minZoomRatio;
        }
        double cropWidthInMaxZoom = 1.0f / maxZoomRatio;
        double cropWidthInMinZoom = 1.0f / minZoomRatio;
        double cropWidth = cropWidthInMinZoom + (cropWidthInMaxZoom - cropWidthInMinZoom) * (double)percentage;
        double ratio = 1.0 / cropWidth;
        return (float)MathUtils.clamp((double)ratio, (double)minZoomRatio, (double)maxZoomRatio);
    }

    public static float getPercentageByRatio(float ratio, float minZoomRatio, float maxZoomRatio) {
        if (maxZoomRatio == minZoomRatio) {
            return 0.0f;
        }
        if (ratio == maxZoomRatio) {
            return 1.0f;
        }
        if (ratio == minZoomRatio) {
            return 0.0f;
        }
        float cropWidth = 1.0f / ratio;
        float cropWidthInMaxZoom = 1.0f / maxZoomRatio;
        float cropWidthInMinZoom = 1.0f / minZoomRatio;
        return (cropWidth - cropWidthInMinZoom) / (cropWidthInMaxZoom - cropWidthInMinZoom);
    }

    @Override
    public @NonNull LiveData<ZoomState> getZoomState() {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 0)) {
            return new MutableLiveData((Object)ImmutableZoomState.create(1.0f, 1.0f, 1.0f, 0.0f));
        }
        if (this.mSessionProcessor != null) {
            ZoomState zoomState = (ZoomState)this.mCameraInfo.getZoomState().getValue();
            Range<Float> extensionsZoomRange = this.mSessionProcessor.getExtensionZoomRange();
            if (extensionsZoomRange != null && (((Float)extensionsZoomRange.getLower()).floatValue() != zoomState.getMinZoomRatio() || ((Float)extensionsZoomRange.getUpper()).floatValue() != zoomState.getMaxZoomRatio())) {
                if (this.mExtensionZoomStateLiveData == null) {
                    this.mExtensionZoomStateLiveData = LiveDataUtil.map(this.mCameraInfo.getZoomState(), state -> ImmutableZoomState.create(state.getZoomRatio(), ((Float)extensionsZoomRange.getUpper()).floatValue(), ((Float)extensionsZoomRange.getLower()).floatValue(), AdapterCameraInfo.getPercentageByRatio(state.getZoomRatio(), ((Float)extensionsZoomRange.getLower()).floatValue(), ((Float)extensionsZoomRange.getUpper()).floatValue())));
                }
                return this.mExtensionZoomStateLiveData;
            }
        }
        return this.mCameraInfo.getZoomState();
    }

    @Override
    public @NonNull ExposureState getExposureState() {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 7)) {
            return new ExposureState(){

                @Override
                public int getExposureCompensationIndex() {
                    return 0;
                }

                @Override
                public @NonNull Range<Integer> getExposureCompensationRange() {
                    return new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
                }

                @Override
                public @NonNull Rational getExposureCompensationStep() {
                    return Rational.ZERO;
                }

                @Override
                public boolean isExposureCompensationSupported() {
                    return false;
                }
            };
        }
        return this.mCameraInfo.getExposureState();
    }

    @Override
    public boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        FocusMeteringAction modifiedAction = SessionProcessorUtil.getModifiedFocusMeteringAction(this.mSessionProcessor, action);
        if (modifiedAction == null) {
            return false;
        }
        return this.mCameraInfo.isFocusMeteringSupported(modifiedAction);
    }

    public void setPostviewSupported(boolean isPostviewSupported) {
        this.mIsPostviewSupported = isPostviewSupported;
    }

    public void setCaptureProcessProgressSupported(boolean isCaptureProcessProgressSupported) {
        this.mIsCaptureProcessProgressSupported = isCaptureProcessProgressSupported;
    }

    @Override
    public boolean isPostviewSupported() {
        return this.mIsPostviewSupported;
    }

    @Override
    public boolean isCaptureProcessProgressSupported() {
        return this.mIsCaptureProcessProgressSupported;
    }

    @Override
    public boolean isVideoStabilizationSupported() {
        int[] stabilizationModes;
        if (this.mSessionProcessor != null && (stabilizationModes = this.mSessionProcessor.getExtensionAvailableStabilizationModes()) != null) {
            for (int mode : stabilizationModes) {
                if (mode != 1) continue;
                return true;
            }
            return false;
        }
        return super.isVideoStabilizationSupported();
    }

    @Override
    public boolean isPreviewStabilizationSupported() {
        int[] stabilizationModes;
        if (this.mSessionProcessor != null && (stabilizationModes = this.mSessionProcessor.getExtensionAvailableStabilizationModes()) != null) {
            for (int mode : stabilizationModes) {
                if (mode != 2) continue;
                return true;
            }
            return false;
        }
        return super.isPreviewStabilizationSupported();
    }

    @Override
    public boolean isUseCaseCombinationSupported(@NonNull List<@NonNull UseCase> useCases, int cameraMode, boolean isFeatureComboInvocation) {
        return this.mCameraInfo.isUseCaseCombinationSupported(useCases, cameraMode, isFeatureComboInvocation, this.mCameraConfig);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CameraOperation {
    }
}

