/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Range;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.impl.AdapterCameraInfo;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.ForwardingCameraControl;
import androidx.camera.core.impl.SessionProcessor;
import androidx.camera.core.impl.utils.SessionProcessorUtil;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class AdapterCameraControl
extends ForwardingCameraControl {
    private final CameraControlInternal mCameraControl;
    private final @Nullable SessionProcessor mSessionProcessor;

    public AdapterCameraControl(@NonNull CameraControlInternal cameraControl, @Nullable SessionProcessor sessionProcessor) {
        super(cameraControl);
        this.mCameraControl = cameraControl;
        this.mSessionProcessor = sessionProcessor;
    }

    @Override
    public @NonNull CameraControlInternal getImplementation() {
        return this.mCameraControl;
    }

    public @Nullable SessionProcessor getSessionProcessor() {
        return this.mSessionProcessor;
    }

    @Override
    public @NonNull ListenableFuture<Void> enableTorch(boolean torch) {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 6)) {
            return Futures.immediateFailedFuture(new IllegalStateException("Torch is not supported"));
        }
        return this.mCameraControl.enableTorch(torch);
    }

    @Override
    public @NonNull ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action) {
        FocusMeteringAction modifiedAction = SessionProcessorUtil.getModifiedFocusMeteringAction(this.mSessionProcessor, action);
        if (modifiedAction == null) {
            return Futures.immediateFailedFuture(new IllegalStateException("FocusMetering is not supported"));
        }
        return this.mCameraControl.startFocusAndMetering(modifiedAction);
    }

    @Override
    public @NonNull ListenableFuture<Void> cancelFocusAndMetering() {
        return this.mCameraControl.cancelFocusAndMetering();
    }

    @Override
    public @NonNull ListenableFuture<Void> setZoomRatio(float ratio) {
        Range<Float> extensionZoomRange;
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 0)) {
            return Futures.immediateFailedFuture(new IllegalStateException("Zoom is not supported"));
        }
        if (this.mSessionProcessor != null && (extensionZoomRange = this.mSessionProcessor.getExtensionZoomRange()) != null && (ratio < ((Float)extensionZoomRange.getLower()).floatValue() || ratio > ((Float)extensionZoomRange.getUpper()).floatValue())) {
            String outOfRangeDesc = "Requested zoomRatio " + ratio + " is not within valid range [" + extensionZoomRange.getLower() + " , " + extensionZoomRange.getUpper() + "]";
            return Futures.immediateFailedFuture(new IllegalArgumentException(outOfRangeDesc));
        }
        return this.mCameraControl.setZoomRatio(ratio);
    }

    @Override
    public @NonNull ListenableFuture<Void> setLinearZoom(float linearZoom) {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 0)) {
            return Futures.immediateFailedFuture(new IllegalStateException("Zoom is not supported"));
        }
        if (this.mSessionProcessor != null) {
            Range<Float> extensionZoomRange = this.mSessionProcessor.getExtensionZoomRange();
            if (extensionZoomRange == null) {
                return this.mCameraControl.setLinearZoom(linearZoom);
            }
            if (linearZoom > 1.0f || linearZoom < 0.0f) {
                String outOfRangeDesc = "Requested linearZoom " + linearZoom + " is not within valid range [0..1]";
                return Futures.immediateFailedFuture(new IllegalArgumentException(outOfRangeDesc));
            }
            float zoomRatio = AdapterCameraInfo.getZoomRatioByPercentage(linearZoom, ((Float)extensionZoomRange.getLower()).floatValue(), ((Float)extensionZoomRange.getUpper()).floatValue());
            return this.mCameraControl.setZoomRatio(zoomRatio);
        }
        return this.mCameraControl.setLinearZoom(linearZoom);
    }

    @Override
    public @NonNull ListenableFuture<Integer> setExposureCompensationIndex(int value) {
        if (!SessionProcessorUtil.isOperationSupported(this.mSessionProcessor, 7)) {
            return Futures.immediateFailedFuture(new IllegalStateException("ExposureCompensation is not supported"));
        }
        return this.mCameraControl.setExposureCompensationIndex(value);
    }
}

