/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.camera.core.CameraIdentifier;
import androidx.camera.core.impl.Observable;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class AbstractCameraPresenceSource
implements Observable<List<CameraIdentifier>> {
    private static final String TAG = "CameraPresenceSrc";
    private final Object mLock = new Object();
    private final List<ObserverWrapper> mObservers = new CopyOnWriteArrayList<ObserverWrapper>();
    @GuardedBy(value="mLock")
    private List<CameraIdentifier> mCurrentData;
    @GuardedBy(value="mLock")
    private Throwable mCurrentError = null;
    @GuardedBy(value="mLock")
    private boolean mIsActive = false;

    public AbstractCameraPresenceSource() {
        this(Collections.emptyList());
    }

    public AbstractCameraPresenceSource(@NonNull List<String> cameraIds) {
        ArrayList<CameraIdentifier> identifiers = new ArrayList<CameraIdentifier>();
        for (String id : cameraIds) {
            identifiers.add(CameraIdentifier.create(id));
        }
        this.mCurrentData = identifiers;
    }

    protected abstract void startMonitoring();

    protected abstract void stopMonitoring();

    protected void updateData(@NonNull List<CameraIdentifier> newData) {
        this.updateState(newData, null);
    }

    @Override
    public abstract @NonNull ListenableFuture<List<CameraIdentifier>> fetchData();

    protected void updateError(@NonNull Throwable error) {
        this.updateState(null, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateState(@Nullable List<CameraIdentifier> newData, @Nullable Throwable error) {
        Throwable errorSnapshot;
        List<CameraIdentifier> dataSnapshot;
        boolean shouldNotify;
        Iterator<ObserverWrapper> iterator = this.mLock;
        synchronized (iterator) {
            if (error != null) {
                shouldNotify = this.mCurrentError == null || !this.mCurrentData.isEmpty();
                this.mCurrentError = error;
                this.mCurrentData = Collections.emptyList();
            } else {
                Preconditions.checkNotNull(newData);
                shouldNotify = this.mCurrentError != null || !this.mCurrentData.equals(newData);
                this.mCurrentError = null;
                this.mCurrentData = newData;
            }
            dataSnapshot = Collections.unmodifiableList(this.mCurrentData);
            errorSnapshot = this.mCurrentError;
        }
        if (shouldNotify) {
            Log.d((String)TAG, (String)("Data changed. Notifying " + this.mObservers.size() + " observers. Error: " + (errorSnapshot != null)));
            for (ObserverWrapper wrapper : this.mObservers) {
                this.notifyObserver(wrapper, dataSnapshot, errorSnapshot);
            }
        }
    }

    private void notifyObserver(@NonNull ObserverWrapper wrapper, @NonNull List<CameraIdentifier> data, @Nullable Throwable error) {
        wrapper.mExecutor.execute(() -> {
            if (error != null) {
                wrapper.mObserver.onError(error);
            } else {
                wrapper.mObserver.onNewData(data);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addObserver(@NonNull Executor executor, @NonNull Observable.Observer<? super List<CameraIdentifier>> observer) {
        Throwable errorSnapshot;
        List<CameraIdentifier> dataSnapshot;
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull(observer);
        this.mObservers.add(new ObserverWrapper(executor, observer));
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mIsActive && !this.mObservers.isEmpty()) {
                Log.i((String)TAG, (String)"First observer added. Starting monitoring.");
                this.mIsActive = true;
                this.startMonitoring();
            }
            dataSnapshot = Collections.unmodifiableList(this.mCurrentData);
            errorSnapshot = this.mCurrentError;
        }
        this.notifyObserver(new ObserverWrapper(executor, observer), dataSnapshot, errorSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(@NonNull Observable.Observer<? super List<CameraIdentifier>> observerToRemove) {
        Preconditions.checkNotNull(observerToRemove);
        ObserverWrapper wrapperToRemove = null;
        for (ObserverWrapper wrapper : this.mObservers) {
            if (!wrapper.mObserver.equals(observerToRemove)) continue;
            wrapperToRemove = wrapper;
            break;
        }
        if (wrapperToRemove != null) {
            this.mObservers.remove(wrapperToRemove);
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsActive && this.mObservers.isEmpty()) {
                Log.i((String)TAG, (String)"Last observer removed. Stopping monitoring.");
                this.mIsActive = false;
                this.stopMonitoring();
            }
        }
    }

    private static class ObserverWrapper {
        final Executor mExecutor;
        final Observable.Observer<? super List<CameraIdentifier>> mObserver;

        ObserverWrapper(@NonNull Executor executor, @NonNull Observable.Observer<? super List<CameraIdentifier>> observer) {
            this.mExecutor = executor;
            this.mObserver = observer;
        }
    }
}

