/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import androidx.annotation.IntRange;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.imagecapture.AutoValue_TakePictureRequest;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.internal.compat.workaround.CaptureFailedRetryEnabler;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@AutoValue
public abstract class TakePictureRequest {
    private static final String TAG = "TakePictureRequest";
    private int mRemainingRetires = new CaptureFailedRetryEnabler().getRetryCount();
    private final Map<Integer, Boolean> mFormatCaptureStatus = new HashMap<Integer, Boolean>();

    abstract @NonNull Executor getAppExecutor();

    public abstract @Nullable ImageCapture.OnImageCapturedCallback getInMemoryCallback();

    public abstract @Nullable ImageCapture.OnImageSavedCallback getOnDiskCallback();

    public abstract @Nullable ImageCapture.OutputFileOptions getOutputFileOptions();

    public abstract @Nullable ImageCapture.OutputFileOptions getSecondaryOutputFileOptions();

    public abstract @NonNull Rect getCropRect();

    abstract @NonNull Matrix getSensorToBufferTransform();

    public abstract int getRotationDegrees();

    @IntRange(from=1L, to=100L)
    public abstract int getJpegQuality();

    abstract int getCaptureMode();

    abstract boolean isSimultaneousCapture();

    abstract @NonNull List<CameraCaptureCallback> getSessionConfigCameraCaptureCallbacks();

    @MainThread
    boolean decrementRetryCounter() {
        Threads.checkMainThread();
        if (this.mRemainingRetires > 0) {
            --this.mRemainingRetires;
            return true;
        }
        return false;
    }

    @MainThread
    void incrementRetryCounter() {
        Threads.checkMainThread();
        ++this.mRemainingRetires;
    }

    @MainThread
    @VisibleForTesting
    int getRemainingRetries() {
        Threads.checkMainThread();
        return this.mRemainingRetires;
    }

    void initFormatProcessStatusInSimultaneousCapture() {
        this.mFormatCaptureStatus.put(32, false);
        this.mFormatCaptureStatus.put(256, false);
    }

    void markFormatProcessStatusInSimultaneousCapture(int format, boolean isProcessed) {
        if (!this.mFormatCaptureStatus.containsKey(format)) {
            Logger.e(TAG, "The format is not supported in simultaneous capture");
            return;
        }
        this.mFormatCaptureStatus.put(format, isProcessed);
    }

    boolean isFormatProcessedInSimultaneousCapture() {
        boolean isProcessed = true;
        for (Map.Entry<Integer, Boolean> entry : this.mFormatCaptureStatus.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            isProcessed = false;
            break;
        }
        return isProcessed;
    }

    void onError(@NonNull ImageCaptureException imageCaptureException) {
        this.getAppExecutor().execute(() -> {
            boolean hasOnDisk;
            boolean hasInMemory = this.getInMemoryCallback() != null;
            boolean bl = hasOnDisk = this.getOnDiskCallback() != null;
            if (hasInMemory && !hasOnDisk) {
                Objects.requireNonNull(this.getInMemoryCallback()).onError(imageCaptureException);
            } else if (hasOnDisk && !hasInMemory) {
                Objects.requireNonNull(this.getOnDiskCallback()).onError(imageCaptureException);
            } else {
                throw new IllegalStateException("One and only one callback is allowed.");
            }
        });
    }

    void onResult(@Nullable ImageCapture.OutputFileResults outputFileResults) {
        this.getAppExecutor().execute(() -> Objects.requireNonNull(this.getOnDiskCallback()).onImageSaved(Objects.requireNonNull(outputFileResults)));
    }

    void onResult(@Nullable ImageProxy imageProxy) {
        this.getAppExecutor().execute(() -> Objects.requireNonNull(this.getInMemoryCallback()).onCaptureSuccess(Objects.requireNonNull(imageProxy)));
    }

    void onCaptureProcessProgressed(int progress) {
        this.getAppExecutor().execute(() -> {
            if (this.getOnDiskCallback() != null) {
                this.getOnDiskCallback().onCaptureProcessProgressed(progress);
            } else if (this.getInMemoryCallback() != null) {
                this.getInMemoryCallback().onCaptureProcessProgressed(progress);
            }
        });
    }

    void onPostviewBitmapAvailable(@NonNull Bitmap bitmap) {
        this.getAppExecutor().execute(() -> {
            if (this.getOnDiskCallback() != null) {
                this.getOnDiskCallback().onPostviewBitmapAvailable(bitmap);
            } else if (this.getInMemoryCallback() != null) {
                this.getInMemoryCallback().onPostviewBitmapAvailable(bitmap);
            }
        });
    }

    public static @NonNull TakePictureRequest of(@NonNull Executor appExecutor, @Nullable ImageCapture.OnImageCapturedCallback inMemoryCallback, @Nullable ImageCapture.OnImageSavedCallback onDiskCallback, @Nullable ImageCapture.OutputFileOptions outputFileOptions, @Nullable ImageCapture.OutputFileOptions secondaryOutputFileOptions, @NonNull Rect cropRect, @NonNull Matrix sensorToBufferTransform, int rotationDegrees, int jpegQuality, int captureMode, boolean isSimultaneousCapture, @NonNull List<CameraCaptureCallback> sessionConfigCameraCaptureCallbacks) {
        Preconditions.checkArgument((onDiskCallback == null == (outputFileOptions == null) ? 1 : 0) != 0, (Object)"onDiskCallback and outputFileOptions should be both null or both non-null.");
        Preconditions.checkArgument((boolean)(onDiskCallback == null ^ inMemoryCallback == null), (Object)"One and only one on-disk or in-memory callback should be present.");
        AutoValue_TakePictureRequest request = new AutoValue_TakePictureRequest(appExecutor, inMemoryCallback, onDiskCallback, outputFileOptions, secondaryOutputFileOptions, cropRect, sensorToBufferTransform, rotationDegrees, jpegQuality, captureMode, isSimultaneousCapture, sessionConfigCameraCaptureCallbacks);
        if (isSimultaneousCapture) {
            request.initFormatProcessStatusInSimultaneousCapture();
        }
        return request;
    }

    static interface RetryControl {
        public void retryRequest(@NonNull TakePictureRequest var1);
    }
}

