/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.imagecapture.CameraRequest;
import androidx.camera.core.imagecapture.ImageCaptureControl;
import androidx.camera.core.imagecapture.ImagePipeline;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.imagecapture.RequestWithCallback;
import androidx.camera.core.imagecapture.TakePictureManager;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.FutureCallback;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.core.util.Pair;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class TakePictureManagerImpl
implements TakePictureManager,
ForwardingImageProxy.OnImageCloseListener,
TakePictureRequest.RetryControl {
    private static final String TAG = "TakePictureManagerImpl";
    @VisibleForTesting
    final Deque<TakePictureRequest> mNewRequests = new ArrayDeque<TakePictureRequest>();
    final ImageCaptureControl mImageCaptureControl;
    ImagePipeline mImagePipeline;
    private @Nullable RequestWithCallback mCapturingRequest;
    private final List<RequestWithCallback> mIncompleteRequests;
    boolean mPaused = false;

    @MainThread
    public TakePictureManagerImpl(@NonNull ImageCaptureControl imageCaptureControl) {
        Threads.checkMainThread();
        this.mImageCaptureControl = imageCaptureControl;
        this.mIncompleteRequests = new ArrayList<RequestWithCallback>();
    }

    @Override
    @MainThread
    public void setImagePipeline(@NonNull ImagePipeline imagePipeline) {
        Threads.checkMainThread();
        this.mImagePipeline = imagePipeline;
        this.mImagePipeline.setOnImageCloseListener(this);
    }

    @Override
    @MainThread
    public void offerRequest(@NonNull TakePictureRequest takePictureRequest) {
        Threads.checkMainThread();
        this.mNewRequests.offer(takePictureRequest);
        this.issueNextRequest();
    }

    @Override
    @MainThread
    public void retryRequest(@NonNull TakePictureRequest request) {
        Threads.checkMainThread();
        Logger.d(TAG, "Add a new request for retrying.");
        this.mNewRequests.addFirst(request);
        this.issueNextRequest();
    }

    @Override
    @MainThread
    public void pause() {
        Threads.checkMainThread();
        this.mPaused = true;
        if (this.mCapturingRequest != null) {
            this.mCapturingRequest.abortSilentlyAndRetry();
        }
    }

    @Override
    @MainThread
    public void resume() {
        Threads.checkMainThread();
        this.mPaused = false;
        this.issueNextRequest();
    }

    @Override
    @MainThread
    public void abortRequests() {
        Threads.checkMainThread();
        ImageCaptureException exception = new ImageCaptureException(3, "Camera is closed.", null);
        for (TakePictureRequest request : this.mNewRequests) {
            request.onError(exception);
        }
        this.mNewRequests.clear();
        ArrayList<RequestWithCallback> requestsSnapshot = new ArrayList<RequestWithCallback>(this.mIncompleteRequests);
        for (RequestWithCallback request : requestsSnapshot) {
            request.abortAndSendErrorToApp(exception);
        }
    }

    @MainThread
    void issueNextRequest() {
        Threads.checkMainThread();
        Log.d((String)TAG, (String)"Issue the next TakePictureRequest.");
        if (this.hasCapturingRequest()) {
            Log.d((String)TAG, (String)"There is already a request in-flight.");
            return;
        }
        if (this.mPaused) {
            Log.d((String)TAG, (String)"The class is paused.");
            return;
        }
        if (this.mImagePipeline.getCapacity() == 0) {
            Log.d((String)TAG, (String)"Too many acquire images. Close image to be able to process next.");
            return;
        }
        TakePictureRequest request = this.mNewRequests.poll();
        if (request == null) {
            Log.d((String)TAG, (String)"No new request.");
            return;
        }
        RequestWithCallback requestWithCallback = new RequestWithCallback(request, this);
        this.trackCurrentRequests(requestWithCallback);
        Pair<CameraRequest, ProcessingRequest> requests = this.mImagePipeline.createRequests(request, requestWithCallback, requestWithCallback.getCaptureFuture());
        CameraRequest cameraRequest = Objects.requireNonNull((CameraRequest)requests.first);
        ProcessingRequest processingRequest = Objects.requireNonNull((ProcessingRequest)requests.second);
        this.mImagePipeline.submitProcessingRequest(processingRequest);
        ListenableFuture<Void> captureRequestFuture = this.submitCameraRequest(cameraRequest);
        requestWithCallback.setCaptureRequestFuture(captureRequestFuture);
    }

    private void trackCurrentRequests(@NonNull RequestWithCallback requestWithCallback) {
        Preconditions.checkState((!this.hasCapturingRequest() ? 1 : 0) != 0);
        this.mCapturingRequest = requestWithCallback;
        this.mCapturingRequest.getCaptureFuture().addListener(() -> {
            this.mCapturingRequest = null;
            this.issueNextRequest();
        }, CameraXExecutors.directExecutor());
        this.mIncompleteRequests.add(requestWithCallback);
        requestWithCallback.getCompleteFuture().addListener(() -> this.mIncompleteRequests.remove(requestWithCallback), CameraXExecutors.directExecutor());
    }

    @MainThread
    private ListenableFuture<Void> submitCameraRequest(final @NonNull CameraRequest cameraRequest) {
        Threads.checkMainThread();
        this.mImageCaptureControl.lockFlashMode();
        ListenableFuture<Void> captureRequestFuture = this.mImageCaptureControl.submitStillCaptureRequests(cameraRequest.getCaptureConfigs());
        Futures.addCallback(captureRequestFuture, new FutureCallback<Void>(){

            @Override
            public void onSuccess(@Nullable Void result) {
                TakePictureManagerImpl.this.mImageCaptureControl.unlockFlashMode();
            }

            @Override
            public void onFailure(@NonNull Throwable throwable) {
                if (cameraRequest.isAborted()) {
                    return;
                }
                int requestId = cameraRequest.getCaptureConfigs().get(0).getId();
                if (throwable instanceof ImageCaptureException) {
                    TakePictureManagerImpl.this.mImagePipeline.notifyCaptureError(TakePictureManager.CaptureError.of(requestId, (ImageCaptureException)throwable));
                } else {
                    TakePictureManagerImpl.this.mImagePipeline.notifyCaptureError(TakePictureManager.CaptureError.of(requestId, new ImageCaptureException(2, "Failed to submit capture request", throwable)));
                }
                TakePictureManagerImpl.this.mImageCaptureControl.unlockFlashMode();
            }
        }, CameraXExecutors.mainThreadExecutor());
        return captureRequestFuture;
    }

    @Override
    @VisibleForTesting
    public boolean hasCapturingRequest() {
        return this.mCapturingRequest != null;
    }

    @Override
    @VisibleForTesting
    public @Nullable RequestWithCallback getCapturingRequest() {
        return this.mCapturingRequest;
    }

    @Override
    @VisibleForTesting
    public @NonNull List<RequestWithCallback> getIncompleteRequests() {
        return this.mIncompleteRequests;
    }

    @Override
    @VisibleForTesting
    public @NonNull ImagePipeline getImagePipeline() {
        return this.mImagePipeline;
    }

    @Override
    public void onImageClose(@NonNull ImageProxy image) {
        CameraXExecutors.mainThreadExecutor().execute(this::issueNextRequest);
    }
}

