/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.Image;
import androidx.annotation.GuardedBy;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.impl.TagBundle;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.processing.Packet;
import androidx.core.util.Preconditions;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class RgbaImageProxy
implements ImageProxy {
    private final Object mLock = new Object();
    private final int mWidth;
    private final int mHeight;
    private final @NonNull Rect mCropRect;
    @GuardedBy(value="mLock")
    ImageProxy.PlaneProxy @Nullable [] mPlaneProxy;
    private final @NonNull ImageInfo mImageInfo;

    public RgbaImageProxy(@NonNull Packet<Bitmap> packet) {
        this(packet.getData(), packet.getCropRect(), packet.getRotationDegrees(), packet.getSensorToBufferTransform(), packet.getCameraCaptureResult().getTimestamp());
    }

    public RgbaImageProxy(@NonNull Bitmap bitmap, @NonNull Rect cropRect, int rotationDegrees, @NonNull Matrix sensorToBuffer, long timestamp) {
        this(ImageUtil.createDirectByteBuffer(bitmap), 4, bitmap.getWidth(), bitmap.getHeight(), cropRect, rotationDegrees, sensorToBuffer, timestamp);
    }

    public RgbaImageProxy(@NonNull ByteBuffer byteBuffer, int pixelStride, int width, int height, @NonNull Rect cropRect, int rotationDegrees, @NonNull Matrix sensorToBuffer, long timestamp) {
        this.mWidth = width;
        this.mHeight = height;
        this.mCropRect = cropRect;
        this.mImageInfo = RgbaImageProxy.createImageInfo(timestamp, rotationDegrees, sensorToBuffer);
        byteBuffer.rewind();
        this.mPlaneProxy = new ImageProxy.PlaneProxy[]{RgbaImageProxy.createPlaneProxy(byteBuffer, width * pixelStride, pixelStride)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            this.mPlaneProxy = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull Rect getCropRect() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            return this.mCropRect;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCropRect(@Nullable Rect rect) {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            if (rect != null) {
                this.mCropRect.set(rect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFormat() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getHeight() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            return this.mHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getWidth() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            return this.mWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageProxy.PlaneProxy @NonNull [] getPlanes() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            return Objects.requireNonNull(this.mPlaneProxy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @NonNull ImageInfo getImageInfo() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            return this.mImageInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ExperimentalGetImage
    public @Nullable Image getImage() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull Bitmap createBitmap() {
        Object object = this.mLock;
        synchronized (object) {
            this.checkNotClosed();
            return ImageUtil.createBitmapFromPlane(this.getPlanes(), this.getWidth(), this.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkNotClosed() {
        Object object = this.mLock;
        synchronized (object) {
            Preconditions.checkState((this.mPlaneProxy != null ? 1 : 0) != 0, (String)"The image is closed.");
        }
    }

    private static ImageProxy.PlaneProxy createPlaneProxy(final @NonNull ByteBuffer byteBuffer, final int rowStride, final int pixelStride) {
        return new ImageProxy.PlaneProxy(){

            @Override
            public int getRowStride() {
                return rowStride;
            }

            @Override
            public int getPixelStride() {
                return pixelStride;
            }

            @Override
            public @NonNull ByteBuffer getBuffer() {
                return byteBuffer;
            }
        };
    }

    private static ImageInfo createImageInfo(final long timestamp, final int rotationDegrees, final @NonNull Matrix sensorToBuffer) {
        return new ImageInfo(){

            @Override
            public @NonNull TagBundle getTagBundle() {
                throw new UnsupportedOperationException("Custom ImageProxy does not contain TagBundle");
            }

            @Override
            public long getTimestamp() {
                return timestamp;
            }

            @Override
            public int getRotationDegrees() {
                return rotationDegrees;
            }

            @Override
            public @NonNull Matrix getSensorToBufferTransformMatrix() {
                return new Matrix(sensorToBuffer);
            }

            @Override
            public void populateExifData( @NonNull ExifData.Builder exifBuilder) {
                throw new UnsupportedOperationException("Custom ImageProxy does not contain Exif data.");
            }
        };
    }
}

