/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.graphics.Bitmap;
import android.hardware.camera2.CameraCharacteristics;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.imagecapture.AutoValue_ProcessingNode_In;
import androidx.camera.core.imagecapture.AutoValue_ProcessingNode_InputPacket;
import androidx.camera.core.imagecapture.Bitmap2JpegBytes;
import androidx.camera.core.imagecapture.BitmapEffect;
import androidx.camera.core.imagecapture.DngImage2Disk;
import androidx.camera.core.imagecapture.Image2Bitmap;
import androidx.camera.core.imagecapture.Image2JpegBytes;
import androidx.camera.core.imagecapture.JpegBytes2CroppedBitmap;
import androidx.camera.core.imagecapture.JpegBytes2Disk;
import androidx.camera.core.imagecapture.JpegBytes2Image;
import androidx.camera.core.imagecapture.JpegImage2Result;
import androidx.camera.core.imagecapture.ProcessingInput2Packet;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.quirk.DeviceQuirks;
import androidx.camera.core.internal.compat.quirk.IncorrectJpegMetadataQuirk;
import androidx.camera.core.internal.compat.quirk.LowMemoryQuirk;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.processing.Edge;
import androidx.camera.core.processing.InternalImageProcessor;
import androidx.camera.core.processing.Node;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import androidx.core.util.Consumer;
import androidx.core.util.Preconditions;
import com.google.auto.value.AutoValue;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ProcessingNode
implements Node<In, Void> {
    private static final String TAG = "ProcessingNode";
    final @NonNull Executor mBlockingExecutor;
    final @Nullable InternalImageProcessor mImageProcessor;
    private final @Nullable CameraCharacteristics mCameraCharacteristics;
    @VisibleForTesting
    @Nullable DngImage2Disk mDngImage2Disk;
    private In mInputEdge;
    private Operation<InputPacket, Packet<ImageProxy>> mInput2Packet;
    private Operation<Image2JpegBytes.In, Packet<byte[]>> mImage2JpegBytes;
    private Operation<Bitmap2JpegBytes.In, Packet<byte[]>> mBitmap2JpegBytes;
    private Operation<JpegBytes2Disk.In, ImageCapture.OutputFileResults> mJpegBytes2Disk;
    private Operation<Packet<byte[]>, Packet<Bitmap>> mJpegBytes2CroppedBitmap;
    private Operation<Packet<ImageProxy>, ImageProxy> mJpegImage2Result;
    private Operation<Packet<byte[]>, Packet<ImageProxy>> mJpegBytes2Image;
    private Operation<Packet<ImageProxy>, Bitmap> mImage2Bitmap;
    private Operation<Packet<Bitmap>, Packet<Bitmap>> mBitmapEffect;
    private final Quirks mQuirks;
    private final boolean mHasIncorrectJpegMetadataQuirk;

    @VisibleForTesting
    ProcessingNode(@NonNull Executor blockingExecutor, @Nullable CameraCharacteristics cameraCharacteristics) {
        this(blockingExecutor, cameraCharacteristics, null, DeviceQuirks.getAll());
    }

    @VisibleForTesting
    ProcessingNode(@NonNull Executor blockingExecutor, @NonNull Quirks quirks, @Nullable CameraCharacteristics cameraCharacteristics) {
        this(blockingExecutor, cameraCharacteristics, null, quirks);
    }

    ProcessingNode(@NonNull Executor blockingExecutor, @Nullable CameraCharacteristics cameraCharacteristics, @Nullable InternalImageProcessor imageProcessor) {
        this(blockingExecutor, cameraCharacteristics, imageProcessor, DeviceQuirks.getAll());
    }

    ProcessingNode(@NonNull Executor blockingExecutor, @Nullable CameraCharacteristics cameraCharacteristics, @Nullable InternalImageProcessor imageProcessor, @NonNull Quirks quirks) {
        boolean isLowMemoryDevice = DeviceQuirks.get(LowMemoryQuirk.class) != null;
        this.mBlockingExecutor = isLowMemoryDevice ? CameraXExecutors.newSequentialExecutor(blockingExecutor) : blockingExecutor;
        this.mImageProcessor = imageProcessor;
        this.mCameraCharacteristics = cameraCharacteristics;
        this.mQuirks = quirks;
        this.mHasIncorrectJpegMetadataQuirk = quirks.contains(IncorrectJpegMetadataQuirk.class);
    }

    @Override
    public @NonNull Void transform(@NonNull In inputEdge) {
        this.mInputEdge = inputEdge;
        inputEdge.getEdge().setListener((Consumer<InputPacket>)((Consumer)inputPacket -> {
            if (inputPacket.getProcessingRequest().isAborted()) {
                inputPacket.getImageProxy().close();
                return;
            }
            this.mBlockingExecutor.execute(() -> this.processInputPacket((InputPacket)inputPacket));
        }));
        inputEdge.getPostviewEdge().setListener((Consumer<InputPacket>)((Consumer)inputPacket -> {
            if (inputPacket.getProcessingRequest().isAborted()) {
                Logger.w(TAG, "The postview image is closed due to request aborted");
                inputPacket.getImageProxy().close();
                return;
            }
            this.mBlockingExecutor.execute(() -> this.processPostviewInputPacket((InputPacket)inputPacket));
        }));
        this.mInput2Packet = new ProcessingInput2Packet();
        this.mImage2JpegBytes = new Image2JpegBytes(this.mQuirks);
        this.mJpegBytes2CroppedBitmap = new JpegBytes2CroppedBitmap();
        this.mBitmap2JpegBytes = new Bitmap2JpegBytes();
        this.mJpegBytes2Disk = new JpegBytes2Disk();
        this.mJpegImage2Result = new JpegImage2Result();
        this.mImage2Bitmap = new Image2Bitmap();
        if (inputEdge.getInputFormat() == 35 || this.mImageProcessor != null || this.mHasIncorrectJpegMetadataQuirk) {
            this.mJpegBytes2Image = new JpegBytes2Image();
        }
        if (this.mImageProcessor != null) {
            this.mBitmapEffect = new BitmapEffect(this.mImageProcessor);
        }
        return null;
    }

    @Override
    public void release() {
    }

    @WorkerThread
    void processInputPacket(@NonNull InputPacket inputPacket) {
        ProcessingRequest request = inputPacket.getProcessingRequest();
        try {
            boolean isSimultaneousCaptureEnabled;
            boolean bl = isSimultaneousCaptureEnabled = this.mInputEdge.getOutputFormats().size() > 1;
            if (inputPacket.getProcessingRequest().isInMemoryCapture()) {
                ImageProxy result = this.processInMemoryCapture(inputPacket);
                CameraXExecutors.mainThreadExecutor().execute(() -> request.onFinalResult(result));
            } else {
                boolean isProcessed;
                ImageCapture.OutputFileResults result = this.processOnDiskCapture(inputPacket);
                boolean bl2 = isProcessed = !isSimultaneousCaptureEnabled || request.getTakePictureRequest().isFormatProcessedInSimultaneousCapture();
                if (isProcessed) {
                    CameraXExecutors.mainThreadExecutor().execute(() -> request.onFinalResult(result));
                }
            }
        }
        catch (ImageCaptureException e) {
            this.sendError(request, e);
        }
        catch (OutOfMemoryError e) {
            this.sendError(request, new ImageCaptureException(0, "Processing failed due to low memory.", e));
        }
        catch (RuntimeException e) {
            this.sendError(request, new ImageCaptureException(0, "Processing failed.", e));
        }
    }

    @WorkerThread
    void processPostviewInputPacket(@NonNull InputPacket inputPacket) {
        ProcessingRequest request = inputPacket.getProcessingRequest();
        try {
            Packet<ImageProxy> image = this.mInput2Packet.apply(inputPacket);
            int imageFormat = image.getFormat();
            Preconditions.checkArgument((imageFormat == 35 || imageFormat == 256 || imageFormat == 4101 ? 1 : 0) != 0, (Object)String.format("Postview only supports to convert YUV, JPEG and JPEG_R format image to the postview output bitmap. Image format: %s", imageFormat));
            Bitmap bitmap = this.mImage2Bitmap.apply(image);
            CameraXExecutors.mainThreadExecutor().execute(() -> request.onPostviewBitmapAvailable(bitmap));
        }
        catch (Exception e) {
            inputPacket.getImageProxy().close();
            Logger.e(TAG, "process postview input packet failed.", e);
        }
    }

    @WorkerThread
    @NonNull ImageCapture.OutputFileResults processOnDiskCapture(@NonNull InputPacket inputPacket) throws ImageCaptureException {
        boolean isSimultaneousCaptureEnabled;
        List<Integer> outputFormats = this.mInputEdge.getOutputFormats();
        Preconditions.checkArgument((!outputFormats.isEmpty() ? 1 : 0) != 0);
        int format = outputFormats.get(0);
        Preconditions.checkArgument((ImageUtil.isJpegFormats(format) || ImageUtil.isRawFormats(format) ? 1 : 0) != 0, (Object)String.format("On-disk capture only support JPEG and JPEG/R and RAW output formats. Output format: %s", format));
        ProcessingRequest request = inputPacket.getProcessingRequest();
        Preconditions.checkArgument((request.getOutputFileOptions() != null ? 1 : 0) != 0, (Object)"OutputFileOptions cannot be empty");
        Packet<ImageProxy> originalImage = this.mInput2Packet.apply(inputPacket);
        boolean bl = isSimultaneousCaptureEnabled = outputFormats.size() > 1;
        if (isSimultaneousCaptureEnabled) {
            Preconditions.checkArgument((request.getOutputFileOptions() != null && request.getSecondaryOutputFileOptions() != null ? 1 : 0) != 0, (Object)"The number of OutputFileOptions for simultaneous capture should be at least two");
            ImageCapture.OutputFileResults outputFileResults = null;
            switch (originalImage.getFormat()) {
                case 32: {
                    outputFileResults = this.saveRawToDisk(originalImage, Objects.requireNonNull(request.getOutputFileOptions()));
                    request.getTakePictureRequest().markFormatProcessStatusInSimultaneousCapture(32, true);
                    return outputFileResults;
                }
            }
            outputFileResults = this.saveJpegToDisk(originalImage, Objects.requireNonNull(request.getSecondaryOutputFileOptions()), request.getJpegQuality());
            request.getTakePictureRequest().markFormatProcessStatusInSimultaneousCapture(256, true);
            return outputFileResults;
        }
        switch (format) {
            case 32: {
                return this.saveRawToDisk(originalImage, Objects.requireNonNull(request.getOutputFileOptions()));
            }
        }
        return this.saveJpegToDisk(originalImage, Objects.requireNonNull(request.getOutputFileOptions()), request.getJpegQuality());
    }

    private @NonNull ImageCapture.OutputFileResults saveRawToDisk(@NonNull Packet<ImageProxy> originalImage, @NonNull ImageCapture.OutputFileOptions outputFileOptions) throws ImageCaptureException {
        if (this.mDngImage2Disk == null) {
            if (this.mCameraCharacteristics == null) {
                throw new ImageCaptureException(0, "CameraCharacteristics is null, DngCreator cannot be created", null);
            }
            if (originalImage.getCameraCaptureResult().getCaptureResult() == null) {
                throw new ImageCaptureException(0, "CameraCaptureResult is null, DngCreator cannot be created", null);
            }
            this.mDngImage2Disk = new DngImage2Disk(Objects.requireNonNull(this.mCameraCharacteristics), Objects.requireNonNull(originalImage.getCameraCaptureResult().getCaptureResult()));
        }
        return this.mDngImage2Disk.apply(DngImage2Disk.In.of(originalImage.getData(), originalImage.getRotationDegrees(), Objects.requireNonNull(outputFileOptions)));
    }

    private @NonNull ImageCapture.OutputFileResults saveJpegToDisk(@NonNull Packet<ImageProxy> originalImage, @NonNull ImageCapture.OutputFileOptions outputFileOptions, int jpegQuality) throws ImageCaptureException {
        Packet<byte[]> jpegBytes = this.mImage2JpegBytes.apply(Image2JpegBytes.In.of(originalImage, jpegQuality));
        if (jpegBytes.hasCropping() || this.mBitmapEffect != null) {
            jpegBytes = this.cropAndMaybeApplyEffect(jpegBytes, jpegQuality);
        }
        return this.mJpegBytes2Disk.apply(JpegBytes2Disk.In.of(jpegBytes, Objects.requireNonNull(outputFileOptions)));
    }

    @WorkerThread
    @NonNull ImageProxy processInMemoryCapture(@NonNull InputPacket inputPacket) throws ImageCaptureException {
        boolean isSimultaneousCaptureEnabled;
        ProcessingRequest request = inputPacket.getProcessingRequest();
        Packet<ImageProxy> image = this.mInput2Packet.apply(inputPacket);
        List<Integer> outputFormats = this.mInputEdge.getOutputFormats();
        Preconditions.checkArgument((!outputFormats.isEmpty() ? 1 : 0) != 0);
        int format = outputFormats.get(0);
        if ((image.getFormat() == 35 || this.mBitmapEffect != null || this.mHasIncorrectJpegMetadataQuirk) && format == 256) {
            Packet<byte[]> jpegBytes = this.mImage2JpegBytes.apply(Image2JpegBytes.In.of(image, request.getJpegQuality()));
            if (this.mBitmapEffect != null) {
                jpegBytes = this.cropAndMaybeApplyEffect(jpegBytes, request.getJpegQuality());
            }
            image = this.mJpegBytes2Image.apply(jpegBytes);
        }
        ImageProxy imageProxy = this.mJpegImage2Result.apply(image);
        boolean bl = isSimultaneousCaptureEnabled = outputFormats.size() > 1;
        if (isSimultaneousCaptureEnabled) {
            request.getTakePictureRequest().markFormatProcessStatusInSimultaneousCapture(imageProxy.getFormat(), true);
        }
        return imageProxy;
    }

    private Packet<byte[]> cropAndMaybeApplyEffect(Packet<byte[]> jpegPacket, int jpegQuality) throws ImageCaptureException {
        Preconditions.checkState((boolean)ImageUtil.isJpegFormats(jpegPacket.getFormat()));
        Packet<Bitmap> bitmapPacket = this.mJpegBytes2CroppedBitmap.apply(jpegPacket);
        if (this.mBitmapEffect != null) {
            bitmapPacket = this.mBitmapEffect.apply(bitmapPacket);
        }
        return this.mBitmap2JpegBytes.apply(Bitmap2JpegBytes.In.of(bitmapPacket, jpegQuality));
    }

    private void sendError(@NonNull ProcessingRequest request, @NonNull ImageCaptureException e) {
        CameraXExecutors.mainThreadExecutor().execute(() -> request.onProcessFailure(e));
    }

    @VisibleForTesting
    void injectProcessingInput2Packet(@NonNull Operation<InputPacket, Packet<ImageProxy>> input2Packet) {
        this.mInput2Packet = input2Packet;
    }

    @AutoValue
    static abstract class In {
        In() {
        }

        abstract @NonNull Edge<InputPacket> getEdge();

        abstract @NonNull Edge<InputPacket> getPostviewEdge();

        abstract int getInputFormat();

        abstract @NonNull List<Integer> getOutputFormats();

        static In of(int inputFormat, @NonNull List<Integer> outputFormats) {
            return new AutoValue_ProcessingNode_In(new Edge<InputPacket>(), new Edge<InputPacket>(), inputFormat, outputFormats);
        }
    }

    @AutoValue
    static abstract class InputPacket {
        InputPacket() {
        }

        abstract @NonNull ProcessingRequest getProcessingRequest();

        abstract @NonNull ImageProxy getImageProxy();

        static InputPacket of(@NonNull ProcessingRequest processingRequest, @NonNull ImageProxy imageProxy) {
            return new AutoValue_ProcessingNode_InputPacket(processingRequest, imageProxy);
        }
    }
}

