/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.net.Uri;
import androidx.annotation.RestrictTo;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.imagecapture.AutoValue_JpegBytes2Disk_In;
import androidx.camera.core.imagecapture.FileUtil;
import androidx.camera.core.internal.compat.workaround.InvalidJpegDataParser;
import androidx.camera.core.processing.Operation;
import androidx.camera.core.processing.Packet;
import com.google.auto.value.AutoValue;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class JpegBytes2Disk
implements Operation<In, ImageCapture.OutputFileResults> {
    @Override
    public @NonNull ImageCapture.OutputFileResults apply(@NonNull In in) throws ImageCaptureException {
        Packet<byte[]> packet = in.getPacket();
        ImageCapture.OutputFileOptions options = in.getOutputFileOptions();
        File tempFile = FileUtil.createTempFile(options);
        JpegBytes2Disk.writeBytesToFile(tempFile, packet.getData());
        FileUtil.updateFileExif(tempFile, Objects.requireNonNull(packet.getExif()), options, packet.getRotationDegrees());
        Uri uri = FileUtil.moveFileToTarget(tempFile, options);
        return new ImageCapture.OutputFileResults(uri, 256);
    }

    static void writeBytesToFile(@NonNull File tempFile, byte @NonNull [] bytes) throws ImageCaptureException {
        try (FileOutputStream output = new FileOutputStream(tempFile);){
            InvalidJpegDataParser invalidJpegDataParser = new InvalidJpegDataParser();
            output.write(bytes, 0, invalidJpegDataParser.getValidDataLength(bytes));
        }
        catch (IOException e) {
            throw new ImageCaptureException(1, "Failed to write to temp file", e);
        }
    }

    @AutoValue
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static abstract class In {
        abstract @NonNull Packet<byte[]> getPacket();

        abstract @NonNull ImageCapture.OutputFileOptions getOutputFileOptions();

        public static @NonNull In of(@NonNull Packet<byte[]> jpegBytes, @NonNull ImageCapture.OutputFileOptions outputFileOptions) {
            return new AutoValue_JpegBytes2Disk_In(jpegBytes, outputFileOptions);
        }
    }
}

