/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.hardware.camera2.CameraCharacteristics;
import android.util.Size;
import androidx.annotation.MainThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.CameraEffect;
import androidx.camera.core.CaptureBundles;
import androidx.camera.core.ForwardingImageProxy;
import androidx.camera.core.MetadataImageReader;
import androidx.camera.core.imagecapture.CameraRequest;
import androidx.camera.core.imagecapture.CaptureNode;
import androidx.camera.core.imagecapture.PostviewSettings;
import androidx.camera.core.imagecapture.ProcessingNode;
import androidx.camera.core.imagecapture.ProcessingRequest;
import androidx.camera.core.imagecapture.TakePictureCallback;
import androidx.camera.core.imagecapture.TakePictureRequest;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.CaptureStage;
import androidx.camera.core.impl.ImageCaptureConfig;
import androidx.camera.core.impl.ImageInputConfig;
import androidx.camera.core.impl.SessionConfig;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.core.impl.utils.TransformUtils;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.internal.compat.workaround.ExifRotationAvailability;
import androidx.camera.core.internal.utils.ImageUtil;
import androidx.camera.core.processing.InternalImageProcessor;
import androidx.core.util.Pair;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ImagePipeline {
    static final byte JPEG_QUALITY_MAX_QUALITY = 100;
    static final byte JPEG_QUALITY_MIN_LATENCY = 95;
    private static int sNextRequestId = 0;
    static final ExifRotationAvailability EXIF_ROTATION_AVAILABILITY = new ExifRotationAvailability();
    private final @NonNull ImageCaptureConfig mUseCaseConfig;
    private final @NonNull CaptureConfig mCaptureConfig;
    private final @NonNull CaptureNode mCaptureNode;
    private final @NonNull ProcessingNode mProcessingNode;
    private final @NonNull CaptureNode.In mPipelineIn;

    @MainThread
    @VisibleForTesting
    public ImagePipeline(@NonNull ImageCaptureConfig useCaseConfig, @NonNull Size cameraSurfaceSize, @NonNull CameraCharacteristics cameraCharacteristics) {
        this(useCaseConfig, cameraSurfaceSize, cameraCharacteristics, null, false, null);
    }

    @MainThread
    public ImagePipeline(@NonNull ImageCaptureConfig useCaseConfig, @NonNull Size cameraSurfaceSize, @NonNull CameraCharacteristics cameraCharacteristics, @Nullable CameraEffect cameraEffect, boolean isVirtualCamera) {
        this(useCaseConfig, cameraSurfaceSize, cameraCharacteristics, cameraEffect, isVirtualCamera, null);
    }

    @MainThread
    public ImagePipeline(@NonNull ImageCaptureConfig useCaseConfig, @NonNull Size cameraSurfaceSize, @Nullable CameraCharacteristics cameraCharacteristics, @Nullable CameraEffect cameraEffect, boolean isVirtualCamera, @Nullable PostviewSettings postviewSettings) {
        Threads.checkMainThread();
        this.mUseCaseConfig = useCaseConfig;
        this.mCaptureConfig = CaptureConfig.Builder.createFrom(useCaseConfig).build();
        this.mCaptureNode = new CaptureNode();
        this.mProcessingNode = new ProcessingNode(Objects.requireNonNull(this.mUseCaseConfig.getIoExecutor(CameraXExecutors.ioExecutor())), cameraCharacteristics, cameraEffect != null ? new InternalImageProcessor(cameraEffect) : null);
        ArrayList<Integer> outputFormats = new ArrayList<Integer>();
        if (this.mUseCaseConfig.getSecondaryInputFormat() != 0) {
            outputFormats.add(32);
            outputFormats.add(256);
        } else {
            outputFormats.add(this.getOutputFormat());
        }
        this.mPipelineIn = CaptureNode.In.of(cameraSurfaceSize, this.mUseCaseConfig.getInputFormat(), outputFormats, isVirtualCamera, this.mUseCaseConfig.getImageReaderProxyProvider(), postviewSettings);
        ProcessingNode.In processingIn = this.mCaptureNode.transform(this.mPipelineIn);
        this.mProcessingNode.transform(processingIn);
    }

    public  @NonNull SessionConfig.Builder createSessionConfigBuilder(@NonNull Size resolution) {
        SessionConfig.Builder builder = SessionConfig.Builder.createFrom(this.mUseCaseConfig, resolution);
        builder.addNonRepeatingSurface(this.mPipelineIn.getSurface());
        if (this.mPipelineIn.getOutputFormats().size() > 1 && this.mPipelineIn.getSecondarySurface() != null) {
            builder.addNonRepeatingSurface(this.mPipelineIn.getSecondarySurface());
        }
        if (this.mPipelineIn.getPostviewSurface() != null) {
            builder.setPostviewSurface(this.mPipelineIn.getPostviewSurface());
        }
        return builder;
    }

    @MainThread
    public void close() {
        Threads.checkMainThread();
        this.mCaptureNode.release();
        this.mProcessingNode.release();
    }

    @MainThread
    public int getCapacity() {
        Threads.checkMainThread();
        return this.mCaptureNode.getCapacity();
    }

    @MainThread
    public void setOnImageCloseListener(@NonNull ForwardingImageProxy.OnImageCloseListener listener) {
        Threads.checkMainThread();
        this.mCaptureNode.setOnImageCloseListener(listener);
    }

    @MainThread
    @NonNull Pair<CameraRequest, ProcessingRequest> createRequests(@NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback, @NonNull ListenableFuture<Void> captureFuture) {
        Threads.checkMainThread();
        CaptureBundle captureBundle = this.createCaptureBundle();
        int requestId = sNextRequestId++;
        return new Pair((Object)this.createCameraRequest(requestId, captureBundle, takePictureRequest, takePictureCallback), (Object)this.createProcessingRequest(requestId, captureBundle, takePictureRequest, takePictureCallback, captureFuture));
    }

    @MainThread
    void submitProcessingRequest(@NonNull ProcessingRequest request) {
        Threads.checkMainThread();
        this.mPipelineIn.getRequestEdge().accept(request);
    }

    @MainThread
    void notifyCaptureError( @NonNull TakePictureManager.CaptureError error) {
        Threads.checkMainThread();
        this.mPipelineIn.getErrorEdge().accept(error);
    }

    private int getOutputFormat() {
        Integer bufferFormat = this.mUseCaseConfig.retrieveOption(ImageCaptureConfig.OPTION_BUFFER_FORMAT, null);
        if (bufferFormat != null) {
            return bufferFormat;
        }
        Integer inputFormat = this.mUseCaseConfig.retrieveOption(ImageInputConfig.OPTION_INPUT_FORMAT, null);
        if (inputFormat != null && inputFormat == 4101) {
            return 4101;
        }
        if (inputFormat != null && inputFormat == 32) {
            return 32;
        }
        return 256;
    }

    private @NonNull CaptureBundle createCaptureBundle() {
        return Objects.requireNonNull(this.mUseCaseConfig.getCaptureBundle(CaptureBundles.singleDefaultCaptureBundle()));
    }

    private @NonNull ProcessingRequest createProcessingRequest(int requestId, @NonNull CaptureBundle captureBundle, @NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback, @NonNull ListenableFuture<Void> captureFuture) {
        return new ProcessingRequest(captureBundle, takePictureRequest, takePictureCallback, captureFuture, requestId);
    }

    private boolean shouldEnablePostview() {
        return this.mPipelineIn.getPostviewSurface() != null;
    }

    @VisibleForTesting
    public @Nullable PostviewSettings getPostviewSettings() {
        return this.mPipelineIn.getPostviewSettings();
    }

    private CameraRequest createCameraRequest(int requestId, @NonNull CaptureBundle captureBundle, @NonNull TakePictureRequest takePictureRequest, @NonNull TakePictureCallback takePictureCallback) {
        ArrayList<CaptureConfig> captureConfigs = new ArrayList<CaptureConfig>();
        String tagBundleKey = String.valueOf(captureBundle.hashCode());
        for (CaptureStage captureStage : Objects.requireNonNull(captureBundle.getCaptureStages())) {
            boolean shouldEnablePostview;
            CaptureConfig.Builder builder = new CaptureConfig.Builder();
            builder.setTemplateType(this.mCaptureConfig.getTemplateType());
            builder.addImplementationOptions(this.mCaptureConfig.getImplementationOptions());
            builder.addAllCameraCaptureCallbacks(takePictureRequest.getSessionConfigCameraCaptureCallbacks());
            builder.addSurface(this.mPipelineIn.getSurface());
            if (this.mPipelineIn.getOutputFormats().size() > 1 && this.mPipelineIn.getSecondarySurface() != null) {
                builder.addSurface(this.mPipelineIn.getSecondarySurface());
            }
            if (shouldEnablePostview = this.shouldEnablePostview()) {
                builder.addSurface(Objects.requireNonNull(this.mPipelineIn.getPostviewSurface()));
            }
            builder.setPostviewEnabled(shouldEnablePostview);
            if (ImageUtil.isJpegFormats(this.mPipelineIn.getInputFormat()) || ImageUtil.isRawFormats(this.mPipelineIn.getInputFormat())) {
                if (EXIF_ROTATION_AVAILABILITY.isRotationOptionSupported()) {
                    builder.addImplementationOption(CaptureConfig.OPTION_ROTATION, takePictureRequest.getRotationDegrees());
                }
                builder.addImplementationOption(CaptureConfig.OPTION_JPEG_QUALITY, this.getCameraRequestJpegQuality(takePictureRequest));
            }
            builder.addImplementationOptions(captureStage.getCaptureConfig().getImplementationOptions());
            builder.addTag(tagBundleKey, captureStage.getId());
            builder.setId(requestId);
            builder.addCameraCaptureCallback(this.mPipelineIn.getCameraCaptureCallback());
            if (this.mPipelineIn.getOutputFormats().size() > 1 && this.mPipelineIn.getSecondaryCameraCaptureCallback() != null) {
                builder.addCameraCaptureCallback(this.mPipelineIn.getSecondaryCameraCaptureCallback());
            }
            captureConfigs.add(builder.build());
        }
        return new CameraRequest(captureConfigs, takePictureCallback);
    }

    int getCameraRequestJpegQuality(@NonNull TakePictureRequest request) {
        boolean isOnDisk = request.getOnDiskCallback() != null;
        boolean hasCropping = TransformUtils.hasCropping(request.getCropRect(), this.mPipelineIn.getSize());
        if (isOnDisk && hasCropping) {
            if (request.getCaptureMode() == 0) {
                return 100;
            }
            return 95;
        }
        return request.getJpegQuality();
    }

    @VisibleForTesting
    @NonNull CaptureNode getCaptureNode() {
        return this.mCaptureNode;
    }

    @VisibleForTesting
    @NonNull ProcessingNode getProcessingNode() {
        return this.mProcessingNode;
    }

    @VisibleForTesting
    public boolean expectsMetadata() {
        return this.mCaptureNode.getSafeCloseImageReaderProxy().getImageReaderProxy() instanceof MetadataImageReader;
    }
}

