/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.imagecapture;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.net.Uri;
import android.os.Build;
import androidx.camera.core.ImageCapture;
import androidx.camera.core.ImageCaptureException;
import androidx.camera.core.impl.utils.Exif;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.UUID;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class FileUtil {
    private static final String TEMP_FILE_PREFIX = "CameraX";
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final int COPY_BUFFER_SIZE = 1024;
    private static final int PENDING = 1;
    private static final int NOT_PENDING = 0;

    private FileUtil() {
    }

    static @NonNull File createTempFile(@NonNull ImageCapture.OutputFileOptions options) throws ImageCaptureException {
        try {
            File appProvidedFile = options.getFile();
            if (appProvidedFile != null) {
                return new File(appProvidedFile.getParent(), TEMP_FILE_PREFIX + UUID.randomUUID().toString() + FileUtil.getFileExtensionWithDot(appProvidedFile));
            }
            return File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        }
        catch (IOException e) {
            throw new ImageCaptureException(1, "Failed to create temp file.", e);
        }
    }

    static void updateFileExif(@NonNull File tempFile, @NonNull Exif originalExif, @NonNull ImageCapture.OutputFileOptions options, int rotationDegrees) throws ImageCaptureException {
        try {
            ImageCapture.Metadata metadata;
            Exif exif = Exif.createFromFile(tempFile);
            originalExif.copyToCroppedImage(exif);
            if (exif.getRotation() == 0 && rotationDegrees != 0) {
                exif.rotate(rotationDegrees);
            }
            if ((metadata = options.getMetadata()).isReversedHorizontal()) {
                exif.flipHorizontally();
            }
            if (metadata.isReversedVertical()) {
                exif.flipVertically();
            }
            if (metadata.getLocation() != null) {
                exif.attachLocation(metadata.getLocation());
            }
            exif.save();
        }
        catch (IOException e) {
            throw new ImageCaptureException(1, "Failed to update Exif data", e);
        }
    }

    static @Nullable Uri moveFileToTarget(@NonNull File tempFile, @NonNull ImageCapture.OutputFileOptions options) throws ImageCaptureException {
        Uri uri = null;
        try {
            if (FileUtil.isSaveToMediaStore(options)) {
                uri = FileUtil.copyFileToMediaStore(tempFile, options);
            } else if (FileUtil.isSaveToOutputStream(options)) {
                FileUtil.copyFileToOutputStream(tempFile, Objects.requireNonNull(options.getOutputStream()));
            } else if (FileUtil.isSaveToFile(options)) {
                uri = FileUtil.copyFileToFile(tempFile, Objects.requireNonNull(options.getFile()));
            }
        }
        catch (IOException e) {
            throw new ImageCaptureException(1, "Failed to write to OutputStream.", null);
        }
        finally {
            tempFile.delete();
        }
        return uri;
    }

    private static String getFileExtensionWithDot(File file) {
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex >= 0) {
            return fileName.substring(dotIndex);
        }
        return "";
    }

    private static Uri copyFileToMediaStore(@NonNull File file, @NonNull ImageCapture.OutputFileOptions options) throws ImageCaptureException {
        ContentResolver contentResolver = Objects.requireNonNull(options.getContentResolver());
        ContentValues values = options.getContentValues() != null ? new ContentValues(options.getContentValues()) : new ContentValues();
        FileUtil.setContentValuePendingFlag(values, 1);
        Uri uri = null;
        try {
            uri = contentResolver.insert(options.getSaveCollection(), values);
            if (uri == null) {
                throw new ImageCaptureException(1, "Failed to insert a MediaStore URI.", null);
            }
            FileUtil.copyTempFileToUri(file, uri, contentResolver);
        }
        catch (IOException | SecurityException e) {
            throw new ImageCaptureException(1, "Failed to write to MediaStore URI: " + uri, e);
        }
        finally {
            if (uri != null) {
                FileUtil.updateUriPendingStatus(uri, contentResolver, 0);
            }
        }
        return uri;
    }

    private static Uri copyFileToFile(@NonNull File source, @NonNull File target) throws ImageCaptureException {
        if (target.exists()) {
            target.delete();
        }
        if (!source.renameTo(target)) {
            throw new ImageCaptureException(1, "Failed to overwrite the file: " + target.getAbsolutePath(), null);
        }
        return Uri.fromFile((File)target);
    }

    private static void copyTempFileToUri(@NonNull File tempFile, @NonNull Uri uri, @NonNull ContentResolver contentResolver) throws IOException {
        try (OutputStream outputStream = contentResolver.openOutputStream(uri);){
            if (outputStream == null) {
                throw new FileNotFoundException(uri + " cannot be resolved.");
            }
            FileUtil.copyFileToOutputStream(tempFile, outputStream);
        }
    }

    private static void copyFileToOutputStream(@NonNull File file, @NonNull OutputStream outputStream) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                outputStream.write(buf, 0, len);
            }
        }
    }

    private static void updateUriPendingStatus(@NonNull Uri outputUri, @NonNull ContentResolver contentResolver, int isPending) {
        if (Build.VERSION.SDK_INT >= 29) {
            ContentValues values = new ContentValues();
            FileUtil.setContentValuePendingFlag(values, isPending);
            contentResolver.update(outputUri, values, null, null);
        }
    }

    private static void setContentValuePendingFlag(@NonNull ContentValues values, int isPending) {
        if (Build.VERSION.SDK_INT >= 29) {
            values.put("is_pending", Integer.valueOf(isPending));
        }
    }

    private static boolean isSaveToMediaStore(ImageCapture.OutputFileOptions outputFileOptions) {
        return outputFileOptions.getSaveCollection() != null && outputFileOptions.getContentResolver() != null && outputFileOptions.getContentValues() != null;
    }

    private static boolean isSaveToFile(ImageCapture.OutputFileOptions outputFileOptions) {
        return outputFileOptions.getFile() != null;
    }

    private static boolean isSaveToOutputStream(ImageCapture.OutputFileOptions outputFileOptions) {
        return outputFileOptions.getOutputStream() != null;
    }
}

